/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql.generator;

import java.util.Map;
import org.springframework.cassandra.config.KeyspaceAttributes;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.cassandra.core.cql.generator.KeyspaceCqlGenerator;
import org.springframework.cassandra.core.keyspace.CreateKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.KeyspaceOption;
import org.springframework.cassandra.core.keyspace.Option;

public class CreateKeyspaceCqlGenerator
extends KeyspaceCqlGenerator<CreateKeyspaceSpecification> {
    public static String toCql(CreateKeyspaceSpecification specification) {
        return new CreateKeyspaceCqlGenerator(specification).toCql();
    }

    public CreateKeyspaceCqlGenerator(CreateKeyspaceSpecification specification) {
        super(specification);
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        this.preambleCql(cql);
        this.optionsCql(cql);
        cql.append(";");
        return cql;
    }

    protected StringBuilder preambleCql(StringBuilder cql) {
        return CqlStringUtils.noNull(cql).append("CREATE KEYSPACE ").append(((CreateKeyspaceSpecification)this.spec()).getIfNotExists() ? "IF NOT EXISTS " : "").append(((CreateKeyspaceSpecification)this.spec()).getName());
    }

    protected StringBuilder optionsCql(StringBuilder cql) {
        Object durableWrites;
        cql = CqlStringUtils.noNull(cql);
        cql.append(" ");
        Map<String, Object> options = ((CreateKeyspaceSpecification)this.spec()).getOptions();
        Object replicationOption = options.get(KeyspaceOption.REPLICATION.getName());
        if (replicationOption == null) {
            Map<Option, Object> simpleReplicationMap = KeyspaceAttributes.newSimpleReplication();
            ((CreateKeyspaceSpecification)this.spec()).with(KeyspaceOption.REPLICATION, simpleReplicationMap);
        }
        if ((durableWrites = options.get(KeyspaceOption.DURABLE_WRITES.getName())) == null) {
            ((CreateKeyspaceSpecification)this.spec()).with(KeyspaceOption.DURABLE_WRITES, Boolean.TRUE);
        }
        if (!options.isEmpty()) {
            boolean first = true;
            cql.append("WITH ");
            if (!options.isEmpty()) {
                for (String name : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        cql.append(" AND ");
                    }
                    cql.append(name);
                    Object value = options.get(name);
                    if (value == null) continue;
                    cql.append(" = ");
                    if (value instanceof Map) {
                        this.optionValueMap((Map)value, cql);
                        continue;
                    }
                    cql.append(value.toString());
                }
            }
        }
        return cql;
    }
}

