/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import com.datastax.driver.core.DataType;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.util.Assert;

public class FieldSpecification {
    private CqlIdentifier name;
    private DataType type;

    public FieldSpecification name(String name) {
        return this.name(CqlIdentifier.cqlId(name));
    }

    public FieldSpecification name(CqlIdentifier name) {
        Assert.notNull((Object)name, (String)"CqlIdentifier must not be null");
        this.name = name;
        return this;
    }

    public FieldSpecification type(DataType type) {
        Assert.notNull((Object)type, (String)"DataType must not be null");
        this.type = type;
        return this;
    }

    public String toCql() {
        return this.toCql(null).toString();
    }

    public StringBuilder toCql(StringBuilder cql) {
        return CqlStringUtils.noNull(cql).append(this.name).append(" ").append(this.type);
    }

    public String toString() {
        return this.toCql(null).toString();
    }
}

