/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.keyspace.IndexDescriptor;
import org.springframework.data.cassandra.core.cql.keyspace.IndexNameSpecification;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CreateIndexSpecification
extends IndexNameSpecification<CreateIndexSpecification>
implements IndexDescriptor {
    @Nullable
    private CqlIdentifier tableName;
    @Nullable
    private CqlIdentifier columnName;
    private boolean ifNotExists = false;
    private ColumnFunction columnFunction = ColumnFunction.NONE;
    @Nullable
    private String using;
    private boolean custom = false;
    private final Map<String, String> options = new LinkedHashMap<String, String>();

    private CreateIndexSpecification() {
    }

    private CreateIndexSpecification(CqlIdentifier name) {
        super(name);
    }

    public static CreateIndexSpecification createIndex() {
        return new CreateIndexSpecification();
    }

    public static CreateIndexSpecification createIndex(String indexName) {
        return CreateIndexSpecification.createIndex(CqlIdentifier.of(indexName));
    }

    public static CreateIndexSpecification createIndex(CqlIdentifier indexName) {
        return new CreateIndexSpecification(indexName);
    }

    public CreateIndexSpecification tableName(String tableName) {
        return this.tableName(CqlIdentifier.of(tableName));
    }

    public CreateIndexSpecification tableName(CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"CqlIdentifier must not be null");
        this.tableName = tableName;
        return this;
    }

    @Override
    public CqlIdentifier getTableName() {
        return this.tableName;
    }

    public CreateIndexSpecification columnName(String columnName) {
        return this.columnName(CqlIdentifier.of(columnName));
    }

    public CreateIndexSpecification columnName(CqlIdentifier columnName) {
        Assert.notNull((Object)columnName, (String)"CqlIdentifier must not be null");
        this.columnName = columnName;
        return this;
    }

    @Override
    public CqlIdentifier getColumnName() {
        return this.columnName;
    }

    public CreateIndexSpecification ifNotExists() {
        return this.ifNotExists(true);
    }

    public CreateIndexSpecification ifNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
        return this;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public boolean isCustom() {
        return this.custom;
    }

    public CreateIndexSpecification using(String className) {
        if (StringUtils.hasText((String)className)) {
            this.using = className;
            this.custom = true;
        } else {
            this.using = null;
            this.custom = false;
        }
        return this;
    }

    @Override
    @Nullable
    public String getUsing() {
        return this.using;
    }

    public CreateIndexSpecification keys() {
        return this.columnFunction(ColumnFunction.KEYS);
    }

    public CreateIndexSpecification values() {
        return this.columnFunction(ColumnFunction.VALUES);
    }

    public CreateIndexSpecification entries() {
        return this.columnFunction(ColumnFunction.ENTRIES);
    }

    public CreateIndexSpecification full() {
        return this.columnFunction(ColumnFunction.FULL);
    }

    public CreateIndexSpecification columnFunction(ColumnFunction columnFunction) {
        Assert.notNull((Object)((Object)columnFunction), (String)"ColumnFunction must not be null");
        this.columnFunction = columnFunction;
        return this;
    }

    public ColumnFunction getColumnFunction() {
        return this.columnFunction;
    }

    public CreateIndexSpecification withOption(String name, String value) {
        this.options.put(name, value);
        return this;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public static enum ColumnFunction {
        NONE,
        KEYS,
        VALUES,
        ENTRIES,
        FULL;

    }
}

