/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface CriteriaDefinition {
    public ColumnName getColumnName();

    public Predicate getPredicate();

    public static enum Operators implements Operator
    {
        EQ("="),
        GT(">"),
        GTE(">="),
        LT("<"),
        LTE("<="),
        CONTAINS("CONTAINS"),
        CONTAINS_KEY("CONTAINS KEY"),
        IN("IN"),
        LIKE("LIKE");

        private final String operator;

        private Operators(String operator) {
            this.operator = operator;
        }

        @Override
        public String toString() {
            return this.operator;
        }
    }

    public static interface Operator {
        public String toString();
    }

    public static class Predicate {
        private final Operator operator;
        @Nullable
        private final Object value;

        public Predicate(Operator operator, @Nullable Object value) {
            Assert.notNull((Object)operator, (String)"Operator must not be null");
            this.operator = operator;
            this.value = value;
        }

        public Operator getOperator() {
            return this.operator;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Predicate)) {
                return false;
            }
            Predicate other = (Predicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Operator this$operator = this.getOperator();
            Operator other$operator = other.getOperator();
            if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Predicate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Operator $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

