/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.Statement;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParametersParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryExecution;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.CassandraRepositoryQuerySupport;
import org.springframework.data.cassandra.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractCassandraQuery
extends CassandraRepositoryQuerySupport {
    private final CassandraOperations operations;

    private static CassandraConverter toConverter(CassandraOperations operations) {
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        return operations.getConverter();
    }

    private static CassandraMappingContext toMappingContext(CassandraOperations operations) {
        return AbstractCassandraQuery.toConverter(operations).getMappingContext();
    }

    public AbstractCassandraQuery(CassandraQueryMethod queryMethod, CassandraOperations operations) {
        super(queryMethod, (MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)AbstractCassandraQuery.toMappingContext(operations));
        this.operations = operations;
    }

    protected CassandraOperations getOperations() {
        return this.operations;
    }

    @Nullable
    public Object execute(Object[] parameters) {
        ConvertingParameterAccessor parameterAccessor = new ConvertingParameterAccessor(AbstractCassandraQuery.toConverter(this.getOperations()), new CassandraParametersParameterAccessor(this.getQueryMethod(), parameters));
        ResultProcessor resultProcessor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        Statement statement = this.createQuery(parameterAccessor);
        CassandraQueryExecution queryExecution = this.getExecution(parameterAccessor, new CassandraQueryExecution.ResultProcessingConverter(resultProcessor, (MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)AbstractCassandraQuery.toMappingContext(this.getOperations()), this.getEntityInstantiators()));
        Class<?> resultType = this.resolveResultType(resultProcessor);
        return queryExecution.execute(statement, resultType);
    }

    private Class<?> resolveResultType(ResultProcessor resultProcessor) {
        CassandraRepositoryQuerySupport.CassandraReturnedType returnedType = new CassandraRepositoryQuerySupport.CassandraReturnedType(this, resultProcessor.getReturnedType(), this.getOperations().getConverter().getCustomConversions());
        return returnedType.isProjecting() ? returnedType.getDomainType() : returnedType.getReturnedType();
    }

    protected abstract Statement createQuery(CassandraParameterAccessor var1);

    private CassandraQueryExecution getExecution(CassandraParameterAccessor parameterAccessor, Converter<Object, Object> resultProcessing) {
        return new CassandraQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(parameterAccessor, resultProcessing), resultProcessing);
    }

    private CassandraQueryExecution getExecutionToWrap(CassandraParameterAccessor parameterAccessor, Converter<Object, Object> resultProcessing) {
        if (this.getQueryMethod().isSliceQuery()) {
            return new CassandraQueryExecution.SlicedExecution(this.getOperations(), parameterAccessor.getPageable());
        }
        if (this.getQueryMethod().isCollectionQuery()) {
            return new CassandraQueryExecution.CollectionExecution(this.getOperations());
        }
        if (this.getQueryMethod().isResultSetQuery()) {
            return new CassandraQueryExecution.ResultSetQuery(this.getOperations());
        }
        if (this.getQueryMethod().isStreamQuery()) {
            return new CassandraQueryExecution.StreamExecution(this.getOperations(), resultProcessing);
        }
        if (this.isCountQuery()) {
            return (statement, type) -> new CassandraQueryExecution.SingleEntityExecution(this.getOperations(), false).execute(statement, Long.class);
        }
        if (this.isExistsQuery()) {
            return new CassandraQueryExecution.ExistsExecution(this.getOperations());
        }
        return new CassandraQueryExecution.SingleEntityExecution(this.getOperations(), this.isLimiting());
    }

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isLimiting();
}

