/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import lombok.NonNull;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.ReactiveInsertOperation;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class ReactiveInsertOperationSupport
implements ReactiveInsertOperation {
    @NonNull
    private final ReactiveCassandraTemplate template;

    @Override
    public <T> ReactiveInsertOperation.ReactiveInsert<T> insert(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveInsertSupport<T>(this.template, domainType, InsertOptions.empty(), null);
    }

    public ReactiveInsertOperationSupport(@NonNull ReactiveCassandraTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        this.template = template;
    }

    static class ReactiveInsertSupport<T>
    implements ReactiveInsertOperation.ReactiveInsert<T> {
        @NonNull
        private final ReactiveCassandraTemplate template;
        @NonNull
        private final Class<T> domainType;
        @NonNull
        private final InsertOptions insertOptions;
        @Nullable
        private final CqlIdentifier tableName;

        @Override
        public ReactiveInsertOperation.InsertWithOptions<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveInsertSupport<T>(this.template, this.domainType, this.insertOptions, tableName);
        }

        @Override
        public ReactiveInsertOperation.TerminatingInsert<T> withOptions(InsertOptions insertOptions) {
            Assert.notNull((Object)insertOptions, (String)"InsertOptions must not be null");
            return new ReactiveInsertSupport<T>(this.template, this.domainType, insertOptions, this.tableName);
        }

        @Override
        public Mono<EntityWriteResult<T>> one(T object) {
            Assert.notNull(object, (String)"Object must not be null");
            return this.template.doInsert(object, this.insertOptions, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }

        public ReactiveInsertSupport(@NonNull ReactiveCassandraTemplate template, @NonNull Class<T> domainType, @NonNull InsertOptions insertOptions, @Nullable CqlIdentifier tableName) {
            if (template == null) {
                throw new NullPointerException("template is marked non-null but is null");
            }
            if (domainType == null) {
                throw new NullPointerException("domainType is marked non-null but is null");
            }
            if (insertOptions == null) {
                throw new NullPointerException("insertOptions is marked non-null but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.insertOptions = insertOptions;
            this.tableName = tableName;
        }
    }
}

