/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.convert.SchemaFactory;

public interface CassandraAdminOperations
extends CassandraOperations {
    public SchemaFactory getSchemaFactory();

    default public void createTable(boolean ifNotExists, Class<?> entityClass) {
        this.createTable(ifNotExists, entityClass, Collections.emptyMap());
    }

    default public void createTable(boolean ifNotExists, Class<?> entityClass, Map<String, Object> optionsByName) {
        this.createTable(ifNotExists, this.getTableName(entityClass), entityClass, optionsByName);
    }

    public void createTable(boolean var1, CqlIdentifier var2, Class<?> var3, Map<String, Object> var4);

    public void dropTable(Class<?> var1);

    public void dropTable(CqlIdentifier var1);

    public void dropTable(boolean var1, CqlIdentifier var2);

    public void dropUserType(CqlIdentifier var1);

    public KeyspaceMetadata getKeyspaceMetadata();

    default public Optional<TableMetadata> getTableMetadata(String keyspace, CqlIdentifier tableName) {
        return this.getTableMetadata(CqlIdentifier.fromCql((String)keyspace), tableName);
    }

    public Optional<TableMetadata> getTableMetadata(CqlIdentifier var1, CqlIdentifier var2);
}

