/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import org.springframework.util.Assert;

public final class Tuple<S, T> {
    private final T second;
    private final S first;

    Tuple(S first, T second) {
        Assert.notNull(first, (String)"First tuple element must not be null!");
        Assert.notNull(second, (String)"Second tuple element must not be null!");
        this.second = second;
        this.first = first;
    }

    public static <S, T> Tuple<S, T> of(S first, T second) {
        return new Tuple<S, T>(first, second);
    }

    public S getFirst() {
        return this.first;
    }

    public T getSecond() {
        return this.second;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple that = (Tuple)obj;
        return this.first.equals(that.first) && this.second.equals(that.second);
    }

    public int hashCode() {
        int result = 31;
        result += 17 * this.first.hashCode();
        return result += 17 * this.second.hashCode();
    }
}

