/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.List;
import java.util.Map;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public final class ProxyUtils {
    private static Map<Class<?>, Class<?>> USER_TYPES = new ConcurrentReferenceHashMap();
    private static final List<ProxyDetector> DETECTORS = SpringFactoriesLoader.loadFactories(ProxyDetector.class, (ClassLoader)ProxyUtils.class.getClassLoader());

    public static Class<?> getUserClass(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        Class<?> result = USER_TYPES.get(type);
        if (result != null) {
            return result;
        }
        result = type;
        for (ProxyDetector proxyDetector : DETECTORS) {
            result = proxyDetector.getUserType(result);
        }
        USER_TYPES.put(type, result);
        return result;
    }

    public static Class<?> getUserClass(Object source) {
        Assert.notNull((Object)source, (String)"Source object must not be null!");
        return ProxyUtils.getUserClass(source.getClass());
    }

    private ProxyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        DETECTORS.add(new ProxyDetector(){

            @Override
            public Class<?> getUserType(Class<?> type) {
                return ClassUtils.getUserClass(type);
            }
        });
    }

    public static interface ProxyDetector {
        public Class<?> getUserType(Class<?> var1);
    }
}

