/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class PersistentEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID> {
    private final PersistentEntity<T, ?> persistentEntity;

    public PersistentEntityInformation(PersistentEntity<T, ?> entity) {
        super(entity.getType());
        this.persistentEntity = entity;
    }

    @Override
    public ID getId(T entity) {
        return (ID)((Serializable)BeanWrapper.create(entity, null).getProperty((PersistentProperty<?>)this.persistentEntity.getIdProperty()));
    }

    @Override
    public Class<ID> getIdType() {
        return this.persistentEntity.getIdProperty().getType();
    }
}

