/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.BiPredicate;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryInformation;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.util.Assert;

public class ReactiveRepositoryInformation
extends DefaultRepositoryInformation {
    public ReactiveRepositoryInformation(RepositoryMetadata metadata, Class<?> repositoryBaseClass, Class<?> customImplementationClass) {
        super(metadata, repositoryBaseClass, customImplementationClass);
    }

    @Override
    Method getTargetClassMethod(Method method, Class<?> baseClass) {
        Method candidate;
        if (baseClass == null) {
            return method;
        }
        if (ReactiveRepositoryInformation.usesParametersWithReactiveWrappers(method)) {
            candidate = ReactiveRepositoryInformation.getMethodCandidate(method, baseClass, new AssignableWrapperMatch(method.getParameterTypes()));
            if (candidate != null) {
                return candidate;
            }
            candidate = ReactiveRepositoryInformation.getMethodCandidate(method, baseClass, WrapperConversionMatch.of(method.getParameterTypes()));
            if (candidate != null) {
                return candidate;
            }
        }
        return (candidate = ReactiveRepositoryInformation.getMethodCandidate(method, baseClass, MatchParameterOrComponentType.of(method, this.getRepositoryInterface()))) != null ? candidate : method;
    }

    static boolean isNonUnwrappingWrapper(Class<?> parameterType) {
        Assert.notNull(parameterType, (String)"Parameter type must not be null!");
        return QueryExecutionConverters.supports(parameterType) && !QueryExecutionConverters.supportsUnwrapping(parameterType);
    }

    private static boolean usesParametersWithReactiveWrappers(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return Arrays.stream(method.getParameterTypes()).anyMatch(ReactiveRepositoryInformation::isNonUnwrappingWrapper);
    }

    private static Method getMethodCandidate(Method method, Class<?> baseClass, BiPredicate<Class<?>, Integer> predicate) {
        for (Method baseClassMethod : baseClass.getMethods()) {
            if (!method.getName().equals(baseClassMethod.getName()) || method.getParameterTypes().length != baseClassMethod.getParameterTypes().length || !ReactiveRepositoryInformation.parametersMatch(method, baseClassMethod, predicate)) continue;
            return baseClassMethod;
        }
        return null;
    }

    private static boolean parametersMatch(Method method, Method baseClassMethod, BiPredicate<Class<?>, Integer> predicate) {
        Type[] genericTypes = baseClassMethod.getGenericParameterTypes();
        Class<?>[] types = baseClassMethod.getParameterTypes();
        for (int i = 0; i < genericTypes.length; ++i) {
            if (predicate.test(types[i], i)) continue;
            return false;
        }
        return true;
    }

    static class MatchParameterOrComponentType
    implements BiPredicate<Class<?>, Integer> {
        private final Method declaredMethod;
        private final Class<?>[] declaredParameterTypes;
        private final Class<?> repositoryInterface;

        public static MatchParameterOrComponentType of(Method declaredMethod, Class<?> repositoryInterface) {
            return new MatchParameterOrComponentType(declaredMethod, declaredMethod.getParameterTypes(), repositoryInterface);
        }

        @Override
        public boolean test(Class<?> candidateParameterType, Integer index) {
            MethodParameter parameter = new MethodParameter(this.declaredMethod, index.intValue());
            Class parameterType = GenericTypeResolver.resolveParameterType((MethodParameter)parameter, this.repositoryInterface);
            return candidateParameterType.isAssignableFrom(parameterType) && candidateParameterType.equals(this.declaredParameterTypes[index]);
        }

        private MatchParameterOrComponentType(Method declaredMethod, Class<?>[] declaredParameterTypes, Class<?> repositoryInterface) {
            this.declaredMethod = declaredMethod;
            this.declaredParameterTypes = declaredParameterTypes;
            this.repositoryInterface = repositoryInterface;
        }
    }

    static class AssignableWrapperMatch
    implements BiPredicate<Class<?>, Integer> {
        private final Class<?>[] declaredParameterTypes;

        @Override
        public boolean test(Class<?> candidateParameterType, Integer index) {
            if (!ReactiveRepositoryInformation.isNonUnwrappingWrapper(candidateParameterType)) {
                return false;
            }
            if (!ReactiveRepositoryInformation.isNonUnwrappingWrapper(this.declaredParameterTypes[index])) {
                return false;
            }
            return this.declaredParameterTypes[index].isAssignableFrom(candidateParameterType);
        }

        private AssignableWrapperMatch(Class<?>[] declaredParameterTypes) {
            this.declaredParameterTypes = declaredParameterTypes;
        }

        public static AssignableWrapperMatch of(Class<?>[] declaredParameterTypes) {
            return new AssignableWrapperMatch(declaredParameterTypes);
        }
    }

    static class WrapperConversionMatch
    implements BiPredicate<Class<?>, Integer> {
        private final Class<?>[] declaredParameterTypes;

        @Override
        public boolean test(Class<?> candidateParameterType, Integer index) {
            if (!ReactiveRepositoryInformation.isNonUnwrappingWrapper(candidateParameterType)) {
                return false;
            }
            if (!ReactiveRepositoryInformation.isNonUnwrappingWrapper(this.declaredParameterTypes[index])) {
                return false;
            }
            return ReactiveWrappers.isAvailable() && ReactiveWrapperConverters.canConvert(this.declaredParameterTypes[index], candidateParameterType);
        }

        private WrapperConversionMatch(Class<?>[] declaredParameterTypes) {
            this.declaredParameterTypes = declaredParameterTypes;
        }

        public static WrapperConversionMatch of(Class<?>[] declaredParameterTypes) {
            return new WrapperConversionMatch(declaredParameterTypes);
        }
    }
}

