/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.ConverterBuilder;
import org.springframework.data.convert.JodaTimeConverters;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.ThreeTenBackPortConverters;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class CustomConversions {
    private static final Logger LOG = LoggerFactory.getLogger(CustomConversions.class);
    private static final String READ_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as reading converter although it doesn't convert from a store-supported type! You might wanna check you annotation setup at the converter implementation.";
    private static final String WRITE_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as writing converter although it doesn't convert to a store-supported type! You might wanna check you annotation setup at the converter implementation.";
    private static final String NOT_A_CONVERTER = "Converter %s is neither a Spring Converter, GenericConverter or ConverterFactory!";
    private static final List<Object> DEFAULT_CONVERTERS;
    private final Set<GenericConverter.ConvertiblePair> readingPairs;
    private final Set<GenericConverter.ConvertiblePair> writingPairs;
    private final Set<Class<?>> customSimpleTypes;
    private final SimpleTypeHolder simpleTypeHolder;
    private final List<Object> converters;
    private final Map<GenericConverter.ConvertiblePair, Optional<Class<?>>> customReadTargetTypes;
    private final Map<GenericConverter.ConvertiblePair, Optional<Class<?>>> customWriteTargetTypes;
    private final Map<Class<?>, Optional<Class<?>>> rawWriteTargetTypes;

    public CustomConversions(StoreConversions storeConversions, Collection<?> converters) {
        Assert.notNull((Object)storeConversions, (String)"StoreConversions must not be null!");
        Assert.notNull(converters, (String)"List of converters must not be null!");
        this.readingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        this.writingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        this.customSimpleTypes = new HashSet();
        this.customReadTargetTypes = new ConcurrentHashMap();
        this.customWriteTargetTypes = new ConcurrentHashMap();
        this.rawWriteTargetTypes = new ConcurrentHashMap();
        ArrayList<Object> toRegister = new ArrayList<Object>();
        toRegister.addAll(converters);
        toRegister.addAll(storeConversions.getStoreConverters());
        toRegister.addAll(DEFAULT_CONVERTERS);
        toRegister.stream().flatMap(it -> storeConversions.getRegistrationsFor(it).stream()).forEach(this::register);
        Collections.reverse(toRegister);
        this.converters = Collections.unmodifiableList(toRegister);
        this.simpleTypeHolder = new SimpleTypeHolder(this.customSimpleTypes, storeConversions.getStoreTypeHolder());
    }

    public SimpleTypeHolder getSimpleTypeHolder() {
        return this.simpleTypeHolder;
    }

    public boolean isSimpleType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return this.simpleTypeHolder.isSimpleType(type);
    }

    public void registerConvertersIn(ConverterRegistry conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        this.converters.forEach(it -> this.registerConverterIn(it, conversionService));
    }

    private void registerConverterIn(Object candidate, ConverterRegistry conversionService) {
        boolean added = false;
        if (candidate instanceof Converter) {
            conversionService.addConverter((Converter)Converter.class.cast(candidate));
            added = true;
        }
        if (candidate instanceof ConverterFactory) {
            conversionService.addConverterFactory((ConverterFactory)ConverterFactory.class.cast(candidate));
            added = true;
        }
        if (candidate instanceof GenericConverter) {
            conversionService.addConverter((GenericConverter)GenericConverter.class.cast(candidate));
            added = true;
        }
        if (candidate instanceof ConverterBuilder.ConverterAware) {
            ((ConverterBuilder.ConverterAware)ConverterBuilder.ConverterAware.class.cast(candidate)).getConverters().forEach(it -> this.registerConverterIn(it, conversionService));
            added = true;
        }
        if (!added) {
            throw new IllegalArgumentException(String.format(NOT_A_CONVERTER, candidate));
        }
    }

    private void register(ConverterRegistration converterRegistration) {
        Assert.notNull((Object)converterRegistration, (String)"Converter registration must not be null!");
        GenericConverter.ConvertiblePair pair = converterRegistration.getConvertiblePair();
        if (converterRegistration.isReading()) {
            this.readingPairs.add(pair);
            if (LOG.isWarnEnabled() && !converterRegistration.isSimpleSourceType()) {
                LOG.warn(String.format(READ_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
        if (converterRegistration.isWriting()) {
            this.writingPairs.add(pair);
            this.customSimpleTypes.add(pair.getSourceType());
            if (LOG.isWarnEnabled() && !converterRegistration.isSimpleTargetType()) {
                LOG.warn(String.format(WRITE_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
    }

    public Optional<Class<?>> getCustomWriteTarget(Class<?> sourceType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        return this.rawWriteTargetTypes.computeIfAbsent(sourceType, it -> CustomConversions.getCustomTarget(sourceType, Optional.empty(), this.writingPairs));
    }

    public Optional<Class<?>> getCustomWriteTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        Assert.notNull(requestedTargetType, (String)"Target type must not be null!");
        return this.customWriteTargetTypes.computeIfAbsent(new GenericConverter.ConvertiblePair(sourceType, requestedTargetType), it -> CustomConversions.getCustomTarget(sourceType, Optional.of(requestedTargetType), this.writingPairs));
    }

    public boolean hasCustomWriteTarget(Class<?> sourceType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        return this.getCustomWriteTarget(sourceType).isPresent();
    }

    public boolean hasCustomWriteTarget(Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        Assert.notNull(targetType, (String)"Target type must not be null!");
        return this.getCustomWriteTarget(sourceType, targetType).isPresent();
    }

    public boolean hasCustomReadTarget(Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        Assert.notNull(targetType, (String)"Target type must not be null!");
        return this.getCustomReadTarget(sourceType, targetType).isPresent();
    }

    private Optional<Class<?>> getCustomReadTarget(Class<?> sourceType, Class<?> targetType) {
        return this.customReadTargetTypes.computeIfAbsent(new GenericConverter.ConvertiblePair(sourceType, targetType), it -> CustomConversions.getCustomTarget(sourceType, Optional.of(targetType), this.readingPairs));
    }

    private static Optional<Class<?>> getCustomTarget(Class<?> sourceType, Optional<Class<?>> targetType, Collection<GenericConverter.ConvertiblePair> pairs) {
        Assert.notNull(sourceType, (String)"Source Class must not be null!");
        Assert.notNull(pairs, (String)"Collection of ConvertiblePair must not be null!");
        return Optionals.firstNonEmpty(() -> targetType.filter(it -> pairs.contains(new GenericConverter.ConvertiblePair(sourceType, it))), () -> pairs.stream().filter(it -> CustomConversions.hasAssignableSourceType(it, sourceType)).map(GenericConverter.ConvertiblePair::getTargetType).filter(it -> CustomConversions.requestTargetTypeIsAssignable(targetType, it)).findFirst());
    }

    private static boolean hasAssignableSourceType(GenericConverter.ConvertiblePair pair, Class<?> sourceType) {
        return pair.getSourceType().isAssignableFrom(sourceType);
    }

    private static boolean requestTargetTypeIsAssignable(Optional<Class<?>> requestedTargetType, Class<?> targetType) {
        return !requestedTargetType.isPresent() ? true : requestedTargetType.map(it -> targetType.isAssignableFrom((Class<?>)it)).orElse(false);
    }

    static {
        ArrayList defaults = new ArrayList();
        defaults.addAll(JodaTimeConverters.getConvertersToRegister());
        defaults.addAll(Jsr310Converters.getConvertersToRegister());
        defaults.addAll(ThreeTenBackPortConverters.getConvertersToRegister());
        DEFAULT_CONVERTERS = Collections.unmodifiableList(defaults);
    }

    public static final class StoreConversions {
        public static final StoreConversions NONE = StoreConversions.of(SimpleTypeHolder.DEFAULT, Collections.emptyList());
        private final SimpleTypeHolder storeTypeHolder;
        private final Collection<?> storeConverters;

        public static StoreConversions of(SimpleTypeHolder storeTypeHolder, Object ... converters) {
            Assert.notNull((Object)storeTypeHolder, (String)"SimpleTypeHolder must not be null!");
            Assert.notNull((Object)converters, (String)"Converters must not be null!");
            return new StoreConversions(storeTypeHolder, Arrays.asList(converters));
        }

        public static StoreConversions of(SimpleTypeHolder storeTypeHolder, Collection<?> converters) {
            Assert.notNull((Object)storeTypeHolder, (String)"SimpleTypeHolder must not be null!");
            Assert.notNull(converters, (String)"Converters must not be null!");
            return new StoreConversions(storeTypeHolder, converters);
        }

        public Streamable<ConverterRegistration> getRegistrationsFor(Object converter) {
            Assert.notNull((Object)converter, (String)"Converter must not be null!");
            Class<?> type = converter.getClass();
            boolean isWriting = type.isAnnotationPresent(WritingConverter.class);
            boolean isReading = type.isAnnotationPresent(ReadingConverter.class);
            if (converter instanceof ConverterBuilder.ConverterAware) {
                return Streamable.of(() -> ((ConverterBuilder.ConverterAware)ConverterBuilder.ConverterAware.class.cast(converter)).getConverters().stream().flatMap(it -> this.getRegistrationsFor(it).stream()));
            }
            if (converter instanceof GenericConverter) {
                return Streamable.of(((GenericConverter)GenericConverter.class.cast(converter)).getConvertibleTypes()).map(it -> this.register((GenericConverter.ConvertiblePair)it, isReading, isWriting));
            }
            if (converter instanceof ConverterFactory) {
                return this.getRegistrationFor(converter, ConverterFactory.class, isReading, isWriting);
            }
            if (converter instanceof Converter) {
                return this.getRegistrationFor(converter, Converter.class, isReading, isWriting);
            }
            throw new IllegalArgumentException(String.format("Unsupported converter type %s!", converter));
        }

        private Streamable<ConverterRegistration> getRegistrationFor(Object converter, Class<?> type, boolean isReading, boolean isWriting) {
            Class[] arguments = GenericTypeResolver.resolveTypeArguments(converter.getClass(), type);
            return Streamable.of(this.register(arguments[0], arguments[1], isReading, isWriting));
        }

        private ConverterRegistration register(Class<?> source, Class<?> target, boolean isReading, boolean isWriting) {
            return this.register(new GenericConverter.ConvertiblePair(source, target), isReading, isWriting);
        }

        private ConverterRegistration register(GenericConverter.ConvertiblePair pair, boolean isReading, boolean isWriting) {
            return new ConverterRegistration(pair, this, isReading, isWriting);
        }

        private boolean isStoreSimpleType(Class<?> type) {
            return this.storeTypeHolder.isSimpleType(type);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StoreConversions)) {
                return false;
            }
            StoreConversions other = (StoreConversions)o;
            SimpleTypeHolder this$storeTypeHolder = this.getStoreTypeHolder();
            SimpleTypeHolder other$storeTypeHolder = other.getStoreTypeHolder();
            if (this$storeTypeHolder == null ? other$storeTypeHolder != null : !this$storeTypeHolder.equals(other$storeTypeHolder)) {
                return false;
            }
            Collection<?> this$storeConverters = this.getStoreConverters();
            Collection<?> other$storeConverters = other.getStoreConverters();
            return !(this$storeConverters == null ? other$storeConverters != null : !((Object)this$storeConverters).equals(other$storeConverters));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SimpleTypeHolder $storeTypeHolder = this.getStoreTypeHolder();
            result = result * 59 + ($storeTypeHolder == null ? 43 : $storeTypeHolder.hashCode());
            Collection<?> $storeConverters = this.getStoreConverters();
            result = result * 59 + ($storeConverters == null ? 43 : ((Object)$storeConverters).hashCode());
            return result;
        }

        public String toString() {
            return "CustomConversions.StoreConversions(storeTypeHolder=" + this.getStoreTypeHolder() + ", storeConverters=" + this.getStoreConverters() + ")";
        }

        SimpleTypeHolder getStoreTypeHolder() {
            return this.storeTypeHolder;
        }

        Collection<?> getStoreConverters() {
            return this.storeConverters;
        }

        @ConstructorProperties(value={"storeTypeHolder", "storeConverters"})
        private StoreConversions(SimpleTypeHolder storeTypeHolder, Collection<?> storeConverters) {
            this.storeTypeHolder = storeTypeHolder;
            this.storeConverters = storeConverters;
        }
    }

    private static class ConverterRegistration {
        @NonNull
        private final GenericConverter.ConvertiblePair convertiblePair;
        @NonNull
        private final StoreConversions storeConversions;
        private final boolean reading;
        private final boolean writing;

        public boolean isWriting() {
            return this.writing || !this.reading && this.isSimpleTargetType();
        }

        public boolean isReading() {
            return this.reading || !this.writing && this.isSimpleSourceType();
        }

        public GenericConverter.ConvertiblePair getConvertiblePair() {
            return this.convertiblePair;
        }

        public boolean isSimpleSourceType() {
            return this.storeConversions.isStoreSimpleType(this.convertiblePair.getSourceType());
        }

        public boolean isSimpleTargetType() {
            return this.storeConversions.isStoreSimpleType(this.convertiblePair.getTargetType());
        }

        @ConstructorProperties(value={"convertiblePair", "storeConversions", "reading", "writing"})
        private ConverterRegistration(@NonNull GenericConverter.ConvertiblePair convertiblePair, @NonNull StoreConversions storeConversions, boolean reading, boolean writing) {
            if (convertiblePair == null) {
                throw new IllegalArgumentException("convertiblePair is null");
            }
            if (storeConversions == null) {
                throw new IllegalArgumentException("storeConversions is null");
            }
            this.convertiblePair = convertiblePair;
            this.storeConversions = storeConversions;
            this.reading = reading;
            this.writing = writing;
        }
    }
}

