/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.convert.MappingContextTypeInformationMapper;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class DefaultTypeMapper<S>
implements TypeMapper<S> {
    private final TypeAliasAccessor<S> accessor;
    private final List<? extends TypeInformationMapper> mappers;
    private final Map<Alias, Optional<TypeInformation<?>>> typeCache;

    public DefaultTypeMapper(TypeAliasAccessor<S> accessor) {
        this(accessor, Collections.singletonList(new SimpleTypeInformationMapper()));
    }

    public DefaultTypeMapper(TypeAliasAccessor<S> accessor, List<? extends TypeInformationMapper> mappers) {
        this(accessor, null, mappers);
    }

    public DefaultTypeMapper(TypeAliasAccessor<S> accessor, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext, List<? extends TypeInformationMapper> additionalMappers) {
        Assert.notNull(accessor, (String)"Accessor must not be null!");
        Assert.notNull(additionalMappers, (String)"AdditionalMappers must not be null!");
        ArrayList<? extends TypeInformationMapper> mappers = new ArrayList<TypeInformationMapper>(additionalMappers.size() + 1);
        if (mappingContext != null) {
            mappers.add(new MappingContextTypeInformationMapper(mappingContext));
        }
        mappers.addAll(additionalMappers);
        this.mappers = Collections.unmodifiableList(mappers);
        this.accessor = accessor;
        this.typeCache = new ConcurrentHashMap();
    }

    @Override
    public Optional<TypeInformation<?>> readType(S source) {
        Assert.notNull(source, (String)"Source object must not be null!");
        return this.getFromCacheOrCreate(this.accessor.readAliasFrom(source));
    }

    private Optional<TypeInformation<?>> getFromCacheOrCreate(Alias alias) {
        return this.typeCache.computeIfAbsent(alias, key -> Optionals.firstNonEmpty(this.mappers, it -> it.resolveTypeFrom(alias)));
    }

    @Override
    public <T> TypeInformation<? extends T> readType(S source, TypeInformation<T> basicType) {
        Assert.notNull(source, (String)"Source must not be null!");
        Assert.notNull(basicType, (String)"Basic type must not be null!");
        Optional<TypeInformation> calculated = this.getDefaultedTypeToBeUsed(source).map(it -> DefaultTypeMapper.specializeOrDefault(it, basicType));
        return calculated.orElse(basicType);
    }

    private static <T> TypeInformation<? extends T> specializeOrDefault(Class<?> it, TypeInformation<T> type) {
        ClassTypeInformation<?> targetType = ClassTypeInformation.from(it);
        Class<T> rawType = type.getType();
        return rawType.isAssignableFrom(it) && !rawType.equals(it) ? type.specialize(targetType) : type;
    }

    private Optional<Class<?>> getDefaultedTypeToBeUsed(S source) {
        return this.readType(source).map(it -> this.readType(source)).orElseGet(() -> this.getFallbackTypeFor(source)).map(TypeInformation::getType);
    }

    protected Optional<TypeInformation<?>> getFallbackTypeFor(S source) {
        return Optional.empty();
    }

    @Override
    public void writeType(Class<?> type, S dbObject) {
        this.writeType(ClassTypeInformation.from(type), dbObject);
    }

    @Override
    public void writeType(TypeInformation<?> info, S sink) {
        Assert.notNull(info, (String)"TypeInformation must not be null!");
        this.getAliasFor(info).getValue().ifPresent(it -> this.accessor.writeTypeTo(sink, it));
    }

    protected final Alias getAliasFor(TypeInformation<?> info) {
        Assert.notNull(info, (String)"TypeInformation must not be null!");
        return Optionals.firstNonEmpty(this.mappers, it -> it.createAliasFor(info), Alias.NONE);
    }
}

