/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.util.ClassUtils;

public class RepositoryBeanNameGenerator {
    private static final BeanNameGenerator DELEGATE = new AnnotationBeanNameGenerator();
    private final ClassLoader beanClassLoader;

    public String generateBeanName(BeanDefinition definition) {
        AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(this.getRepositoryInterfaceFrom(definition));
        return DELEGATE.generateBeanName((BeanDefinition)beanDefinition, null);
    }

    private Class<?> getRepositoryInterfaceFrom(BeanDefinition beanDefinition) {
        if (beanDefinition instanceof ScannedGenericBeanDefinition) {
            try {
                return ((ScannedGenericBeanDefinition)beanDefinition).resolveBeanClass(this.beanClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not resolve bean class.", e);
            }
        }
        return this.getRepositoryInterfaceFromFactory(beanDefinition);
    }

    private Class<?> getRepositoryInterfaceFromFactory(BeanDefinition beanDefinition) {
        Object value = beanDefinition.getConstructorArgumentValues().getArgumentValue(0, Class.class).getValue();
        if (value instanceof Class) {
            return (Class)value;
        }
        try {
            return ClassUtils.forName((String)value.toString(), (ClassLoader)this.beanClassLoader);
        }
        catch (Exception o_O) {
            throw new RuntimeException(o_O);
        }
    }

    @ConstructorProperties(value={"beanClassLoader"})
    public RepositoryBeanNameGenerator(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }
}

