/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.config.RepositoryBeanNameGenerator;
import org.springframework.data.repository.config.RepositoryComponentProvider;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public abstract class RepositoryConfigurationSourceSupport
implements RepositoryConfigurationSource {
    protected static final String DEFAULT_REPOSITORY_IMPL_POSTFIX = "Impl";
    private final Environment environment;
    private final RepositoryBeanNameGenerator beanNameGenerator;

    public RepositoryConfigurationSourceSupport(Environment environment, ClassLoader classLoader) {
        Assert.notNull((Object)environment, (String)"Environment must not be null!");
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null!");
        this.environment = environment;
        this.beanNameGenerator = new RepositoryBeanNameGenerator(classLoader);
    }

    @Override
    public Streamable<BeanDefinition> getCandidates(ResourceLoader loader) {
        RepositoryComponentProvider scanner = new RepositoryComponentProvider(this.getIncludeFilters());
        scanner.setConsiderNestedRepositoryInterfaces(this.shouldConsiderNestedRepositories());
        scanner.setResourceLoader(loader);
        scanner.setEnvironment(this.environment);
        this.getExcludeFilters().forEach(it -> scanner.addExcludeFilter((TypeFilter)it));
        return Streamable.of(() -> this.getBasePackages().stream().flatMap(it -> scanner.findCandidateComponents((String)it).stream()));
    }

    @Override
    public Streamable<TypeFilter> getExcludeFilters() {
        return Streamable.empty();
    }

    @Override
    public String generateBeanName(BeanDefinition beanDefinition) {
        return this.beanNameGenerator.generateBeanName(beanDefinition);
    }

    protected Iterable<TypeFilter> getIncludeFilters() {
        return Collections.emptySet();
    }

    public boolean shouldConsiderNestedRepositories() {
        return false;
    }
}

