/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Completable;
import rx.Observable;
import rx.Single;

public final class ReactiveWrapperConverters {
    private static final List<ReactiveTypeWrapper<?>> REACTIVE_WRAPPERS = new ArrayList();
    private static final GenericConversionService GENERIC_CONVERSION_SERVICE = new GenericConversionService();

    private static ConversionService registerConvertersIn(ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR)) {
            if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.RXJAVA1)) {
                conversionService.addConverter((Converter)PublisherToRxJava1CompletableConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava1CompletableToPublisherConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava1CompletableToMonoConverter.INSTANCE);
                conversionService.addConverter((Converter)PublisherToRxJava1SingleConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava1SingleToPublisherConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava1SingleToMonoConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava1SingleToFluxConverter.INSTANCE);
                conversionService.addConverter((Converter)PublisherToRxJava1ObservableConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava1ObservableToPublisherConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava1ObservableToMonoConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava1ObservableToFluxConverter.INSTANCE);
            }
            if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.RXJAVA2)) {
                conversionService.addConverter((Converter)PublisherToRxJava2CompletableConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2CompletableToPublisherConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2CompletableToMonoConverter.INSTANCE);
                conversionService.addConverter((Converter)PublisherToRxJava2SingleConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2SingleToPublisherConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2SingleToMonoConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2SingleToFluxConverter.INSTANCE);
                conversionService.addConverter((Converter)PublisherToRxJava2ObservableConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2ObservableToPublisherConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2ObservableToMonoConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2ObservableToFluxConverter.INSTANCE);
                conversionService.addConverter((Converter)PublisherToRxJava2FlowableConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2FlowableToPublisherConverter.INSTANCE);
                conversionService.addConverter((Converter)PublisherToRxJava2MaybeConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2MaybeToPublisherConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2MaybeToMonoConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2MaybeToFluxConverter.INSTANCE);
            }
            conversionService.addConverter((Converter)PublisherToMonoConverter.INSTANCE);
            conversionService.addConverter((Converter)PublisherToFluxConverter.INSTANCE);
            if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.RXJAVA1)) {
                conversionService.addConverter((Converter)RxJava1SingleToObservableConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava1ObservableToSingleConverter.INSTANCE);
            }
            if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.RXJAVA2)) {
                conversionService.addConverter((Converter)RxJava2SingleToObservableConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2ObservableToSingleConverter.INSTANCE);
                conversionService.addConverter((Converter)RxJava2ObservableToMaybeConverter.INSTANCE);
            }
        }
        return conversionService;
    }

    public static boolean supports(Class<?> type) {
        return RegistryHolder.REACTIVE_ADAPTER_REGISTRY != null && RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(type) != null;
    }

    public static <T> T toWrapper(Object reactiveObject, Class<? extends T> targetWrapperType) {
        Assert.notNull((Object)reactiveObject, (String)"Reactive source object must not be null!");
        Assert.notNull(targetWrapperType, (String)"Reactive target type must not be null!");
        if (targetWrapperType.isAssignableFrom(reactiveObject.getClass())) {
            return (T)reactiveObject;
        }
        return (T)GENERIC_CONVERSION_SERVICE.convert(reactiveObject, targetWrapperType);
    }

    public static <T> T map(Object reactiveObject, Function<Object, Object> converter) {
        Assert.notNull((Object)reactiveObject, (String)"Reactive source object must not be null!");
        Assert.notNull(converter, (String)"Converter must not be null!");
        return (T)REACTIVE_WRAPPERS.stream().filter(it -> ClassUtils.isAssignable(it.getWrapperClass(), reactiveObject.getClass())).findFirst().map(it -> it.map(reactiveObject, converter)).orElseThrow(() -> new IllegalStateException(String.format("Cannot apply converter to %s", reactiveObject)));
    }

    public static boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        Assert.notNull(targetType, (String)"Target type must not be null!");
        return GENERIC_CONVERSION_SERVICE.canConvert(sourceType, targetType);
    }

    private ReactiveWrapperConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.RXJAVA1)) {
            REACTIVE_WRAPPERS.add(RxJava1SingleWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava1ObservableWrapper.INSTANCE);
        }
        if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.RXJAVA2)) {
            REACTIVE_WRAPPERS.add(RxJava2SingleWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava2MaybeWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava2ObservableWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava2FlowableWrapper.INSTANCE);
        }
        if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR)) {
            REACTIVE_WRAPPERS.add(FluxWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(MonoWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(PublisherWrapper.INSTANCE);
        }
        ReactiveWrapperConverters.registerConvertersIn((ConfigurableConversionService)GENERIC_CONVERSION_SERVICE);
    }

    static class RegistryHolder {
        static final ReactiveAdapterRegistry REACTIVE_ADAPTER_REGISTRY = ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR) ? new ReactiveAdapterRegistry() : null;

        RegistryHolder() {
        }
    }

    private static enum RxJava2SingleToObservableConverter implements Converter<io.reactivex.Single<?>, io.reactivex.Observable<?>>
    {
        INSTANCE;


        public io.reactivex.Observable<?> convert(io.reactivex.Single<?> source) {
            return source.toObservable();
        }
    }

    private static enum RxJava2ObservableToMaybeConverter implements Converter<io.reactivex.Observable<?>, Maybe<?>>
    {
        INSTANCE;


        public Maybe<?> convert(io.reactivex.Observable<?> source) {
            return source.singleElement();
        }
    }

    private static enum RxJava2ObservableToSingleConverter implements Converter<io.reactivex.Observable<?>, io.reactivex.Single<?>>
    {
        INSTANCE;


        public io.reactivex.Single<?> convert(io.reactivex.Observable<?> source) {
            return source.singleOrError();
        }
    }

    private static enum RxJava2MaybeToFluxConverter implements Converter<Maybe<?>, Flux<?>>
    {
        INSTANCE;


        public Flux<?> convert(Maybe<?> source) {
            return Flux.from((Publisher)source.toFlowable());
        }
    }

    private static enum RxJava2MaybeToMonoConverter implements Converter<Maybe<?>, Mono<?>>
    {
        INSTANCE;


        public Mono<?> convert(Maybe<?> source) {
            return Mono.from((Publisher)source.toFlowable());
        }
    }

    private static enum RxJava2MaybeToPublisherConverter implements Converter<Maybe<?>, Publisher<?>>
    {
        INSTANCE;


        public Publisher<?> convert(Maybe<?> source) {
            return source.toFlowable();
        }
    }

    private static enum PublisherToRxJava2MaybeConverter implements Converter<Publisher<?>, Maybe<?>>
    {
        INSTANCE;


        public Maybe<?> convert(Publisher<?> source) {
            return (Maybe)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Maybe.class).fromPublisher(source);
        }
    }

    private static enum RxJava2FlowableToPublisherConverter implements Converter<Flowable<?>, Publisher<?>>
    {
        INSTANCE;


        public Publisher<?> convert(Flowable<?> source) {
            return source;
        }
    }

    private static enum PublisherToRxJava2FlowableConverter implements Converter<Publisher<?>, Flowable<?>>
    {
        INSTANCE;


        public Flowable<?> convert(Publisher<?> source) {
            return Flowable.fromPublisher(source);
        }
    }

    private static enum RxJava2ObservableToFluxConverter implements Converter<io.reactivex.Observable<?>, Flux<?>>
    {
        INSTANCE;


        public Flux<?> convert(io.reactivex.Observable<?> source) {
            return Flux.from((Publisher)source.toFlowable(BackpressureStrategy.BUFFER));
        }
    }

    private static enum RxJava2ObservableToMonoConverter implements Converter<io.reactivex.Observable<?>, Mono<?>>
    {
        INSTANCE;


        public Mono<?> convert(io.reactivex.Observable<?> source) {
            return Mono.from((Publisher)source.toFlowable(BackpressureStrategy.BUFFER));
        }
    }

    private static enum RxJava2ObservableToPublisherConverter implements Converter<io.reactivex.Observable<?>, Publisher<?>>
    {
        INSTANCE;


        public Publisher<?> convert(io.reactivex.Observable<?> source) {
            return source.toFlowable(BackpressureStrategy.BUFFER);
        }
    }

    private static enum RxJava2CompletableToMonoConverter implements Converter<io.reactivex.Completable, Mono<?>>
    {
        INSTANCE;


        public Mono<?> convert(io.reactivex.Completable source) {
            return Mono.from(RxJava2CompletableToPublisherConverter.INSTANCE.convert(source));
        }
    }

    private static enum RxJava2CompletableToPublisherConverter implements Converter<io.reactivex.Completable, Publisher<?>>
    {
        INSTANCE;


        public Publisher<?> convert(io.reactivex.Completable source) {
            return RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(io.reactivex.Completable.class).toPublisher((Object)source);
        }
    }

    private static enum RxJava2SingleToFluxConverter implements Converter<io.reactivex.Single<?>, Flux<?>>
    {
        INSTANCE;


        public Flux<?> convert(io.reactivex.Single<?> source) {
            return Flux.from((Publisher)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(io.reactivex.Single.class).toPublisher(source));
        }
    }

    private static enum RxJava2SingleToMonoConverter implements Converter<io.reactivex.Single<?>, Mono<?>>
    {
        INSTANCE;


        public Mono<?> convert(io.reactivex.Single<?> source) {
            return Mono.from((Publisher)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(io.reactivex.Single.class).toPublisher(source));
        }
    }

    private static enum RxJava2SingleToPublisherConverter implements Converter<io.reactivex.Single<?>, Publisher<?>>
    {
        INSTANCE;


        public Publisher<?> convert(io.reactivex.Single<?> source) {
            return RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(io.reactivex.Single.class).toPublisher(source);
        }
    }

    private static enum PublisherToRxJava2ObservableConverter implements Converter<Publisher<?>, io.reactivex.Observable<?>>
    {
        INSTANCE;


        public io.reactivex.Observable<?> convert(Publisher<?> source) {
            return (io.reactivex.Observable)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(io.reactivex.Observable.class).fromPublisher(source);
        }
    }

    private static enum PublisherToRxJava2CompletableConverter implements Converter<Publisher<?>, io.reactivex.Completable>
    {
        INSTANCE;


        public io.reactivex.Completable convert(Publisher<?> source) {
            return (io.reactivex.Completable)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(io.reactivex.Completable.class).fromPublisher(source);
        }
    }

    private static enum PublisherToRxJava2SingleConverter implements Converter<Publisher<?>, io.reactivex.Single<?>>
    {
        INSTANCE;


        public io.reactivex.Single<?> convert(Publisher<?> source) {
            return (io.reactivex.Single)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(io.reactivex.Single.class).fromPublisher(source);
        }
    }

    private static enum RxJava1SingleToObservableConverter implements Converter<Single<?>, Observable<?>>
    {
        INSTANCE;


        public Observable<?> convert(Single<?> source) {
            return source.toObservable();
        }
    }

    private static enum RxJava1ObservableToSingleConverter implements Converter<Observable<?>, Single<?>>
    {
        INSTANCE;


        public Single<?> convert(Observable<?> source) {
            return source.toSingle();
        }
    }

    private static enum RxJava1ObservableToFluxConverter implements Converter<Observable<?>, Flux<?>>
    {
        INSTANCE;


        public Flux<?> convert(Observable<?> source) {
            return Flux.defer(() -> RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Observable.class).toPublisher((Object)source));
        }
    }

    private static enum RxJava1ObservableToMonoConverter implements Converter<Observable<?>, Mono<?>>
    {
        INSTANCE;


        public Mono<?> convert(Observable<?> source) {
            return Mono.defer(() -> Mono.from((Publisher)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Observable.class).toPublisher((Object)source)));
        }
    }

    private static enum RxJava1ObservableToPublisherConverter implements Converter<Observable<?>, Publisher<?>>
    {
        INSTANCE;


        public Publisher<?> convert(Observable<?> source) {
            return Flux.defer(() -> RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Observable.class).toPublisher((Object)source));
        }
    }

    private static enum RxJava1CompletableToMonoConverter implements Converter<Completable, Mono<?>>
    {
        INSTANCE;


        public Mono<?> convert(Completable source) {
            return Mono.from(RxJava1CompletableToPublisherConverter.INSTANCE.convert(source));
        }
    }

    private static enum RxJava1CompletableToPublisherConverter implements Converter<Completable, Publisher<?>>
    {
        INSTANCE;


        public Publisher<?> convert(Completable source) {
            return Flux.defer(() -> RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Completable.class).toPublisher((Object)source));
        }
    }

    private static enum RxJava1SingleToFluxConverter implements Converter<Single<?>, Flux<?>>
    {
        INSTANCE;


        public Flux<?> convert(Single<?> source) {
            return Flux.defer(() -> RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Single.class).toPublisher((Object)source));
        }
    }

    private static enum RxJava1SingleToMonoConverter implements Converter<Single<?>, Mono<?>>
    {
        INSTANCE;


        public Mono<?> convert(Single<?> source) {
            return Mono.defer(() -> Mono.from((Publisher)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Single.class).toPublisher((Object)source)));
        }
    }

    private static enum RxJava1SingleToPublisherConverter implements Converter<Single<?>, Publisher<?>>
    {
        INSTANCE;


        public Publisher<?> convert(Single<?> source) {
            return Flux.defer(() -> RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Single.class).toPublisher((Object)source));
        }
    }

    private static enum PublisherToRxJava1ObservableConverter implements Converter<Publisher<?>, Observable<?>>
    {
        INSTANCE;


        public Observable<?> convert(Publisher<?> source) {
            return (Observable)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Observable.class).fromPublisher((Publisher)Flux.from(source));
        }
    }

    private static enum PublisherToRxJava1CompletableConverter implements Converter<Publisher<?>, Completable>
    {
        INSTANCE;


        public Completable convert(Publisher<?> source) {
            return (Completable)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Completable.class).fromPublisher(source);
        }
    }

    private static enum PublisherToRxJava1SingleConverter implements Converter<Publisher<?>, Single<?>>
    {
        INSTANCE;


        public Single<?> convert(Publisher<?> source) {
            return (Single)RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Single.class).fromPublisher((Publisher)Mono.from(source));
        }
    }

    private static enum PublisherToMonoConverter implements Converter<Publisher<?>, Mono<?>>
    {
        INSTANCE;


        public Mono<?> convert(Publisher<?> source) {
            return Mono.from(source);
        }
    }

    private static enum PublisherToFluxConverter implements Converter<Publisher<?>, Flux<?>>
    {
        INSTANCE;


        public Flux<?> convert(Publisher<?> source) {
            return Flux.from(source);
        }
    }

    private static enum RxJava2FlowableWrapper implements ReactiveTypeWrapper<Flowable<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Flowable<?>> getWrapperClass() {
            return Flowable.class;
        }

        public Flowable<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Flowable)wrapper).map(function::apply);
        }
    }

    private static enum RxJava2ObservableWrapper implements ReactiveTypeWrapper<io.reactivex.Observable<?>>
    {
        INSTANCE;


        @Override
        public Class<? super io.reactivex.Observable<?>> getWrapperClass() {
            return io.reactivex.Observable.class;
        }

        public io.reactivex.Observable<?> map(Object wrapper, Function<Object, Object> function) {
            return ((io.reactivex.Observable)wrapper).map(function::apply);
        }
    }

    private static enum RxJava2MaybeWrapper implements ReactiveTypeWrapper<Maybe<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Maybe<?>> getWrapperClass() {
            return Maybe.class;
        }

        public Maybe<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Maybe)wrapper).map(function::apply);
        }
    }

    private static enum RxJava2SingleWrapper implements ReactiveTypeWrapper<io.reactivex.Single<?>>
    {
        INSTANCE;


        @Override
        public Class<? super io.reactivex.Single<?>> getWrapperClass() {
            return io.reactivex.Single.class;
        }

        public io.reactivex.Single<?> map(Object wrapper, Function<Object, Object> function) {
            return ((io.reactivex.Single)wrapper).map(function::apply);
        }
    }

    private static enum RxJava1ObservableWrapper implements ReactiveTypeWrapper<Observable<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Observable<?>> getWrapperClass() {
            return Observable.class;
        }

        public Observable<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Observable)wrapper).map(function::apply);
        }
    }

    private static enum RxJava1SingleWrapper implements ReactiveTypeWrapper<Single<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Single<?>> getWrapperClass() {
            return Single.class;
        }

        public Single<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Single)wrapper).map(function::apply);
        }
    }

    private static enum PublisherWrapper implements ReactiveTypeWrapper<Publisher<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Publisher<?>> getWrapperClass() {
            return Publisher.class;
        }

        public Publisher<?> map(Object wrapper, Function<Object, Object> function) {
            if (wrapper instanceof Mono) {
                return MonoWrapper.INSTANCE.map(wrapper, function);
            }
            if (wrapper instanceof Flux) {
                return FluxWrapper.INSTANCE.map(wrapper, function);
            }
            return FluxWrapper.INSTANCE.map((Object)Flux.from((Publisher)((Publisher)wrapper)), function);
        }
    }

    private static enum FluxWrapper implements ReactiveTypeWrapper<Flux<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Flux<?>> getWrapperClass() {
            return Flux.class;
        }

        public Flux<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Flux)wrapper).map(function::apply);
        }
    }

    private static enum MonoWrapper implements ReactiveTypeWrapper<Mono<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Mono<?>> getWrapperClass() {
            return Mono.class;
        }

        public Mono<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Mono)wrapper).map(function::apply);
        }
    }

    private static interface ReactiveTypeWrapper<T> {
        public Class<? super T> getWrapperClass();

        public Object map(Object var1, Function<Object, Object> var2);
    }
}

