/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.ConstructorProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.beans.BeanUtils;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.GenericArrayTypeInformation;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.ParameterizedTypeInformation;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.data.util.TypeVariableTypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TypeDiscoverer<S>
implements TypeInformation<S> {
    private static final Iterable<Class<?>> MAP_TYPES;
    private final Type type;
    private final Map<TypeVariable<?>, Type> typeVariableMap;
    private final Map<String, Optional<TypeInformation<?>>> fieldTypes = new ConcurrentHashMap();
    private final int hashCode;
    private final Lazy<Class<S>> resolvedType;
    private final Lazy<Optional<TypeInformation<?>>> componentType;
    private final Lazy<Optional<TypeInformation<?>>> valueType;

    protected TypeDiscoverer(Type type, Map<TypeVariable<?>, Type> typeVariableMap) {
        Assert.notNull((Object)type, (String)"Type must not be null!");
        Assert.notNull(typeVariableMap, (String)"TypeVariableMap must not be null!");
        this.type = type;
        this.resolvedType = Lazy.of(() -> this.resolveType(type));
        this.componentType = Lazy.of(this::doGetComponentType);
        this.valueType = Lazy.of(this::doGetMapValueType);
        this.typeVariableMap = typeVariableMap;
        this.hashCode = 17 + 31 * type.hashCode() + 31 * typeVariableMap.hashCode();
    }

    protected Map<TypeVariable<?>, Type> getTypeVariableMap() {
        return this.typeVariableMap;
    }

    private TypeInformation<?> createInfo(Optional<Type> fieldType) {
        return fieldType.map(this::createInfo).orElseThrow(IllegalArgumentException::new);
    }

    protected TypeInformation<?> createInfo(Type fieldType) {
        if (fieldType.equals(this.type)) {
            return this;
        }
        if (fieldType instanceof Class) {
            return ClassTypeInformation.from((Class)fieldType);
        }
        Class<S> resolveType = this.resolveType(fieldType);
        HashMap variableMap = new HashMap();
        variableMap.putAll(GenericTypeResolver.getTypeVariableMap(resolveType));
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            TypeVariable<Class<S>>[] typeParameters = resolveType.getTypeParameters();
            Type[] arguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                variableMap.put(typeParameters[i], arguments[i]);
            }
            return new ParameterizedTypeInformation(parameterizedType, this, variableMap);
        }
        if (fieldType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)fieldType;
            return new TypeVariableTypeInformation(variable, this.type, this, variableMap);
        }
        if (fieldType instanceof GenericArrayType) {
            return new GenericArrayTypeInformation((GenericArrayType)fieldType, this, variableMap);
        }
        if (fieldType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)fieldType;
            Type[] bounds = wildcardType.getLowerBounds();
            if (bounds.length > 0) {
                return this.createInfo(bounds[0]);
            }
            bounds = wildcardType.getUpperBounds();
            if (bounds.length > 0) {
                return this.createInfo(bounds[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    protected Class<S> resolveType(Type type) {
        HashMap map = new HashMap();
        map.putAll(this.getTypeVariableMap());
        return GenericTypeResolver.resolveType((Type)type, map);
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Constructor<?> constructor) {
        Assert.notNull(constructor, (String)"Constructor must not be null!");
        Type[] types = constructor.getGenericParameterTypes();
        ArrayList result = new ArrayList(types.length);
        for (Type parameterType : types) {
            result.add(this.createInfo(parameterType));
        }
        return result;
    }

    @Override
    public Optional<TypeInformation<?>> getProperty(String fieldname) {
        int separatorIndex = fieldname.indexOf(46);
        if (separatorIndex == -1) {
            return this.fieldTypes.computeIfAbsent(fieldname, this::getPropertyInformation);
        }
        String head = fieldname.substring(0, separatorIndex);
        Optional<TypeInformation<?>> info = this.getProperty(head);
        return info.map(it -> it.getProperty(fieldname.substring(separatorIndex + 1))).orElseGet(Optional::empty);
    }

    private Optional<TypeInformation<?>> getPropertyInformation(String fieldname) {
        Class<S> rawType = this.getType();
        Field field = ReflectionUtils.findField(rawType, (String)fieldname);
        if (field != null) {
            return Optional.of(this.createInfo(field.getGenericType()));
        }
        return TypeDiscoverer.findPropertyDescriptor(rawType, fieldname).map(it -> this.createInfo(TypeDiscoverer.getGenericType(it)));
    }

    private static Optional<PropertyDescriptor> findPropertyDescriptor(Class<?> type, String fieldname) {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(type, (String)fieldname);
        if (descriptor != null) {
            return Optional.of(descriptor);
        }
        ArrayList superTypes = new ArrayList();
        superTypes.addAll(Arrays.asList(type.getInterfaces()));
        superTypes.add(type.getSuperclass());
        return Streamable.of(type.getInterfaces()).stream().flatMap(it -> Optionals.toStream(TypeDiscoverer.findPropertyDescriptor(it, fieldname))).findFirst();
    }

    private static Optional<Type> getGenericType(PropertyDescriptor descriptor) {
        Method method = descriptor.getReadMethod();
        if (method != null) {
            return Optional.of(method.getGenericReturnType());
        }
        method = descriptor.getWriteMethod();
        if (method == null) {
            return Optional.empty();
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        return Optional.ofNullable(parameterTypes.length == 0 ? null : parameterTypes[0]);
    }

    @Override
    public Class<S> getType() {
        return this.resolvedType.get();
    }

    @Override
    public ClassTypeInformation<?> getRawTypeInformation() {
        return ClassTypeInformation.from(this.getType()).getRawTypeInformation();
    }

    @Override
    public TypeInformation<?> getActualType() {
        if (this.isMap()) {
            return this.getMapValueType().orElse(null);
        }
        if (this.isCollectionLike()) {
            return this.getComponentType().orElse(null);
        }
        return this;
    }

    @Override
    public boolean isMap() {
        for (Class<S> clazz : MAP_TYPES) {
            if (!clazz.isAssignableFrom(this.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<TypeInformation<?>> getMapValueType() {
        return this.valueType.get();
    }

    protected Optional<TypeInformation<?>> doGetMapValueType() {
        return this.isMap() ? this.getTypeArgument(this.getBaseType(MAP_TYPES), 1) : this.getTypeArguments().stream().skip(1L).findFirst();
    }

    @Override
    public boolean isCollectionLike() {
        Class<S> rawType = this.getType();
        return rawType.isArray() || Iterable.class.equals(rawType) || Collection.class.isAssignableFrom(rawType);
    }

    @Override
    public final Optional<TypeInformation<?>> getComponentType() {
        return this.componentType.get();
    }

    protected Optional<TypeInformation<?>> doGetComponentType() {
        Class<S> rawType = this.getType();
        if (rawType.isArray()) {
            return Optional.of(this.createInfo(rawType.getComponentType()));
        }
        if (this.isMap()) {
            return this.getTypeArgument(this.getBaseType(MAP_TYPES), 0);
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            return this.getTypeArgument(Iterable.class, 0);
        }
        List<TypeInformation<?>> arguments = this.getTypeArguments();
        return arguments.size() > 0 ? Optional.of(arguments.get(0)) : Optional.empty();
    }

    @Override
    public TypeInformation<?> getReturnType(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return this.createInfo(method.getGenericReturnType());
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Method method) {
        Assert.notNull((Object)method, (String)"Method most not be null!");
        return Streamable.of(method.getGenericParameterTypes()).stream().map(this::createInfo).collect(Collectors.toList());
    }

    @Override
    public TypeInformation<?> getSuperTypeInformation(Class<?> superType) {
        Class<S> rawType = this.getType();
        if (!superType.isAssignableFrom(rawType)) {
            return null;
        }
        if (this.getType().equals(superType)) {
            return this;
        }
        ArrayList<Type> candidates = new ArrayList<Type>();
        Type genericSuperclass = rawType.getGenericSuperclass();
        if (genericSuperclass != null) {
            candidates.add(genericSuperclass);
        }
        candidates.addAll(Arrays.asList(rawType.getGenericInterfaces()));
        for (Type candidate : candidates) {
            TypeInformation<S> candidateInfo = this.createInfo(candidate);
            if (superType.equals(candidateInfo.getType())) {
                return candidateInfo;
            }
            TypeInformation<?> nestedSuperType = candidateInfo.getSuperTypeInformation(superType);
            if (nestedSuperType == null) continue;
            return nestedSuperType;
        }
        return null;
    }

    @Override
    public List<TypeInformation<?>> getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        return target.getSuperTypeInformation(this.getType()).equals(this);
    }

    @Override
    public TypeInformation<? extends S> specialize(ClassTypeInformation<?> type) {
        Assert.isTrue((boolean)this.getType().isAssignableFrom(type.getType()), (String)String.format("%s must be assignable from %s", this.getType(), type.getType()));
        List<TypeInformation<?>> arguments = this.getTypeArguments();
        return arguments.isEmpty() ? type : this.createInfo(new SyntheticParamterizedType(type, arguments));
    }

    private Optional<TypeInformation<?>> getTypeArgument(Class<?> bound, int index) {
        Class[] arguments = GenericTypeResolver.resolveTypeArguments(this.getType(), bound);
        if (arguments == null) {
            return Optional.ofNullable(this.getSuperTypeInformation(bound) instanceof ParameterizedTypeInformation ? ClassTypeInformation.OBJECT : null);
        }
        return Optional.of(this.createInfo(arguments[index]));
    }

    private Class<?> getBaseType(Iterable<Class<?>> candidates) {
        for (Class<S> clazz : candidates) {
            if (!clazz.isAssignableFrom(this.getType())) continue;
            return clazz;
        }
        throw new IllegalArgumentException(String.format("Type %s not contained in candidates %s!", this.getType(), candidates));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TypeDiscoverer that = (TypeDiscoverer)obj;
        return this.type.equals(that.type) && this.typeVariableMap.equals(that.typeVariableMap);
    }

    public int hashCode() {
        return this.hashCode;
    }

    static {
        ClassLoader classLoader = TypeDiscoverer.class.getClassLoader();
        HashSet<Class> mapTypes = new HashSet<Class>();
        mapTypes.add(Map.class);
        try {
            mapTypes.add(ClassUtils.forName((String)"javaslang.collection.Map", (ClassLoader)classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        MAP_TYPES = Collections.unmodifiableSet(mapTypes);
    }

    private static class SyntheticParamterizedType
    implements ParameterizedType {
        @NonNull
        private final ClassTypeInformation<?> typeInformation;
        @NonNull
        private final List<TypeInformation<?>> typeParameters;

        @Override
        public Type getRawType() {
            return this.typeInformation.getType();
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type[] getActualTypeArguments() {
            Type[] result = new Type[this.typeParameters.size()];
            for (int i = 0; i < this.typeParameters.size(); ++i) {
                result[i] = this.typeParameters.get(i).getType();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SyntheticParamterizedType)) {
                return false;
            }
            SyntheticParamterizedType other = (SyntheticParamterizedType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClassTypeInformation<?> this$typeInformation = this.typeInformation;
            ClassTypeInformation<?> other$typeInformation = other.typeInformation;
            if (this$typeInformation == null ? other$typeInformation != null : !((Object)this$typeInformation).equals(other$typeInformation)) {
                return false;
            }
            List<TypeInformation<?>> this$typeParameters = this.typeParameters;
            List<TypeInformation<?>> other$typeParameters = other.typeParameters;
            return !(this$typeParameters == null ? other$typeParameters != null : !((Object)this$typeParameters).equals(other$typeParameters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SyntheticParamterizedType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClassTypeInformation<?> $typeInformation = this.typeInformation;
            result = result * 59 + ($typeInformation == null ? 43 : ((Object)$typeInformation).hashCode());
            List<TypeInformation<?>> $typeParameters = this.typeParameters;
            result = result * 59 + ($typeParameters == null ? 43 : ((Object)$typeParameters).hashCode());
            return result;
        }

        @ConstructorProperties(value={"typeInformation", "typeParameters"})
        public SyntheticParamterizedType(@NonNull ClassTypeInformation<?> typeInformation, @NonNull List<TypeInformation<?>> typeParameters) {
            if (typeInformation == null) {
                throw new IllegalArgumentException("typeInformation is null");
            }
            if (typeParameters == null) {
                throw new IllegalArgumentException("typeParameters is null");
            }
            this.typeInformation = typeInformation;
            this.typeParameters = typeParameters;
        }
    }
}

