/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.data.util.CloseableIterator;
import org.springframework.data.util.MultiValueMapCollector;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public interface StreamUtils {
    public static <T> Stream<T> createStreamFromIterator(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> createStreamFromIterator(CloseableIterator<T> iterator) {
        Assert.notNull(iterator, (String)"Iterator must not be null!");
        return (Stream)StreamUtils.createStreamFromIterator(iterator).onClose(() -> iterator.close());
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet);
    }

    public static <T, K, V> Collector<T, MultiValueMap<K, V>, MultiValueMap<K, V>> toMultiMap(Function<T, K> keyFunction, Function<T, V> valueFunction) {
        return MultiValueMapCollector.of(keyFunction, valueFunction);
    }
}

