/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Optional;
import lombok.NonNull;
import org.springframework.util.Assert;

public final class Range<T extends Comparable<T>> {
    private static final Range<?> UNBOUNDED = Range.of(Bound.unbounded(), Bound.access$000());
    @NonNull
    private final Bound<T> lowerBound;
    @NonNull
    private final Bound<T> upperBound;

    @Deprecated
    public Range(T lowerBound, T upperBound) {
        this(lowerBound, upperBound, true, true);
    }

    @Deprecated
    public Range(T lowerBound, T upperBound, boolean lowerInclusive, boolean upperInclusive) {
        Bound bound = lowerBound == null ? Bound.unbounded() : (this.lowerBound = lowerInclusive ? Bound.inclusive(lowerBound) : Bound.exclusive(lowerBound));
        this.upperBound = upperBound == null ? Bound.unbounded() : (upperInclusive ? Bound.inclusive(upperBound) : Bound.exclusive(upperBound));
    }

    public static <T extends Comparable<T>> Range<T> unbounded() {
        return UNBOUNDED;
    }

    public static <T extends Comparable<T>> RangeBuilder<T> from(Bound<T> lower) {
        Assert.notNull(lower, (String)"Lower bound must not be null!");
        return new RangeBuilder<T>(lower);
    }

    public static <T extends Comparable<T>> Range<T> of(Bound<T> lowerBound, Bound<T> upperBound) {
        return new Range<T>(lowerBound, upperBound);
    }

    @Deprecated
    public boolean isLowerInclusive() {
        return this.lowerBound.isInclusive();
    }

    @Deprecated
    public boolean isUpperInclusive() {
        return this.upperBound.isInclusive();
    }

    public boolean contains(T value) {
        Assert.notNull(value, (String)"Reference value must not be null!");
        boolean greaterThanLowerBound = this.lowerBound.getValue().map(it -> this.lowerBound.isInclusive() ? it.compareTo(value) <= 0 : it.compareTo(value) < 0).orElse(true);
        boolean lessThanUpperBound = this.upperBound.getValue().map(it -> this.upperBound.isInclusive() ? it.compareTo(value) >= 0 : it.compareTo(value) > 0).orElse(true);
        return greaterThanLowerBound && lessThanUpperBound;
    }

    public String toString() {
        return String.format("%s-%s", this.lowerBound.toPrefixString(), this.upperBound.toSuffixString());
    }

    @NonNull
    public Bound<T> getLowerBound() {
        return this.lowerBound;
    }

    @NonNull
    public Bound<T> getUpperBound() {
        return this.upperBound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        Bound<T> this$lowerBound = this.getLowerBound();
        Bound<T> other$lowerBound = other.getLowerBound();
        if (this$lowerBound == null ? other$lowerBound != null : !((Object)this$lowerBound).equals(other$lowerBound)) {
            return false;
        }
        Bound<T> this$upperBound = this.getUpperBound();
        Bound<T> other$upperBound = other.getUpperBound();
        return !(this$upperBound == null ? other$upperBound != null : !((Object)this$upperBound).equals(other$upperBound));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Bound<T> $lowerBound = this.getLowerBound();
        result = result * 59 + ($lowerBound == null ? 43 : ((Object)$lowerBound).hashCode());
        Bound<T> $upperBound = this.getUpperBound();
        result = result * 59 + ($upperBound == null ? 43 : ((Object)$upperBound).hashCode());
        return result;
    }

    private Range(@NonNull Bound<T> lowerBound, @NonNull Bound<T> upperBound) {
        if (lowerBound == null) {
            throw new IllegalArgumentException("lowerBound is null");
        }
        if (upperBound == null) {
            throw new IllegalArgumentException("upperBound is null");
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public static class RangeBuilder<T extends Comparable<T>> {
        private final Bound<T> lower;

        RangeBuilder(Bound<T> lower) {
            this.lower = lower;
        }

        public Range<T> to(Bound<T> upper) {
            Assert.notNull(upper, (String)"Upper bound must not be null!");
            return new Range(this.lower, upper);
        }
    }

    public static final class Bound<T extends Comparable<T>> {
        private static final Bound<?> UNBOUNDED = new Bound(Optional.empty(), true);
        private final Optional<T> value;
        private final boolean inclusive;

        public static <T extends Comparable<T>> Bound<T> unbounded() {
            return UNBOUNDED;
        }

        public boolean isBounded() {
            return this.value.isPresent();
        }

        public static <T extends Comparable<T>> Bound<T> inclusive(T value) {
            Assert.notNull(value, (String)"Value must not be null!");
            return new Bound<T>(Optional.of(value), true);
        }

        public static Bound<Integer> inclusive(int value) {
            return Bound.inclusive(Integer.valueOf(value));
        }

        public static Bound<Long> inclusive(long value) {
            return Bound.inclusive(Long.valueOf(value));
        }

        public static Bound<Float> inclusive(float value) {
            return Bound.inclusive(Float.valueOf(value));
        }

        public static Bound<Double> inclusive(double value) {
            return Bound.inclusive(Double.valueOf(value));
        }

        public static <T extends Comparable<T>> Bound<T> exclusive(T value) {
            Assert.notNull(value, (String)"Value must not be null!");
            return new Bound<T>(Optional.of(value), false);
        }

        public static Bound<Integer> exclusive(int value) {
            return Bound.exclusive(Integer.valueOf(value));
        }

        public static Bound<Long> exclusive(long value) {
            return Bound.exclusive(Long.valueOf(value));
        }

        public static Bound<Float> exclusive(float value) {
            return Bound.exclusive(Float.valueOf(value));
        }

        public static Bound<Double> exclusive(double value) {
            return Bound.exclusive(Double.valueOf(value));
        }

        String toPrefixString() {
            return this.getValue().map(Object::toString).map(it -> this.isInclusive() ? "[".concat((String)it) : "(".concat((String)it)).orElse("unbounded");
        }

        String toSuffixString() {
            return this.getValue().map(Object::toString).map(it -> this.isInclusive() ? it.concat("]") : it.concat(")")).orElse("unbounded");
        }

        public String toString() {
            return this.value.map(Object::toString).orElse("unbounded");
        }

        public Optional<T> getValue() {
            return this.value;
        }

        public boolean isInclusive() {
            return this.inclusive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bound)) {
                return false;
            }
            Bound other = (Bound)o;
            Optional<T> this$value = this.getValue();
            Optional<T> other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            return this.isInclusive() == other.isInclusive();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<T> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            result = result * 59 + (this.isInclusive() ? 79 : 97);
            return result;
        }

        private Bound(Optional<T> value, boolean inclusive) {
            this.value = value;
            this.inclusive = inclusive;
        }

        static /* synthetic */ Bound access$000() {
            return UNBOUNDED;
        }
    }
}

