/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.ResolvableType;
import org.springframework.data.projection.DefaultMethodInvokingMethodInterceptor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryInformation;
import org.springframework.data.repository.core.support.MethodInvocationValidator;
import org.springframework.data.repository.core.support.MethodLookups;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.QueryExecutionResultHandler;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.repository.core.support.SurroundingTransactionDetectorMethodInterceptor;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.data.util.Pair;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.transaction.interceptor.TransactionalProxy;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class RepositoryFactorySupport
implements BeanClassLoaderAware,
BeanFactoryAware {
    private static final BiFunction<Method, Object[], Object[]> REACTIVE_ARGS_CONVERTER = (method, o) -> {
        if (ReactiveWrappers.isAvailable()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] converted = new Object[((Object[])o).length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                Object value = o[i];
                if (value == null) continue;
                converted[i] = !parameterType.isAssignableFrom(value.getClass()) && ReactiveWrapperConverters.canConvert(value.getClass(), parameterType) ? ReactiveWrapperConverters.toWrapper(value, parameterType) : value;
            }
            return converted;
        }
        return o;
    };
    private final Map<RepositoryInformationCacheKey, RepositoryInformation> repositoryInformationCache;
    private final List<RepositoryProxyPostProcessor> postProcessors;
    private Optional<Class<?>> repositoryBaseClass;
    @Nullable
    private QueryLookupStrategy.Key queryLookupStrategyKey;
    private List<QueryCreationListener<?>> queryPostProcessors;
    private NamedQueries namedQueries;
    private ClassLoader classLoader;
    private QueryMethodEvaluationContextProvider evaluationContextProvider;
    private BeanFactory beanFactory;
    private final QueryCollectingQueryCreationListener collectingListener = new QueryCollectingQueryCreationListener();

    public RepositoryFactorySupport() {
        this.repositoryInformationCache = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);
        this.postProcessors = new ArrayList<RepositoryProxyPostProcessor>();
        this.repositoryBaseClass = Optional.empty();
        this.namedQueries = PropertiesBasedNamedQueries.EMPTY;
        this.classLoader = org.springframework.util.ClassUtils.getDefaultClassLoader();
        this.evaluationContextProvider = QueryMethodEvaluationContextProvider.DEFAULT;
        this.queryPostProcessors = new ArrayList();
        this.queryPostProcessors.add(this.collectingListener);
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key key) {
        this.queryLookupStrategyKey = key;
    }

    public void setNamedQueries(NamedQueries namedQueries) {
        this.namedQueries = namedQueries == null ? PropertiesBasedNamedQueries.EMPTY : namedQueries;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? org.springframework.util.ClassUtils.getDefaultClassLoader() : classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEvaluationContextProvider(QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this.evaluationContextProvider = evaluationContextProvider == null ? QueryMethodEvaluationContextProvider.DEFAULT : evaluationContextProvider;
    }

    public void setRepositoryBaseClass(Class<?> repositoryBaseClass) {
        this.repositoryBaseClass = Optional.ofNullable(repositoryBaseClass);
    }

    public void addQueryCreationListener(QueryCreationListener<?> listener) {
        Assert.notNull(listener, (String)"Listener must not be null!");
        this.queryPostProcessors.add(listener);
    }

    public void addRepositoryProxyPostProcessor(RepositoryProxyPostProcessor processor) {
        Assert.notNull((Object)processor, (String)"RepositoryProxyPostProcessor must not be null!");
        this.postProcessors.add(processor);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return RepositoryComposition.RepositoryFragments.empty();
    }

    private RepositoryComposition getRepositoryComposition(RepositoryMetadata metadata) {
        RepositoryComposition composition = RepositoryComposition.empty();
        if (metadata.isReactiveRepository()) {
            return composition.withMethodLookup(MethodLookups.forReactiveTypes(metadata)).withArgumentConverter(REACTIVE_ARGS_CONVERTER);
        }
        return composition.withMethodLookup(MethodLookups.forRepositoryTypes(metadata));
    }

    public <T> T getRepository(Class<T> repositoryInterface) {
        return this.getRepository(repositoryInterface, RepositoryComposition.RepositoryFragments.empty());
    }

    @Deprecated
    public <T> T getRepository(Class<T> repositoryInterface, Object customImplementation) {
        return this.getRepository(repositoryInterface, RepositoryComposition.RepositoryFragments.just(customImplementation));
    }

    public <T> T getRepository(Class<T> repositoryInterface, RepositoryComposition.RepositoryFragments fragments) {
        Assert.notNull(repositoryInterface, (String)"Repository interface must not be null!");
        Assert.notNull((Object)fragments, (String)"RepositoryFragments must not be null!");
        RepositoryMetadata metadata = this.getRepositoryMetadata(repositoryInterface);
        RepositoryComposition composition = this.getRepositoryComposition(metadata, fragments);
        RepositoryInformation information = this.getRepositoryInformation(metadata, composition);
        this.validate(information, composition);
        Object target = this.getTargetRepository(information);
        ProxyFactory result = new ProxyFactory();
        result.setTarget(target);
        result.setInterfaces(new Class[]{repositoryInterface, Repository.class, TransactionalProxy.class});
        if (MethodInvocationValidator.supports(repositoryInterface)) {
            result.addAdvice((Advice)new MethodInvocationValidator());
        }
        result.addAdvice((Advice)SurroundingTransactionDetectorMethodInterceptor.INSTANCE);
        result.addAdvisor(ExposeInvocationInterceptor.ADVISOR);
        this.postProcessors.forEach(processor -> processor.postProcess(result, information));
        result.addAdvice((Advice)new DefaultMethodInvokingMethodInterceptor());
        ProjectionFactory projectionFactory = this.getProjectionFactory(this.classLoader, this.beanFactory);
        result.addAdvice((Advice)new QueryExecutorMethodInterceptor(information, projectionFactory));
        composition = composition.append(RepositoryFragment.implemented(target));
        result.addAdvice((Advice)new ImplementationMethodExecutionInterceptor(composition));
        return (T)result.getProxy(this.classLoader);
    }

    protected ProjectionFactory getProjectionFactory(ClassLoader classLoader, BeanFactory beanFactory) {
        SpelAwareProxyProjectionFactory factory = new SpelAwareProxyProjectionFactory();
        factory.setBeanClassLoader(classLoader);
        factory.setBeanFactory(beanFactory);
        return factory;
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repositoryInterface) {
        return AbstractRepositoryMetadata.getMetadata(repositoryInterface);
    }

    protected RepositoryInformation getRepositoryInformation(RepositoryMetadata metadata, RepositoryComposition.RepositoryFragments fragments) {
        return this.getRepositoryInformation(metadata, this.getRepositoryComposition(metadata, fragments));
    }

    private RepositoryComposition getRepositoryComposition(RepositoryMetadata metadata, RepositoryComposition.RepositoryFragments fragments) {
        Assert.notNull((Object)metadata, (String)"RepositoryMetadata must not be null!");
        Assert.notNull((Object)fragments, (String)"RepositoryFragments must not be null!");
        RepositoryComposition composition = this.getRepositoryComposition(metadata);
        RepositoryComposition.RepositoryFragments repositoryAspects = this.getRepositoryFragments(metadata);
        return composition.append(fragments).append(repositoryAspects);
    }

    private RepositoryInformation getRepositoryInformation(RepositoryMetadata metadata, RepositoryComposition composition) {
        RepositoryInformationCacheKey cacheKey = new RepositoryInformationCacheKey(metadata, composition);
        return this.repositoryInformationCache.computeIfAbsent(cacheKey, key -> {
            Class<?> baseClass = this.repositoryBaseClass.orElse(this.getRepositoryBaseClass(metadata));
            return new DefaultRepositoryInformation(metadata, baseClass, composition);
        });
    }

    protected List<QueryMethod> getQueryMethods() {
        return this.collectingListener.getQueryMethods();
    }

    public abstract <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> var1);

    protected abstract Object getTargetRepository(RepositoryInformation var1);

    protected abstract Class<?> getRepositoryBaseClass(RepositoryMetadata var1);

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.empty();
    }

    private void validate(RepositoryInformation repositoryInformation, RepositoryComposition composition) {
        if (repositoryInformation.hasCustomMethod()) {
            if (composition.isEmpty()) {
                throw new IllegalArgumentException(String.format("You have custom methods in %s but not provided a custom implementation!", repositoryInformation.getRepositoryInterface()));
            }
            composition.validateImplementation();
        }
        this.validate(repositoryInformation);
    }

    protected void validate(RepositoryMetadata repositoryMetadata) {
    }

    protected final <R> R getTargetRepositoryViaReflection(RepositoryInformation information, Object ... constructorArguments) {
        Class<?> baseClass = information.getRepositoryBaseClass();
        return this.getTargetRepositoryViaReflection(baseClass, constructorArguments);
    }

    protected final <R> R getTargetRepositoryViaReflection(Class<?> baseClass, Object ... constructorArguments) {
        Optional<Constructor<?>> constructor = ReflectionUtils.findConstructor(baseClass, constructorArguments);
        return (R)constructor.map(it -> BeanUtils.instantiateClass((Constructor)it, (Object[])constructorArguments)).orElseThrow(() -> new IllegalStateException(String.format("No suitable constructor found on %s to match the given arguments: %s. Make sure you implement a constructor taking these", baseClass, Arrays.stream(constructorArguments).map(Object::getClass).collect(Collectors.toList()))));
    }

    private static final class RepositoryInformationCacheKey {
        private final String repositoryInterfaceName;
        private final long compositionHash;

        public RepositoryInformationCacheKey(RepositoryMetadata metadata, RepositoryComposition composition) {
            this.repositoryInterfaceName = metadata.getRepositoryInterface().getName();
            this.compositionHash = composition.hashCode();
        }

        public String getRepositoryInterfaceName() {
            return this.repositoryInterfaceName;
        }

        public long getCompositionHash() {
            return this.compositionHash;
        }

        public String toString() {
            return "RepositoryFactorySupport.RepositoryInformationCacheKey(repositoryInterfaceName=" + this.getRepositoryInterfaceName() + ", compositionHash=" + this.getCompositionHash() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepositoryInformationCacheKey)) {
                return false;
            }
            RepositoryInformationCacheKey other = (RepositoryInformationCacheKey)o;
            String this$repositoryInterfaceName = this.getRepositoryInterfaceName();
            String other$repositoryInterfaceName = other.getRepositoryInterfaceName();
            if (this$repositoryInterfaceName == null ? other$repositoryInterfaceName != null : !this$repositoryInterfaceName.equals(other$repositoryInterfaceName)) {
                return false;
            }
            return this.getCompositionHash() == other.getCompositionHash();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $repositoryInterfaceName = this.getRepositoryInterfaceName();
            result = result * 59 + ($repositoryInterfaceName == null ? 43 : $repositoryInterfaceName.hashCode());
            long $compositionHash = this.getCompositionHash();
            result = result * 59 + (int)($compositionHash >>> 32 ^ $compositionHash);
            return result;
        }
    }

    private static class QueryCollectingQueryCreationListener
    implements QueryCreationListener<RepositoryQuery> {
        private final List<QueryMethod> queryMethods = new ArrayList<QueryMethod>();

        private QueryCollectingQueryCreationListener() {
        }

        @Override
        public void onCreation(RepositoryQuery query) {
            this.queryMethods.add(query.getQueryMethod());
        }

        public List<QueryMethod> getQueryMethods() {
            return this.queryMethods;
        }
    }

    public class ImplementationMethodExecutionInterceptor
    implements MethodInterceptor {
        @NonNull
        private final RepositoryComposition composition;

        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            try {
                return this.composition.invoke(method, arguments);
            }
            catch (Exception e) {
                ClassUtils.unwrapReflectionException(e);
                throw new IllegalStateException("Should not occur!");
            }
        }

        public ImplementationMethodExecutionInterceptor(RepositoryComposition composition) {
            if (composition == null) {
                throw new IllegalArgumentException("composition is null");
            }
            this.composition = composition;
        }
    }

    public class QueryExecutorMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, RepositoryQuery> queries;
        private final QueryExecutionResultHandler resultHandler = new QueryExecutionResultHandler();

        public QueryExecutorMethodInterceptor(RepositoryInformation repositoryInformation, ProjectionFactory projectionFactory) {
            Optional<QueryLookupStrategy> lookupStrategy = RepositoryFactorySupport.this.getQueryLookupStrategy(RepositoryFactorySupport.this.queryLookupStrategyKey, RepositoryFactorySupport.this.evaluationContextProvider);
            if (!lookupStrategy.isPresent() && repositoryInformation.hasQueryMethods()) {
                throw new IllegalStateException("You have defined query method in the repository but you don't have any query lookup strategy defined. The infrastructure apparently does not support query methods!");
            }
            this.queries = lookupStrategy.map(it -> this.mapMethodsToQuery(repositoryInformation, (QueryLookupStrategy)it, projectionFactory)).orElse(Collections.emptyMap());
        }

        private Map<Method, RepositoryQuery> mapMethodsToQuery(RepositoryInformation repositoryInformation, QueryLookupStrategy lookupStrategy, ProjectionFactory projectionFactory) {
            return repositoryInformation.getQueryMethods().stream().map(method -> this.lookupQuery((Method)method, repositoryInformation, lookupStrategy, projectionFactory)).peek(pair -> this.invokeListeners((RepositoryQuery)pair.getSecond())).collect(Pair.toMap());
        }

        private Pair<Method, RepositoryQuery> lookupQuery(Method method, RepositoryInformation information, QueryLookupStrategy strategy, ProjectionFactory projectionFactory) {
            return Pair.of(method, strategy.resolveQuery(method, information, projectionFactory, RepositoryFactorySupport.this.namedQueries));
        }

        private void invokeListeners(RepositoryQuery query) {
            for (QueryCreationListener listener : RepositoryFactorySupport.this.queryPostProcessors) {
                ResolvableType typeArgument = ResolvableType.forClass(QueryCreationListener.class, listener.getClass()).getGeneric(new int[]{0});
                if (typeArgument == null || !typeArgument.isAssignableFrom(ResolvableType.forClass(query.getClass()))) continue;
                listener.onCreation(query);
            }
        }

        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object result = this.doInvoke(invocation);
            return this.resultHandler.postProcessInvocationResult(result, invocation.getMethod());
        }

        @Nullable
        private Object doInvoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            if (this.hasQueryFor(method)) {
                return this.queries.get(method).execute(arguments);
            }
            return invocation.proceed();
        }

        private boolean hasQueryFor(Method method) {
            return this.queries.containsKey(method);
        }
    }
}

