/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.aot.DefaultAotContext;
import org.springframework.data.util.TypeScanner;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public interface AotContext
extends EnvironmentCapable {
    public static final String GENERATED_REPOSITORIES_ENABLED = "spring.aot.repositories.enabled";

    public static AotContext from(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        return new DefaultAotContext(beanFactory, (Environment)new StandardEnvironment());
    }

    public static AotContext from(BeanFactory beanFactory, Environment environment) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        return new DefaultAotContext(beanFactory, environment);
    }

    default public boolean isGeneratedRepositoriesEnabled(@Nullable String moduleName) {
        Environment environment = this.getEnvironment();
        if (!((Boolean)environment.getProperty(GENERATED_REPOSITORIES_ENABLED, Boolean.class, (Object)true)).booleanValue()) {
            return false;
        }
        if (!StringUtils.hasText((String)moduleName)) {
            return true;
        }
        String modulePropertyName = GENERATED_REPOSITORIES_ENABLED.replace("repositories", "%s.repositories".formatted(moduleName.toLowerCase(Locale.ROOT)));
        return (Boolean)environment.getProperty(modulePropertyName, Boolean.class, (Object)true);
    }

    public ConfigurableListableBeanFactory getBeanFactory();

    default public @Nullable ClassLoader getClassLoader() {
        return this.getBeanFactory().getBeanClassLoader();
    }

    default public ClassLoader getRequiredClassLoader() {
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            throw new IllegalStateException("Required ClassLoader is not available");
        }
        return loader;
    }

    public TypeIntrospector introspectType(String var1);

    default public TypeScanner getTypeScanner() {
        return TypeScanner.typeScanner(this.getRequiredClassLoader());
    }

    default public Set<Class<?>> scanPackageForTypes(Collection<Class<? extends Annotation>> identifyingAnnotations, Collection<String> packageNames) {
        return this.getTypeScanner().scanPackages(packageNames).forTypesAnnotatedWith(identifyingAnnotations).collectAsSet();
    }

    default public IntrospectedBeanDefinition introspectBeanDefinition(BeanReference reference) {
        return this.introspectBeanDefinition(reference.getBeanName());
    }

    public IntrospectedBeanDefinition introspectBeanDefinition(String var1);

    public static interface IntrospectedBeanDefinition {
        public boolean isPresent();

        public boolean isFactoryBean();

        public BeanDefinition getBeanDefinition() throws NoSuchBeanDefinitionException;

        public RootBeanDefinition getRootBeanDefinition() throws NoSuchBeanDefinitionException;

        public @Nullable Class<?> resolveType();
    }

    public static interface TypeIntrospector {
        public boolean isTypePresent();

        public Class<?> resolveRequiredType() throws TypeNotPresentException;

        public Optional<Class<?>> resolveType();

        default public void ifTypePresent(Consumer<Class<?>> action) {
            this.resolveType().ifPresent(action);
        }

        public boolean hasBean();

        public List<String> getBeanNames();
    }
}

