/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.javapoet.FieldSpec;
import org.springframework.javapoet.TypeName;

public class AotRepositoryFragmentMetadata {
    private final Map<String, FieldSpec> fields = new HashMap<String, FieldSpec>(3);
    private final Map<String, ConstructorArgument> constructorArguments = new LinkedHashMap<String, ConstructorArgument>(3);

    public @Nullable String fieldNameOf(Class<?> type) {
        TypeName lookup = TypeName.get(type).withoutAnnotations();
        for (Map.Entry<String, FieldSpec> field : this.fields.entrySet()) {
            if (!field.getValue().type().withoutAnnotations().equals((Object)lookup)) continue;
            return field.getKey();
        }
        return null;
    }

    public void addField(String fieldName, TypeName type, Modifier ... modifiers) {
        this.fields.put(fieldName, FieldSpec.builder((TypeName)type, (String)fieldName, (Modifier[])modifiers).build());
    }

    public void addField(FieldSpec fieldSpec) {
        this.fields.put(fieldSpec.name(), fieldSpec);
    }

    public Map<String, FieldSpec> getFields() {
        return this.fields;
    }

    public void addConstructorArgument(String parameterName, TypeName type, @Nullable String fieldName) {
        this.constructorArguments.put(parameterName, new ConstructorArgument(parameterName, type, fieldName));
        if (fieldName != null) {
            this.addField(parameterName, type, Modifier.PRIVATE, Modifier.FINAL);
        }
    }

    public Map<String, ConstructorArgument> getConstructorArguments() {
        return this.constructorArguments;
    }

    public record ConstructorArgument(String parameterName, TypeName typeName, @Nullable String fieldName) {
        @Deprecated(forRemoval=true)
        boolean isForLocalField() {
            return this.isBoundToField();
        }

        boolean isBoundToField() {
            return this.fieldName != null;
        }
    }
}

