/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortArgumentResolver;
import org.springframework.data.web.SortHandlerMethodArgumentResolverSupport;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UriUtils;

public class SortHandlerMethodArgumentResolver
extends SortHandlerMethodArgumentResolverSupport
implements SortArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return Sort.class.equals((Object)parameter.getParameterType());
    }

    @Override
    public @NonNull Sort resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        String[] directionParameter = webRequest.getParameterValues(this.getSortParameter(parameter));
        if (directionParameter == null) {
            return this.getDefaultFromAnnotationOrFallback(parameter);
        }
        if (directionParameter.length == 1 && !StringUtils.hasText((String)directionParameter[0])) {
            return this.getDefaultFromAnnotationOrFallback(parameter);
        }
        List<String> decoded = Arrays.stream(directionParameter).map(it -> UriUtils.decode((String)it, (Charset)StandardCharsets.UTF_8)).toList();
        return this.parseParameterIntoSort(decoded, this.getPropertyDelimiter());
    }
}

