/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.FailFastRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import org.springframework.beans.factory.config.AbstractFactoryBean;

class CouchbaseEnvironmentFactoryBean
extends AbstractFactoryBean<CouchbaseEnvironment> {
    private static final CouchbaseEnvironment DEFAULT_ENV = DefaultCouchbaseEnvironment.create();
    public static final String RETRYSTRATEGY_FAILFAST = "FailFast";
    public static final String RETRYSTRATEGY_BESTEFFORT = "BestEffort";
    private long managementTimeout = DEFAULT_ENV.managementTimeout();
    private long queryTimeout = DEFAULT_ENV.queryTimeout();
    private long viewTimeout = DEFAULT_ENV.viewTimeout();
    private long kvTimeout = DEFAULT_ENV.kvTimeout();
    private long connectTimeout = DEFAULT_ENV.connectTimeout();
    private long disconnectTimeout = DEFAULT_ENV.disconnectTimeout();
    private boolean dnsSrvEnabled = DEFAULT_ENV.dnsSrvEnabled();
    private boolean dcpEnabled = DEFAULT_ENV.dcpEnabled();
    private boolean sslEnabled = DEFAULT_ENV.sslEnabled();
    private String sslKeystoreFile = DEFAULT_ENV.sslKeystoreFile();
    private String sslKeystorePassword = DEFAULT_ENV.sslKeystorePassword();
    private boolean queryEnabled = DEFAULT_ENV.queryEnabled();
    private int queryPort = DEFAULT_ENV.queryPort();
    private boolean bootstrapHttpEnabled = DEFAULT_ENV.bootstrapHttpEnabled();
    private boolean bootstrapCarrierEnabled = DEFAULT_ENV.bootstrapCarrierEnabled();
    private int bootstrapHttpDirectPort = DEFAULT_ENV.bootstrapHttpDirectPort();
    private int bootstrapHttpSslPort = DEFAULT_ENV.bootstrapHttpSslPort();
    private int bootstrapCarrierDirectPort = DEFAULT_ENV.bootstrapCarrierDirectPort();
    private int bootstrapCarrierSslPort = DEFAULT_ENV.bootstrapCarrierSslPort();
    private int ioPoolSize = DEFAULT_ENV.ioPoolSize();
    private int computationPoolSize = DEFAULT_ENV.computationPoolSize();
    private int responseBufferSize = DEFAULT_ENV.responseBufferSize();
    private int requestBufferSize = DEFAULT_ENV.requestBufferSize();
    private int kvEndpoints = DEFAULT_ENV.kvEndpoints();
    private int viewEndpoints = DEFAULT_ENV.viewEndpoints();
    private int queryEndpoints = DEFAULT_ENV.queryEndpoints();
    private RetryStrategy retryStrategy = DEFAULT_ENV.retryStrategy();
    private long maxRequestLifetime = DEFAULT_ENV.maxRequestLifetime();
    private long keepAliveInterval = DEFAULT_ENV.keepAliveInterval();
    private long autoreleaseAfter = DEFAULT_ENV.autoreleaseAfter();
    private boolean bufferPoolingEnabled = DEFAULT_ENV.bufferPoolingEnabled();
    private boolean tcpNodelayEnabled = DEFAULT_ENV.tcpNodelayEnabled();
    private boolean mutationTokensEnabled = DEFAULT_ENV.mutationTokensEnabled();

    CouchbaseEnvironmentFactoryBean() {
    }

    public Class<?> getObjectType() {
        return DefaultCouchbaseEnvironment.class;
    }

    protected CouchbaseEnvironment createInstance() throws Exception {
        return DefaultCouchbaseEnvironment.builder().managementTimeout(this.managementTimeout).queryTimeout(this.queryTimeout).viewTimeout(this.viewTimeout).kvTimeout(this.kvTimeout).connectTimeout(this.connectTimeout).disconnectTimeout(this.disconnectTimeout).dnsSrvEnabled(this.dnsSrvEnabled).dcpEnabled(this.dcpEnabled).sslEnabled(this.sslEnabled).sslKeystoreFile(this.sslKeystoreFile).sslKeystorePassword(this.sslKeystorePassword).queryEnabled(this.queryEnabled).queryPort(this.queryPort).bootstrapHttpEnabled(this.bootstrapHttpEnabled).bootstrapCarrierEnabled(this.bootstrapCarrierEnabled).bootstrapHttpDirectPort(this.bootstrapHttpDirectPort).bootstrapHttpSslPort(this.bootstrapHttpSslPort).bootstrapCarrierDirectPort(this.bootstrapCarrierDirectPort).bootstrapCarrierSslPort(this.bootstrapCarrierSslPort).ioPoolSize(this.ioPoolSize).computationPoolSize(this.computationPoolSize).responseBufferSize(this.responseBufferSize).requestBufferSize(this.requestBufferSize).kvEndpoints(this.kvEndpoints).viewEndpoints(this.viewEndpoints).queryEndpoints(this.queryEndpoints).retryStrategy(this.retryStrategy).maxRequestLifetime(this.maxRequestLifetime).keepAliveInterval(this.keepAliveInterval).autoreleaseAfter(this.autoreleaseAfter).bufferPoolingEnabled(this.bufferPoolingEnabled).tcpNodelayEnabled(this.tcpNodelayEnabled).mutationTokensEnabled(this.mutationTokensEnabled).build();
    }

    public void setRetryStrategy(String retryStrategy) {
        if (RETRYSTRATEGY_FAILFAST.equals(retryStrategy)) {
            this.retryStrategy = FailFastRetryStrategy.INSTANCE;
        } else if (RETRYSTRATEGY_BESTEFFORT.equals(retryStrategy)) {
            this.retryStrategy = BestEffortRetryStrategy.INSTANCE;
        }
    }

    public void setManagementTimeout(long managementTimeout) {
        this.managementTimeout = managementTimeout;
    }

    public void setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setViewTimeout(long viewTimeout) {
        this.viewTimeout = viewTimeout;
    }

    public void setKvTimeout(long kvTimeout) {
        this.kvTimeout = kvTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setDisconnectTimeout(long disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
    }

    public void setDnsSrvEnabled(boolean dnsSrvEnabled) {
        this.dnsSrvEnabled = dnsSrvEnabled;
    }

    public void setDcpEnabled(boolean dcpEnabled) {
        this.dcpEnabled = dcpEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setSslKeystoreFile(String sslKeystoreFile) {
        this.sslKeystoreFile = sslKeystoreFile;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public void setQueryEnabled(boolean queryEnabled) {
        this.queryEnabled = queryEnabled;
    }

    public void setQueryPort(int queryPort) {
        this.queryPort = queryPort;
    }

    public void setBootstrapHttpEnabled(boolean bootstrapHttpEnabled) {
        this.bootstrapHttpEnabled = bootstrapHttpEnabled;
    }

    public void setBootstrapCarrierEnabled(boolean bootstrapCarrierEnabled) {
        this.bootstrapCarrierEnabled = bootstrapCarrierEnabled;
    }

    public void setBootstrapHttpDirectPort(int bootstrapHttpDirectPort) {
        this.bootstrapHttpDirectPort = bootstrapHttpDirectPort;
    }

    public void setBootstrapHttpSslPort(int bootstrapHttpSslPort) {
        this.bootstrapHttpSslPort = bootstrapHttpSslPort;
    }

    public void setBootstrapCarrierDirectPort(int bootstrapCarrierDirectPort) {
        this.bootstrapCarrierDirectPort = bootstrapCarrierDirectPort;
    }

    public void setBootstrapCarrierSslPort(int bootstrapCarrierSslPort) {
        this.bootstrapCarrierSslPort = bootstrapCarrierSslPort;
    }

    public void setIoPoolSize(int ioPoolSize) {
        this.ioPoolSize = ioPoolSize;
    }

    public void setComputationPoolSize(int computationPoolSize) {
        this.computationPoolSize = computationPoolSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public void setKvEndpoints(int kvEndpoints) {
        this.kvEndpoints = kvEndpoints;
    }

    public void setViewEndpoints(int viewEndpoints) {
        this.viewEndpoints = viewEndpoints;
    }

    public void setQueryEndpoints(int queryEndpoints) {
        this.queryEndpoints = queryEndpoints;
    }

    public void setMaxRequestLifetime(long maxRequestLifetime) {
        this.maxRequestLifetime = maxRequestLifetime;
    }

    public void setKeepAliveInterval(long keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public void setAutoreleaseAfter(long autoreleaseAfter) {
        this.autoreleaseAfter = autoreleaseAfter;
    }

    public void setBufferPoolingEnabled(boolean bufferPoolingEnabled) {
        this.bufferPoolingEnabled = bufferPoolingEnabled;
    }

    public void setTcpNodelayEnabled(boolean tcpNodelayEnabled) {
        this.tcpNodelayEnabled = tcpNodelayEnabled;
    }

    public void setMutationTokensEnabled(boolean mutationTokensEnabled) {
        this.mutationTokensEnabled = mutationTokensEnabled;
    }
}

