/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.CustomConversions;

public abstract class AbstractCouchbaseConverter
implements CouchbaseConverter,
InitializingBean {
    protected final GenericConversionService conversionService;
    protected EntityInstantiators instantiators = new EntityInstantiators();
    protected CustomConversions conversions = new CustomConversions();

    protected AbstractCouchbaseConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomConversions(CustomConversions conversions) {
        this.conversions = conversions;
    }

    public void setInstantiators(EntityInstantiators instantiators) {
        this.instantiators = instantiators;
    }

    public void afterPropertiesSet() {
        this.conversions.registerConvertersIn(this.conversionService);
    }

    @Override
    public Object convertForWriteIfNeeded(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> targetType = this.conversions.getCustomWriteTarget(value.getClass());
        if (targetType != null) {
            return this.conversionService.convert(value, targetType);
        }
        return value;
    }

    @Override
    public Class<?> getWriteClassFor(Class<?> clazz) {
        Class<?> targetType = this.conversions.getCustomWriteTarget(clazz);
        return targetType != null ? targetType : clazz;
    }
}

