/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.couchbase.core.mapping.CouchbaseSimpleTypes;
import org.springframework.util.Assert;

class ConverterRegistration {
    private final GenericConverter.ConvertiblePair convertiblePair;
    private final boolean reading;
    private final boolean writing;

    public ConverterRegistration(GenericConverter.ConvertiblePair convertiblePair, boolean isReading, boolean isWriting) {
        Assert.notNull((Object)convertiblePair);
        this.convertiblePair = convertiblePair;
        this.reading = isReading;
        this.writing = isWriting;
    }

    public ConverterRegistration(Class<?> source, Class<?> target, boolean isReading, boolean isWriting) {
        this(new GenericConverter.ConvertiblePair(source, target), isReading, isWriting);
    }

    public boolean isWriting() {
        return this.writing || !this.reading && this.isSimpleTargetType();
    }

    public boolean isReading() {
        return this.reading || !this.writing && this.isSimpleSourceType();
    }

    public GenericConverter.ConvertiblePair getConvertiblePair() {
        return this.convertiblePair;
    }

    public boolean isSimpleSourceType() {
        return ConverterRegistration.isCouchbaseBasicType(this.convertiblePair.getSourceType());
    }

    public boolean isSimpleTargetType() {
        return ConverterRegistration.isCouchbaseBasicType(this.convertiblePair.getTargetType());
    }

    private static boolean isCouchbaseBasicType(Class<?> type) {
        return CouchbaseSimpleTypes.HOLDER.isSimpleType(type);
    }
}

