/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.FailFastRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import org.springframework.beans.factory.config.AbstractFactoryBean;

class CouchbaseEnvironmentFactoryBean
extends AbstractFactoryBean<CouchbaseEnvironment> {
    public static final String RETRYSTRATEGY_FAILFAST = "FailFast";
    public static final String RETRYSTRATEGY_BESTEFFORT = "BestEffort";
    private final DefaultCouchbaseEnvironment.Builder couchbaseEnvBuilder = DefaultCouchbaseEnvironment.builder();

    CouchbaseEnvironmentFactoryBean() {
    }

    public Class<?> getObjectType() {
        return DefaultCouchbaseEnvironment.class;
    }

    protected CouchbaseEnvironment createInstance() throws Exception {
        return this.couchbaseEnvBuilder.build();
    }

    public void setRetryStrategy(String retryStrategy) {
        if (RETRYSTRATEGY_FAILFAST.equals(retryStrategy)) {
            this.couchbaseEnvBuilder.retryStrategy((RetryStrategy)FailFastRetryStrategy.INSTANCE);
        } else if (RETRYSTRATEGY_BESTEFFORT.equals(retryStrategy)) {
            this.couchbaseEnvBuilder.retryStrategy((RetryStrategy)BestEffortRetryStrategy.INSTANCE);
        }
    }

    public void setManagementTimeout(long managementTimeout) {
        this.couchbaseEnvBuilder.managementTimeout(managementTimeout);
    }

    public void setQueryTimeout(long queryTimeout) {
        this.couchbaseEnvBuilder.queryTimeout(queryTimeout);
    }

    public void setViewTimeout(long viewTimeout) {
        this.couchbaseEnvBuilder.viewTimeout(viewTimeout);
    }

    public void setKvTimeout(long kvTimeout) {
        this.couchbaseEnvBuilder.kvTimeout(kvTimeout);
    }

    public void setConnectTimeout(long connectTimeout) {
        this.couchbaseEnvBuilder.connectTimeout(connectTimeout);
    }

    public void setDisconnectTimeout(long disconnectTimeout) {
        this.couchbaseEnvBuilder.disconnectTimeout(disconnectTimeout);
    }

    public void setDnsSrvEnabled(boolean dnsSrvEnabled) {
        this.couchbaseEnvBuilder.dnsSrvEnabled(dnsSrvEnabled);
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.couchbaseEnvBuilder.sslEnabled(sslEnabled);
    }

    public void setSslKeystoreFile(String sslKeystoreFile) {
        this.couchbaseEnvBuilder.sslKeystoreFile(sslKeystoreFile);
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.couchbaseEnvBuilder.sslKeystorePassword(sslKeystorePassword);
    }

    public void setBootstrapHttpEnabled(boolean bootstrapHttpEnabled) {
        this.couchbaseEnvBuilder.bootstrapHttpEnabled(bootstrapHttpEnabled);
    }

    public void setBootstrapCarrierEnabled(boolean bootstrapCarrierEnabled) {
        this.couchbaseEnvBuilder.bootstrapCarrierEnabled(bootstrapCarrierEnabled);
    }

    public void setBootstrapHttpDirectPort(int bootstrapHttpDirectPort) {
        this.couchbaseEnvBuilder.bootstrapHttpDirectPort(bootstrapHttpDirectPort);
    }

    public void setBootstrapHttpSslPort(int bootstrapHttpSslPort) {
        this.couchbaseEnvBuilder.bootstrapHttpSslPort(bootstrapHttpSslPort);
    }

    public void setBootstrapCarrierDirectPort(int bootstrapCarrierDirectPort) {
        this.couchbaseEnvBuilder.bootstrapCarrierDirectPort(bootstrapCarrierDirectPort);
    }

    public void setBootstrapCarrierSslPort(int bootstrapCarrierSslPort) {
        this.couchbaseEnvBuilder.bootstrapCarrierSslPort(bootstrapCarrierSslPort);
    }

    public void setIoPoolSize(int ioPoolSize) {
        this.couchbaseEnvBuilder.ioPoolSize(ioPoolSize);
    }

    public void setComputationPoolSize(int computationPoolSize) {
        this.couchbaseEnvBuilder.computationPoolSize(computationPoolSize);
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.couchbaseEnvBuilder.responseBufferSize(responseBufferSize);
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this.couchbaseEnvBuilder.requestBufferSize(requestBufferSize);
    }

    public void setKvEndpoints(int kvEndpoints) {
        this.couchbaseEnvBuilder.kvEndpoints(kvEndpoints);
    }

    public void setViewEndpoints(int viewEndpoints) {
        this.couchbaseEnvBuilder.viewEndpoints(viewEndpoints);
    }

    public void setQueryEndpoints(int queryEndpoints) {
        this.couchbaseEnvBuilder.queryEndpoints(queryEndpoints);
    }

    public void setMaxRequestLifetime(long maxRequestLifetime) {
        this.couchbaseEnvBuilder.maxRequestLifetime(maxRequestLifetime);
    }

    public void setKeepAliveInterval(long keepAliveInterval) {
        this.couchbaseEnvBuilder.keepAliveInterval(keepAliveInterval);
    }

    public void setAutoreleaseAfter(long autoreleaseAfter) {
        this.couchbaseEnvBuilder.autoreleaseAfter(autoreleaseAfter);
    }

    public void setBufferPoolingEnabled(boolean bufferPoolingEnabled) {
        this.couchbaseEnvBuilder.bufferPoolingEnabled(bufferPoolingEnabled);
    }

    public void setTcpNodelayEnabled(boolean tcpNodelayEnabled) {
        this.couchbaseEnvBuilder.tcpNodelayEnabled(tcpNodelayEnabled);
    }

    public void setMutationTokensEnabled(boolean mutationTokensEnabled) {
        this.couchbaseEnvBuilder.mutationTokensEnabled(mutationTokensEnabled);
    }

    public void setAnalyticsTimeout(long analyticsTimeout) {
        this.couchbaseEnvBuilder.analyticsTimeout(analyticsTimeout);
    }
}

