/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.RawJsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.query.AsyncN1qlQueryResult;
import com.couchbase.client.java.query.AsyncN1qlQueryRow;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.view.AsyncSpatialViewResult;
import com.couchbase.client.java.view.AsyncSpatialViewRow;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.AsyncViewRow;
import com.couchbase.client.java.view.SpatialViewQuery;
import com.couchbase.client.java.view.ViewQuery;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.couchbase.core.CouchbaseQueryExecutionException;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.core.WriteResultChecking;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.CouchbaseStorable;
import org.springframework.data.couchbase.core.query.Consistency;
import org.springframework.data.couchbase.core.support.TemplateUtils;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import rx.Observable;
import rx.functions.Func3;

public class RxJavaCouchbaseTemplate
implements RxJavaCouchbaseOperations {
    private static final WriteResultChecking DEFAULT_WRITE_RESULT_CHECKING = WriteResultChecking.NONE;
    protected final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private Bucket syncClient;
    private AsyncBucket client;
    private final ClusterInfo clusterInfo;
    private final CouchbaseConverter converter;
    private final TranslationService translationService;
    private Consistency configuredConsistency = Consistency.DEFAULT_CONSISTENCY;
    private WriteResultChecking writeResultChecking = DEFAULT_WRITE_RESULT_CHECKING;

    @Override
    public <T> Observable<T> save(T objectToSave) {
        return this.save(objectToSave, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<T> save(Iterable<T> batchToSave) {
        return Observable.from(batchToSave).flatMap(this::save);
    }

    @Override
    public <T> Observable<T> save(T objectToSave, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.doPersist(objectToSave, PersistType.SAVE, persistTo, replicateTo);
    }

    @Override
    public <T> Observable<T> save(Iterable<T> batchToSave, PersistTo persistTo, ReplicateTo replicateTo) {
        return Observable.from(batchToSave).flatMap(object -> this.save(object, persistTo, replicateTo));
    }

    @Override
    public <T> Observable<T> insert(T objectToSave) {
        return this.insert(objectToSave, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<T> insert(Iterable<T> batchToSave) {
        return Observable.from(batchToSave).flatMap(this::insert);
    }

    @Override
    public <T> Observable<T> insert(T objectToSave, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.doPersist(objectToSave, PersistType.INSERT, persistTo, replicateTo);
    }

    @Override
    public <T> Observable<T> insert(Iterable<T> batchToSave, PersistTo persistTo, ReplicateTo replicateTo) {
        return Observable.from(batchToSave).flatMap(objectToSave -> this.insert(objectToSave, persistTo, replicateTo));
    }

    @Override
    public <T> Observable<T> update(T objectToSave) {
        return this.update(objectToSave, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<T> update(Iterable<T> batchToSave) {
        return Observable.from(batchToSave).flatMap(this::update);
    }

    @Override
    public <T> Observable<T> update(T objectToSave, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.doPersist(objectToSave, PersistType.UPDATE, persistTo, replicateTo);
    }

    @Override
    public <T> Observable<T> update(Iterable<T> batchToSave, PersistTo persistTo, ReplicateTo replicateTo) {
        return Observable.from(batchToSave).flatMap(objectToSave -> this.update(objectToSave, persistTo, replicateTo));
    }

    @Override
    public <T> Observable<T> remove(T objectToRemove) {
        return this.doRemove(objectToRemove, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<T> remove(Iterable<T> batchToRemove) {
        return Observable.from(batchToRemove).flatMap(this::remove);
    }

    @Override
    public <T> Observable<T> remove(T objectToRemove, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.doRemove(objectToRemove, persistTo, replicateTo);
    }

    @Override
    public <T> Observable<T> remove(Iterable<T> batchToRemove, PersistTo persistTo, ReplicateTo replicateTo) {
        return Observable.from(batchToRemove).flatMap(object -> this.remove(object, persistTo, replicateTo));
    }

    public RxJavaCouchbaseTemplate(ClusterInfo clusterInfo, Bucket client) {
        this(clusterInfo, client, null, null);
    }

    public RxJavaCouchbaseTemplate(ClusterInfo clusterInfo, Bucket client, TranslationService translationService) {
        this(clusterInfo, client, null, translationService);
    }

    public void setWriteResultChecking(WriteResultChecking writeResultChecking) {
        this.writeResultChecking = writeResultChecking == null ? DEFAULT_WRITE_RESULT_CHECKING : writeResultChecking;
    }

    public RxJavaCouchbaseTemplate(ClusterInfo clusterInfo, Bucket client, CouchbaseConverter converter, TranslationService translationService) {
        this.syncClient = client;
        this.clusterInfo = clusterInfo;
        this.client = client.async();
        this.converter = converter == null ? this.getDefaultConverter() : converter;
        this.translationService = translationService == null ? this.getDefaultTranslationService() : translationService;
        this.mappingContext = this.converter.getMappingContext();
    }

    private RawJsonDocument encodeAndWrap(CouchbaseDocument source, Long version) {
        String encodedContent = this.translationService.encode(source);
        if (version == null) {
            return RawJsonDocument.create((String)source.getId(), (int)source.getExpiration(), (String)encodedContent);
        }
        return RawJsonDocument.create((String)source.getId(), (int)source.getExpiration(), (String)encodedContent, (long)version);
    }

    private TranslationService getDefaultTranslationService() {
        JacksonTranslationService t = new JacksonTranslationService();
        t.afterPropertiesSet();
        return t;
    }

    private CouchbaseConverter getDefaultConverter() {
        MappingCouchbaseConverter c = new MappingCouchbaseConverter((MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty>)new CouchbaseMappingContext());
        c.afterPropertiesSet();
        return c;
    }

    private final ConvertingPropertyAccessor getPropertyAccessor(Object source) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    private <T> Observable<T> doPersist(T objectToPersist, PersistType persistType, PersistTo persistTo, ReplicateTo replicateTo) {
        Func3 persistFunction;
        Long version = this.getVersion(objectToPersist);
        switch (persistType) {
            case SAVE: {
                if (version == null) {
                    persistFunction = (arg_0, arg_1, arg_2) -> ((AsyncBucket)this.client).upsert(arg_0, arg_1, arg_2);
                    break;
                }
                if (version > 0L) {
                    persistFunction = (arg_0, arg_1, arg_2) -> ((AsyncBucket)this.client).replace(arg_0, arg_1, arg_2);
                    break;
                }
                persistFunction = (arg_0, arg_1, arg_2) -> ((AsyncBucket)this.client).insert(arg_0, arg_1, arg_2);
                break;
            }
            case UPDATE: {
                persistFunction = (arg_0, arg_1, arg_2) -> ((AsyncBucket)this.client).replace(arg_0, arg_1, arg_2);
                break;
            }
            default: {
                persistFunction = (arg_0, arg_1, arg_2) -> ((AsyncBucket)this.client).insert(arg_0, arg_1, arg_2);
            }
        }
        return ((Observable)persistFunction.call((Object)this.toJsonDocument(objectToPersist), (Object)persistTo, (Object)replicateTo)).flatMap(storedDoc -> {
            if (storedDoc != null && storedDoc.cas() != 0L) {
                this.setVersion(objectToPersist, storedDoc.cas());
            }
            return Observable.just((Object)objectToPersist);
        }).onErrorResumeNext(e -> {
            if (e instanceof DocumentAlreadyExistsException) {
                throw new OptimisticLockingFailureException(persistType.springDataOperationName + " document with version value failed: " + version, e);
            }
            if (e instanceof CASMismatchException) {
                throw new OptimisticLockingFailureException(persistType.springDataOperationName + " document with version value failed: " + version, e);
            }
            return TemplateUtils.translateError(e);
        });
    }

    private <T> RawJsonDocument toJsonDocument(T object) {
        CouchbaseTemplate.ensureNotIterable(object);
        CouchbaseDocument converted = new CouchbaseDocument();
        this.converter.write(object, converted);
        return this.encodeAndWrap(converted, this.getVersion(object));
    }

    private <T> CouchbasePersistentProperty versionProperty(T object) {
        return (CouchbasePersistentProperty)((CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(object.getClass())).getVersionProperty();
    }

    private <T> Long getVersion(T object) {
        ConvertingPropertyAccessor accessor = this.getPropertyAccessor(object);
        CouchbasePersistentProperty versionProperty = this.versionProperty(object);
        if (versionProperty != null) {
            return (Long)accessor.getProperty((PersistentProperty)versionProperty, Long.class);
        }
        return null;
    }

    private <T> void setVersion(T object, long cas) {
        ConvertingPropertyAccessor accessor = this.getPropertyAccessor(object);
        CouchbasePersistentProperty versionProperty = this.versionProperty(object);
        if (versionProperty != null) {
            accessor.setProperty((PersistentProperty)versionProperty, (Object)cas);
        }
    }

    private <T> Observable<T> doRemove(T objectToRemove, PersistTo persistTo, ReplicateTo replicateTo) {
        if (objectToRemove instanceof String) {
            return this.client.remove((String)objectToRemove, persistTo, replicateTo).flatMap(rawJsonDocument -> Observable.just((Object)objectToRemove)).doOnError(e -> TemplateUtils.translateError(e));
        }
        RawJsonDocument doc = this.toJsonDocument(objectToRemove);
        return this.client.remove((Document)doc, persistTo, replicateTo).flatMap(rawJsonDocument -> Observable.just((Object)objectToRemove)).doOnError(e -> TemplateUtils.translateError(e));
    }

    @Override
    public Observable<Boolean> exists(String id) {
        return this.client.exists(id).doOnError(e -> TemplateUtils.translateError(e));
    }

    @Override
    public Observable<AsyncN1qlQueryResult> queryN1QL(N1qlQuery query) {
        return this.client.query(query).doOnError(e -> TemplateUtils.translateError(e));
    }

    @Override
    public Observable<AsyncViewResult> queryView(ViewQuery query) {
        return this.client.query(query).doOnError(e -> TemplateUtils.translateError(e));
    }

    @Override
    public Observable<AsyncSpatialViewResult> querySpatialView(SpatialViewQuery query) {
        return this.client.query(query).doOnError(e -> TemplateUtils.translateError(e));
    }

    @Override
    public <T> Observable<T> findById(String id, Class<T> entityClass) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        if (entity.isTouchOnRead()) {
            return this.client.getAndTouch(id, entity.getExpiry(), RawJsonDocument.class).switchIfEmpty(Observable.just(null)).map(doc -> this.mapToEntity(id, (Document<String>)doc, entityClass)).doOnError(e -> TemplateUtils.translateError(e));
        }
        return this.client.get(id, RawJsonDocument.class).switchIfEmpty(Observable.just(null)).map(doc -> this.mapToEntity(id, (Document<String>)doc, entityClass)).doOnError(e -> TemplateUtils.translateError(e));
    }

    @Override
    public <T> Observable<T> findByView(ViewQuery query, Class<T> entityClass) {
        if (!query.isIncludeDocs() || !query.includeDocsTarget().equals(RawJsonDocument.class)) {
            if (query.isOrderRetained()) {
                query.includeDocsOrdered(RawJsonDocument.class);
            } else {
                query.includeDocs(RawJsonDocument.class);
            }
        }
        query.reduce(false);
        return this.queryView(query).flatMap(asyncViewResult -> asyncViewResult.error().flatMap(error -> Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute view query due to error:" + error.toString())))).switchIfEmpty(asyncViewResult.rows())).map(row -> {
            AsyncViewRow asyncViewRow = (AsyncViewRow)row;
            return asyncViewRow.document(RawJsonDocument.class).map(doc -> this.mapToEntity(doc.id(), (Document<String>)doc, entityClass)).toBlocking().single();
        }).doOnError(throwable -> Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute view query", (Throwable)throwable))));
    }

    @Override
    public <T> Observable<T> findByN1QL(N1qlQuery query, Class<T> entityClass) {
        return this.queryN1QL(query).flatMap(asyncN1qlQueryResult -> asyncN1qlQueryResult.errors().flatMap(error -> Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute n1ql query due to error:" + error.toString())))).switchIfEmpty(asyncN1qlQueryResult.rows())).map(row -> {
            JsonObject json = ((AsyncN1qlQueryRow)row).value();
            String id = json.getString("_ID");
            Long cas = json.getLong("_CAS");
            if (id == null || cas == null) {
                throw new CouchbaseQueryExecutionException("Unable to retrieve enough metadata for N1QL to entity mapping, have you selected _ID and _CAS?");
            }
            json = json.removeKey("_ID").removeKey("_CAS");
            RawJsonDocument entityDoc = RawJsonDocument.create((String)id, (String)json.toString(), (long)cas);
            Object decoded = this.mapToEntity(id, (Document<String>)entityDoc, entityClass);
            return decoded;
        }).doOnError(throwable -> Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute n1ql query", (Throwable)throwable))));
    }

    @Override
    public <T> Observable<T> findBySpatialView(SpatialViewQuery query, Class<T> entityClass) {
        return this.querySpatialView(query).flatMap(spatialViewResult -> spatialViewResult.error().flatMap(error -> Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute spatial view query due to error:" + error.toString())))).switchIfEmpty(spatialViewResult.rows())).map(row -> {
            AsyncSpatialViewRow asyncSpatialViewRow = (AsyncSpatialViewRow)row;
            return asyncSpatialViewRow.document(RawJsonDocument.class).map(doc -> this.mapToEntity(doc.id(), (Document<String>)doc, entityClass)).toBlocking().single();
        }).doOnError(throwable -> Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute spatial view query", (Throwable)throwable))));
    }

    @Override
    public <T> Observable<T> findByN1QLProjection(N1qlQuery query, Class<T> entityClass) {
        return this.queryN1QL(query).flatMap(asyncN1qlQueryResult -> asyncN1qlQueryResult.errors().flatMap(error -> Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute n1ql query due to error:" + error.toString())))).switchIfEmpty(asyncN1qlQueryResult.rows())).map(row -> {
            JsonObject json = ((AsyncN1qlQueryRow)row).value();
            Object decoded = this.translationService.decodeFragment(json.toString(), entityClass);
            return decoded;
        }).doOnError(throwable -> Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute n1ql query", (Throwable)throwable))));
    }

    @Override
    public Consistency getDefaultConsistency() {
        return this.configuredConsistency;
    }

    public void setDefaultConsistency(Consistency consistency) {
        this.configuredConsistency = consistency;
    }

    @Override
    public CouchbaseConverter getConverter() {
        return this.converter;
    }

    private <T> T mapToEntity(String id, Document<String> data, Class<T> entityClass) {
        if (data == null) {
            return null;
        }
        CouchbaseDocument converted = new CouchbaseDocument(id);
        Object readEntity = this.converter.read(entityClass, (CouchbaseDocument)this.decodeAndUnwrap(data, converted));
        ConvertingPropertyAccessor accessor = this.getPropertyAccessor(readEntity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(readEntity.getClass());
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        if (versionProperty != null) {
            accessor.setProperty((PersistentProperty)versionProperty, (Object)data.cas());
        }
        return (T)readEntity;
    }

    private CouchbaseStorable decodeAndUnwrap(Document<String> source, CouchbaseStorable target) {
        return this.translationService.decode((String)source.content(), target);
    }

    @Override
    public Bucket getCouchbaseBucket() {
        return this.syncClient;
    }

    @Override
    public ClusterInfo getCouchbaseClusterInfo() {
        return this.clusterInfo;
    }

    private static enum PersistType {
        SAVE("Save", "Upsert"),
        INSERT("Insert", "Insert"),
        UPDATE("Update", "Replace");

        private final String sdkOperationName;
        private final String springDataOperationName;

        private PersistType(String sdkOperationName, String springDataOperationName) {
            this.sdkOperationName = sdkOperationName;
            this.springDataOperationName = springDataOperationName;
        }
    }
}

