/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.CouchbaseQueryExecutionException;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseParameterAccessor;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import reactor.core.publisher.Flux;

public abstract class ReactiveAbstractN1qlBasedQuery
implements RepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveAbstractN1qlBasedQuery.class);
    protected final CouchbaseQueryMethod queryMethod;
    private final RxJavaCouchbaseOperations couchbaseOperations;

    protected ReactiveAbstractN1qlBasedQuery(CouchbaseQueryMethod method, RxJavaCouchbaseOperations operations) {
        this.queryMethod = method;
        this.couchbaseOperations = operations;
    }

    protected abstract Statement getStatement(ParameterAccessor var1, Object[] var2, ReturnedType var3);

    protected abstract JsonValue getPlaceholderValues(ParameterAccessor var1);

    public Object execute(Object[] parameters) {
        ReactiveCouchbaseParameterAccessor accessor = new ReactiveCouchbaseParameterAccessor(this.queryMethod, parameters);
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        ReturnedType returnedType = processor.getReturnedType();
        Class typeToRead = returnedType.getTypeToRead();
        typeToRead = typeToRead == null ? returnedType.getDomainType() : typeToRead;
        Statement statement = this.getStatement((ParameterAccessor)accessor, parameters, returnedType);
        JsonValue queryPlaceholderValues = this.getPlaceholderValues((ParameterAccessor)accessor);
        N1qlQuery query = N1qlUtils.buildQuery(statement, queryPlaceholderValues, this.getScanConsistency());
        return ReactiveWrapperConverters.toWrapper((Object)processor.processResult(this.executeDependingOnType(query, this.queryMethod, typeToRead)), Flux.class);
    }

    protected Object executeDependingOnType(N1qlQuery query, QueryMethod queryMethod, Class<?> typeToRead) {
        if (queryMethod.isModifyingQuery()) {
            throw new UnsupportedOperationException("Modifying queries not yet supported");
        }
        if (queryMethod.isQueryForEntity()) {
            return this.execute(query, typeToRead);
        }
        return this.executeSingleProjection(query, typeToRead);
    }

    private void logIfNecessary(N1qlQuery query) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing N1QL query: " + query.n1ql());
        }
    }

    protected Object execute(N1qlQuery query, Class<?> typeToRead) {
        this.logIfNecessary(query);
        return this.couchbaseOperations.findByN1QL(query, typeToRead);
    }

    protected Object executeSingleProjection(N1qlQuery query, Class<?> typeToRead) {
        this.logIfNecessary(query);
        return this.couchbaseOperations.findByN1QLProjection(query, Map.class).map(m -> {
            if (m.size() > 1) {
                throw new CouchbaseQueryExecutionException("Query returning primitive got more values than expected: " + m.size());
            }
            Object v = m.values().iterator().next();
            return this.couchbaseOperations.getConverter().getConversionService().convert(v, typeToRead);
        });
    }

    public CouchbaseQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected RxJavaCouchbaseOperations getCouchbaseOperations() {
        return this.couchbaseOperations;
    }

    protected ScanConsistency getScanConsistency() {
        if (this.queryMethod.hasConsistencyAnnotation()) {
            return this.queryMethod.getConsistencyAnnotation().value();
        }
        return this.getCouchbaseOperations().getDefaultConsistency().n1qlConsistency();
    }
}

