/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.kv.GetOptions;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableFindByIdOperation;
import org.springframework.data.couchbase.core.NonReactiveSupportWrapper;
import org.springframework.data.couchbase.core.ReactiveFindByIdOperationSupport;
import org.springframework.util.Assert;

public class ExecutableFindByIdOperationSupport
implements ExecutableFindByIdOperation {
    private final CouchbaseTemplate template;

    ExecutableFindByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableFindByIdOperation.ExecutableFindById<T> findById(Class<T> domainType) {
        return new ExecutableFindByIdSupport<T>(this.template, domainType, null, null, null, null, null);
    }

    static class ExecutableFindByIdSupport<T>
    implements ExecutableFindByIdOperation.ExecutableFindById<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final GetOptions options;
        private final List<String> fields;
        private final Duration expiry;
        private final ReactiveFindByIdOperationSupport.ReactiveFindByIdSupport<T> reactiveSupport;

        ExecutableFindByIdSupport(CouchbaseTemplate template, Class<T> domainType, String scope, String collection, GetOptions options, List<String> fields, Duration expiry) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.fields = fields;
            this.expiry = expiry;
            this.reactiveSupport = new ReactiveFindByIdOperationSupport.ReactiveFindByIdSupport<T>(template.reactive(), domainType, scope, collection, (CommonOptions<?>)options, fields, expiry, new NonReactiveSupportWrapper(template.support()));
        }

        @Override
        public T one(String id) {
            return (T)this.reactiveSupport.one(id).block();
        }

        @Override
        public Collection<? extends T> all(Collection<String> ids) {
            return (Collection)this.reactiveSupport.all(ids).collectList().block();
        }

        @Override
        public ExecutableFindByIdOperation.TerminatingFindById<T> withOptions(GetOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ExecutableFindByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.fields, this.expiry);
        }

        @Override
        public ExecutableFindByIdOperation.FindByIdWithOptions<T> inCollection(String collection) {
            return new ExecutableFindByIdSupport<T>(this.template, this.domainType, this.scope, collection, this.options, this.fields, this.expiry);
        }

        @Override
        public ExecutableFindByIdOperation.FindByIdInCollection<T> inScope(String scope) {
            return new ExecutableFindByIdSupport<T>(this.template, this.domainType, scope, this.collection, this.options, this.fields, this.expiry);
        }

        @Override
        public ExecutableFindByIdOperation.FindByIdInScope<T> project(String ... fields) {
            Assert.notEmpty((Object[])fields, (String)"Fields must not be null.");
            return new ExecutableFindByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, Arrays.asList(fields), this.expiry);
        }

        @Override
        public ExecutableFindByIdOperation.FindByIdWithProjection<T> withExpiry(Duration expiry) {
            return new ExecutableFindByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.fields, expiry);
        }
    }
}

