/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public final class OtherConverters {
    private OtherConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(UuidToString.INSTANCE);
        converters.add(StringToUuid.INSTANCE);
        converters.add(BigIntegerToString.INSTANCE);
        converters.add(StringToBigInteger.INSTANCE);
        converters.add(BigDecimalToString.INSTANCE);
        converters.add(StringToBigDecimal.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum StringToBigDecimal implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(String source) {
            return source == null ? null : new BigDecimal(source);
        }
    }

    @WritingConverter
    public static enum BigDecimalToString implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToBigInteger implements Converter<String, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(String source) {
            return source == null ? null : new BigInteger(source);
        }
    }

    @WritingConverter
    public static enum BigIntegerToString implements Converter<BigInteger, String>
    {
        INSTANCE;


        public String convert(BigInteger source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToUuid implements Converter<String, UUID>
    {
        INSTANCE;


        public UUID convert(String source) {
            return source == null ? null : UUID.fromString(source);
        }
    }

    @WritingConverter
    public static enum UuidToString implements Converter<UUID, String>
    {
        INSTANCE;


        public String convert(UUID source) {
            return source == null ? null : source.toString();
        }
    }
}

