/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.ReactiveCouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.CouchbaseRepositoryBase;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveCouchbaseRepository<T, ID>
extends CouchbaseRepositoryBase<T, ID>
implements ReactiveCouchbaseRepository<T, ID> {
    private final ReactiveCouchbaseOperations operations;

    public SimpleReactiveCouchbaseRepository(CouchbaseEntityInformation<T, String> entityInformation, ReactiveCouchbaseOperations operations, Class<?> repositoryInterface) {
        super(entityInformation, repositoryInterface);
        this.operations = operations;
    }

    public Flux<T> findAll(Sort sort) {
        return this.findAll(new Query().with(sort));
    }

    public <S extends T> Mono<S> save(S entity) {
        String scopeName = this.getScope();
        String collectionName = this.getCollection();
        this.getReactiveTemplate().setPseudoArgs(null);
        return this.operations.save(entity, scopeName, collectionName);
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        String scope = this.getScope();
        String collection = this.getCollection();
        return Flux.fromIterable(entities).flatMap(e -> this.save(e, scope, collection));
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Iterable of entities must not be null!");
        String scope = this.getScope();
        String collection = this.getCollection();
        return Flux.from(entityStream).flatMap(e -> this.save(e, scope, collection));
    }

    private <S extends T> Mono<S> save(S entity, String scope, String collection) {
        return this.operations.save(entity, scope, collection);
    }

    public Mono<T> findById(ID id) {
        return this.findById(id, this.getScope(), this.getCollection());
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given Publisher must not be null!");
        String scope = this.getScope();
        String collection = this.getCollection();
        return Mono.from(publisher).flatMap(id -> this.findById(id, scope, collection));
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null!");
        List<String> convertedIds = Streamable.of(ids).stream().map(Objects::toString).collect(Collectors.toList());
        return this.operations.findById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).all(convertedIds);
    }

    public Flux<T> findAllById(Publisher<ID> entityStream) {
        Assert.notNull(entityStream, (String)"The given entityStream must not be null!");
        String scope = this.getScope();
        String collection = this.getCollection();
        return Flux.from(entityStream).flatMap(id -> this.findById(id, scope, collection));
    }

    private Mono<T> findById(ID id, String scope, String collection) {
        return this.operations.findById(this.getJavaType()).inScope(scope).inCollection(collection).one(id.toString());
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.existsById(id, this.getScope(), this.getCollection());
    }

    private Mono<Boolean> existsById(ID id, String scope, String collection) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.operations.existsById(this.getJavaType()).inScope(scope).inCollection(collection).one(id.toString());
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given Publisher must not be null!");
        String scope = this.getScope();
        String collection = this.getCollection();
        return Mono.from(publisher).flatMap(id -> this.existsById(id, scope, collection));
    }

    public Flux<T> findAll() {
        return this.findAll(new Query());
    }

    public Mono<Void> deleteById(ID id) {
        return this.deleteById(id, this.getScope(), this.getCollection());
    }

    private Mono<Void> deleteById(ID id, String scope, String collection) {
        return this.operations.removeById(this.getJavaType()).inScope(scope).inCollection(collection).one(id.toString()).then();
    }

    public Mono<Void> deleteById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        String scope = this.getScope();
        String collection = this.getCollection();
        return Mono.from(publisher).flatMap(e -> this.deleteById(e, scope, collection));
    }

    public Mono<Void> delete(T entity) {
        return this.delete(entity, this.getScope(), this.getCollection());
    }

    private Mono<Void> delete(T entity, String scope, String collection) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.operations.removeById(this.getJavaType()).inScope(scope).inCollection(collection).oneEntity(entity).then();
    }

    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        return this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).all(Streamable.of(ids).map(Object::toString).toList()).then();
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        return this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).allEntities(Streamable.of(entities).toList()).then();
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given publisher of entities must not be null!");
        String scope = this.getScope();
        String collection = this.getCollection();
        return Flux.from(entityStream).flatMap(e -> this.delete(e, scope, collection)).single();
    }

    public Mono<Void> deleteAll() {
        return this.operations.removeByQuery(this.getJavaType()).withConsistency(this.getQueryScanConsistency()).inScope(this.getScope()).inCollection(this.getCollection()).all().then();
    }

    public Mono<Long> count() {
        return this.operations.findByQuery(this.getJavaType()).withConsistency(this.getQueryScanConsistency()).inScope(this.getScope()).inCollection(this.getCollection()).count();
    }

    private Flux<T> findAll(Query query) {
        return this.operations.findByQuery(this.getJavaType()).withConsistency(this.getQueryScanConsistency()).inScope(this.getScope()).inCollection(this.getCollection()).matching(query).all();
    }

    @Override
    public ReactiveCouchbaseOperations getOperations() {
        return this.operations;
    }

    @Override
    protected ReactiveCouchbaseTemplate getReactiveTemplate() {
        return (ReactiveCouchbaseTemplate)this.getOperations();
    }
}

