/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.mlt.MoreLikeThisRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.CriteriaFilterProcessor;
import org.springframework.data.elasticsearch.core.CriteriaQueryProcessor;
import org.springframework.data.elasticsearch.core.DefaultResultMapper;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.FacetedPage;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.MappingBuilder;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.data.elasticsearch.core.SearchResultMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.facet.FacetRequest;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public class ElasticsearchTemplate
implements ElasticsearchOperations {
    private Client client;
    private ElasticsearchConverter elasticsearchConverter;
    private ResultsMapper resultsMapper;

    public ElasticsearchTemplate(Client client) {
        this(client, null, null);
    }

    public ElasticsearchTemplate(Client client, EntityMapper entityMapper) {
        this(client, null, new DefaultResultMapper(entityMapper));
    }

    public ElasticsearchTemplate(Client client, ResultsMapper resultsMapper) {
        this(client, null, resultsMapper);
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter) {
        this(client, elasticsearchConverter, null);
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter, ResultsMapper resultsMapper) {
        this.client = client;
        this.elasticsearchConverter = elasticsearchConverter == null ? new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()) : elasticsearchConverter;
        this.resultsMapper = resultsMapper == null ? new DefaultResultMapper(this.elasticsearchConverter.getMappingContext()) : resultsMapper;
    }

    @Override
    public <T> boolean createIndex(Class<T> clazz) {
        return this.createIndexIfNotCreated(clazz);
    }

    @Override
    public <T> boolean putMapping(Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        PutMappingRequestBuilder requestBuilder = this.client.admin().indices().preparePutMapping(new String[]{persistentEntity.getIndexName()}).setType(persistentEntity.getIndexType());
        try {
            XContentBuilder xContentBuilder = MappingBuilder.buildMapping(clazz, persistentEntity.getIndexType(), ((ElasticsearchPersistentProperty)persistentEntity.getIdProperty()).getFieldName(), persistentEntity.getParentType());
            return ((PutMappingResponse)requestBuilder.setSource(xContentBuilder).execute().actionGet()).isAcknowledged();
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), e);
        }
    }

    @Override
    public ElasticsearchConverter getElasticsearchConverter() {
        return this.elasticsearchConverter;
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz) {
        return this.queryForObject(query, clazz, this.resultsMapper);
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz, GetResultMapper mapper) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        GetResponse response = (GetResponse)this.client.prepareGet(persistentEntity.getIndexName(), persistentEntity.getIndexType(), query.getId()).execute().actionGet();
        T entity = mapper.mapResult(response, clazz);
        return entity;
    }

    @Override
    public <T> T queryForObject(CriteriaQuery query, Class<T> clazz) {
        Page<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    @Override
    public <T> T queryForObject(StringQuery query, Class<T> clazz) {
        FacetedPage<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    @Override
    public <T> FacetedPage<T> queryForPage(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz, (SearchResultMapper)this.resultsMapper);
    }

    @Override
    public <T> FacetedPage<T> queryForPage(SearchQuery query, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.doSearch(this.prepareSearch(query, clazz), query);
        return mapper.mapResults(response, clazz, query.getPageable());
    }

    @Override
    public <T> List<T> queryForList(CriteriaQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    @Override
    public <T> List<T> queryForList(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    @Override
    public <T> List<T> queryForList(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    @Override
    public <T> List<String> queryForIds(SearchQuery query) {
        SearchRequestBuilder request = this.prepareSearch(query).setQuery(query.getQuery()).setNoFields();
        if (query.getFilter() != null) {
            request.setFilter(query.getFilter());
        }
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        return this.extractIds(response);
    }

    @Override
    public <T> Page<T> queryForPage(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        FilterBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        SearchRequestBuilder searchRequestBuilder = this.prepareSearch(criteriaQuery, clazz);
        if (elasticsearchQuery != null) {
            searchRequestBuilder.setQuery(elasticsearchQuery);
        } else {
            searchRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (criteriaQuery.getMinScore() > 0.0f) {
            searchRequestBuilder.setMinScore(criteriaQuery.getMinScore());
        }
        if (elasticsearchFilter != null) {
            searchRequestBuilder.setFilter(elasticsearchFilter);
        }
        SearchResponse response = (SearchResponse)searchRequestBuilder.execute().actionGet();
        return this.resultsMapper.mapResults(response, clazz, criteriaQuery.getPageable());
    }

    @Override
    public <T> FacetedPage<T> queryForPage(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz, (SearchResultMapper)this.resultsMapper);
    }

    @Override
    public <T> FacetedPage<T> queryForPage(StringQuery query, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = (SearchResponse)this.prepareSearch(query, clazz).setQuery(query.getSource()).execute().actionGet();
        return mapper.mapResults(response, clazz, query.getPageable());
    }

    @Override
    public <T> long count(SearchQuery query, Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        CountRequestBuilder countRequestBuilder = this.client.prepareCount(new String[]{persistentEntity.getIndexName()}).setTypes(new String[]{persistentEntity.getIndexType()});
        if (query.getQuery() != null) {
            countRequestBuilder.setQuery(query.getQuery());
        }
        return ((CountResponse)countRequestBuilder.execute().actionGet()).getCount();
    }

    @Override
    public String index(IndexQuery query) {
        String documentId = ((IndexResponse)this.prepareIndex(query).execute().actionGet()).getId();
        if (query.getObject() != null) {
            this.setPersistentEntityId(query.getObject(), documentId);
        }
        return documentId;
    }

    @Override
    public UpdateResponse update(UpdateQuery query) {
        String indexName = StringUtils.isNotBlank((String)query.getIndexName()) ? query.getIndexName() : this.getPersistentEntityFor(query.getClazz()).getIndexName();
        String type = StringUtils.isNotBlank((String)query.getType()) ? query.getType() : this.getPersistentEntityFor(query.getClazz()).getIndexType();
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Assert.notNull((Object)type, (String)"No type define for Query");
        Assert.notNull((Object)query.getId(), (String)"No Id define for Query");
        Assert.notNull((Object)query.getIndexRequest(), (String)"No IndexRequest define for Query");
        UpdateRequestBuilder updateRequestBuilder = this.client.prepareUpdate(indexName, type, query.getId());
        if (query.DoUpsert()) {
            updateRequestBuilder.setDocAsUpsert(true).setUpsert(query.getIndexRequest()).setDoc(query.getIndexRequest());
        } else {
            updateRequestBuilder.setDoc(query.getIndexRequest());
        }
        return (UpdateResponse)updateRequestBuilder.execute().actionGet();
    }

    @Override
    public void bulkIndex(List<IndexQuery> queries) {
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (IndexQuery query : queries) {
            bulkRequest.add(this.prepareIndex(query));
        }
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
        if (bulkResponse.hasFailures()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), item.getFailureMessage());
            }
            throw new ElasticsearchException("Bulk indexing has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + "]", failedDocuments);
        }
    }

    @Override
    public <T> boolean indexExists(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public boolean typeExists(String index, String type) {
        return ((ClusterStateResponse)this.client.admin().cluster().prepareState().execute().actionGet()).getState().metaData().index(index).mappings().containsKey((Object)type);
    }

    @Override
    public <T> boolean deleteIndex(Class<T> clazz) {
        String indexName = this.getPersistentEntityFor(clazz).getIndexName();
        if (this.indexExists(indexName)) {
            return ((DeleteIndexResponse)this.client.admin().indices().delete(new DeleteIndexRequest(indexName)).actionGet()).isAcknowledged();
        }
        return false;
    }

    @Override
    public void deleteType(String index, String type) {
        ImmutableOpenMap mappings = ((ClusterStateResponse)this.client.admin().cluster().prepareState().execute().actionGet()).getState().metaData().index(index).mappings();
        if (mappings.containsKey((Object)type)) {
            this.client.admin().indices().deleteMapping(new DeleteMappingRequest(new String[]{index}).type(type)).actionGet();
        }
    }

    @Override
    public String delete(String indexName, String type, String id) {
        return ((DeleteResponse)this.client.prepareDelete(indexName, type, id).execute().actionGet()).getId();
    }

    @Override
    public <T> String delete(Class<T> clazz, String id) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        return this.delete(persistentEntity.getIndexName(), persistentEntity.getIndexType(), id);
    }

    @Override
    public <T> void delete(DeleteQuery deleteQuery, Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        this.client.prepareDeleteByQuery(new String[]{persistentEntity.getIndexName()}).setTypes(new String[]{persistentEntity.getIndexType()}).setQuery(deleteQuery.getQuery()).execute().actionGet();
    }

    @Override
    public void delete(DeleteQuery deleteQuery) {
        Assert.notNull((Object)deleteQuery.getIndex(), (String)"No index defined for Query");
        Assert.notNull((Object)deleteQuery.getType(), (String)"No type define for Query");
        this.client.prepareDeleteByQuery(new String[]{deleteQuery.getIndex()}).setTypes(new String[]{deleteQuery.getType()}).setQuery(deleteQuery.getQuery()).execute().actionGet();
    }

    @Override
    public String scan(SearchQuery searchQuery, long scrollTimeInMillis, boolean noFields) {
        Assert.notNull(searchQuery.getIndices(), (String)"No index defined for Query");
        Assert.notNull(searchQuery.getTypes(), (String)"No type define for Query");
        Assert.notNull((Object)searchQuery.getPageable(), (String)"Query.pageable is required for scan & scroll");
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(ElasticsearchTemplate.toArray(searchQuery.getIndices())).setSearchType(SearchType.SCAN).setQuery(searchQuery.getQuery()).setTypes(ElasticsearchTemplate.toArray(searchQuery.getTypes())).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).setFrom(0).setSize(searchQuery.getPageable().getPageSize());
        if (searchQuery.getFilter() != null) {
            requestBuilder.setFilter(searchQuery.getFilter());
        }
        if (noFields) {
            requestBuilder.setNoFields();
        }
        return ((SearchResponse)requestBuilder.execute().actionGet()).getScrollId();
    }

    @Override
    public <T> Page<T> scroll(String scrollId, long scrollTimeInMillis, Class<T> clazz) {
        SearchResponse response = (SearchResponse)this.client.prepareSearchScroll(scrollId).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute().actionGet();
        return this.resultsMapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> Page<T> scroll(String scrollId, long scrollTimeInMillis, SearchResultMapper mapper) {
        SearchResponse response = (SearchResponse)this.client.prepareSearchScroll(scrollId).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute().actionGet();
        return mapper.mapResults(response, null, null);
    }

    @Override
    public <T> Page<T> moreLikeThis(MoreLikeThisQuery query, Class<T> clazz) {
        int startRecord = 0;
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        String indexName = StringUtils.isNotBlank((String)query.getIndexName()) ? query.getIndexName() : persistentEntity.getIndexName();
        String type = StringUtils.isNotBlank((String)query.getType()) ? query.getType() : persistentEntity.getIndexType();
        Assert.notNull((Object)indexName, (String)"No 'indexName' defined for MoreLikeThisQuery");
        Assert.notNull((Object)type, (String)"No 'type' defined for MoreLikeThisQuery");
        Assert.notNull((Object)query.getId(), (String)"No document id defined for MoreLikeThisQuery");
        MoreLikeThisRequestBuilder requestBuilder = this.client.prepareMoreLikeThis(indexName, type, query.getId());
        if (query.getPageable() != null) {
            startRecord = query.getPageable().getPageNumber() * query.getPageable().getPageSize();
            requestBuilder.setSearchSize(query.getPageable().getPageSize());
        }
        requestBuilder.setSearchFrom(startRecord);
        if (CollectionUtils.isNotEmpty(query.getSearchIndices())) {
            requestBuilder.setSearchIndices(ElasticsearchTemplate.toArray(query.getSearchIndices()));
        }
        if (CollectionUtils.isNotEmpty(query.getSearchTypes())) {
            requestBuilder.setSearchTypes(ElasticsearchTemplate.toArray(query.getSearchTypes()));
        }
        if (CollectionUtils.isNotEmpty(query.getFields())) {
            requestBuilder.setField(ElasticsearchTemplate.toArray(query.getFields()));
        }
        if (StringUtils.isNotBlank((String)query.getRouting())) {
            requestBuilder.setRouting(query.getRouting());
        }
        if (query.getPercentTermsToMatch() != null) {
            requestBuilder.setPercentTermsToMatch(query.getPercentTermsToMatch().floatValue());
        }
        if (query.getMinTermFreq() != null) {
            requestBuilder.setMinTermFreq(query.getMinTermFreq().intValue());
        }
        if (query.getMaxQueryTerms() != null) {
            requestBuilder.maxQueryTerms(query.getMaxQueryTerms().intValue());
        }
        if (CollectionUtils.isNotEmpty(query.getStopWords())) {
            requestBuilder.setStopWords(ElasticsearchTemplate.toArray(query.getStopWords()));
        }
        if (query.getMinDocFreq() != null) {
            requestBuilder.setMinDocFreq(query.getMinDocFreq().intValue());
        }
        if (query.getMaxDocFreq() != null) {
            requestBuilder.setMaxDocFreq(query.getMaxDocFreq().intValue());
        }
        if (query.getMinWordLen() != null) {
            requestBuilder.setMinWordLen(query.getMinWordLen().intValue());
        }
        if (query.getMaxWordLen() != null) {
            requestBuilder.setMaxWordLen(query.getMaxWordLen().intValue());
        }
        if (query.getBoostTerms() != null) {
            requestBuilder.setBoostTerms(query.getBoostTerms().floatValue());
        }
        SearchResponse response = (SearchResponse)requestBuilder.execute().actionGet();
        return this.resultsMapper.mapResults(response, clazz, query.getPageable());
    }

    private SearchResponse doSearch(SearchRequestBuilder searchRequest, SearchQuery searchQuery) {
        if (searchQuery.getFilter() != null) {
            searchRequest.setFilter(searchQuery.getFilter());
        }
        if (searchQuery.getElasticsearchSort() != null) {
            searchRequest.addSort(searchQuery.getElasticsearchSort());
        }
        if (CollectionUtils.isNotEmpty(searchQuery.getFacets())) {
            for (FacetRequest facetRequest : searchQuery.getFacets()) {
                FacetBuilder facet = facetRequest.getFacet();
                if (facetRequest.applyQueryFilter() && searchQuery.getFilter() != null) {
                    facet.facetFilter(searchQuery.getFilter());
                }
                searchRequest.addFacet(facet);
            }
        }
        if (searchQuery.getHighlightFields() != null) {
            for (HighlightBuilder.Field highlightField : searchQuery.getHighlightFields()) {
                searchRequest.addHighlightedField(highlightField);
            }
        }
        return (SearchResponse)searchRequest.setQuery(searchQuery.getQuery()).execute().actionGet();
    }

    private <T> boolean createIndexIfNotCreated(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName()) || this.createIndexWithSettings(clazz);
    }

    private boolean indexExists(String indexName) {
        return ((IndicesExistsResponse)this.client.admin().indices().exists(Requests.indicesExistsRequest((String[])new String[]{indexName})).actionGet()).isExists();
    }

    private <T> boolean createIndexWithSettings(Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        return ((CreateIndexResponse)this.client.admin().indices().create(Requests.createIndexRequest((String)persistentEntity.getIndexName()).settings(this.getSettings(persistentEntity))).actionGet()).isAcknowledged();
    }

    private <T> Map getSettings(ElasticsearchPersistentEntity<T> persistentEntity) {
        return new MapBuilder().put((Object)"index.number_of_shards", (Object)String.valueOf(persistentEntity.getShards())).put((Object)"index.number_of_replicas", (Object)String.valueOf(persistentEntity.getReplicas())).put((Object)"index.refresh_interval", (Object)persistentEntity.getRefreshInterval()).put((Object)"index.store.type", (Object)persistentEntity.getIndexStoreType()).map();
    }

    private <T> SearchRequestBuilder prepareSearch(Query query, Class<T> clazz) {
        if (query.getIndices().isEmpty()) {
            query.addIndices(this.retrieveIndexNameFromPersistentEntity(clazz));
        }
        if (query.getTypes().isEmpty()) {
            query.addTypes(this.retrieveTypeFromPersistentEntity(clazz));
        }
        return this.prepareSearch(query);
    }

    private SearchRequestBuilder prepareSearch(Query query) {
        Assert.notNull(query.getIndices(), (String)"No index defined for Query");
        Assert.notNull(query.getTypes(), (String)"No type defined for Query");
        int startRecord = 0;
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(ElasticsearchTemplate.toArray(query.getIndices())).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTypes(ElasticsearchTemplate.toArray(query.getTypes()));
        if (query.getPageable() != null) {
            startRecord = query.getPageable().getPageNumber() * query.getPageable().getPageSize();
            searchRequestBuilder.setSize(query.getPageable().getPageSize());
        }
        searchRequestBuilder.setFrom(startRecord);
        if (!query.getFields().isEmpty()) {
            searchRequestBuilder.addFields(ElasticsearchTemplate.toArray(query.getFields()));
        }
        if (query.getSort() != null) {
            for (Sort.Order order : query.getSort()) {
                searchRequestBuilder.addSort(order.getProperty(), order.getDirection() == Sort.Direction.DESC ? SortOrder.DESC : SortOrder.ASC);
            }
        }
        if (query.getMinScore() > 0.0f) {
            searchRequestBuilder.setMinScore(query.getMinScore());
        }
        return searchRequestBuilder;
    }

    private IndexRequestBuilder prepareIndex(IndexQuery query) {
        try {
            String indexName = StringUtils.isBlank((String)query.getIndexName()) ? this.retrieveIndexNameFromPersistentEntity(query.getObject().getClass())[0] : query.getIndexName();
            String type = StringUtils.isBlank((String)query.getType()) ? this.retrieveTypeFromPersistentEntity(query.getObject().getClass())[0] : query.getType();
            IndexRequestBuilder indexRequestBuilder = null;
            if (query.getObject() != null) {
                String entityId = this.getPersistentEntityId(query.getObject());
                indexRequestBuilder = query.getId() != null && entityId != null ? this.client.prepareIndex(indexName, type, query.getId()) : this.client.prepareIndex(indexName, type);
                indexRequestBuilder.setSource(this.resultsMapper.getEntityMapper().mapToString(query.getObject()));
            } else if (query.getSource() != null) {
                indexRequestBuilder = this.client.prepareIndex(indexName, type, query.getId()).setSource(query.getSource());
            } else {
                throw new ElasticsearchException("object or source is null, failed to index the document [id: " + query.getId() + "]");
            }
            if (query.getVersion() != null) {
                indexRequestBuilder.setVersion(query.getVersion().longValue());
                indexRequestBuilder.setVersionType(VersionType.EXTERNAL);
            }
            if (query.getParentId() != null) {
                indexRequestBuilder.setParent(query.getParentId());
            }
            return indexRequestBuilder;
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to index the document [id: " + query.getId() + "]", e);
        }
    }

    @Override
    public void refresh(String indexName, boolean waitForOperation) {
        this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{indexName}).force(waitForOperation)).actionGet();
    }

    @Override
    public <T> void refresh(Class<T> clazz, boolean waitForOperation) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{persistentEntity.getIndexName()}).force(waitForOperation)).actionGet();
    }

    @Override
    public Boolean addAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        IndicesAliasesRequestBuilder indicesAliasesRequestBuilder = null;
        indicesAliasesRequestBuilder = query.getFilterBuilder() != null ? this.client.admin().indices().prepareAliases().addAlias(query.getIndexName(), query.getAliasName(), query.getFilterBuilder()) : (query.getFilter() != null ? this.client.admin().indices().prepareAliases().addAlias(query.getIndexName(), query.getAliasName(), query.getFilter()) : this.client.admin().indices().prepareAliases().addAlias(query.getIndexName(), query.getAliasName()));
        return ((IndicesAliasesResponse)indicesAliasesRequestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    public Boolean removeAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        return ((IndicesAliasesResponse)this.client.admin().indices().prepareAliases().removeAlias(query.getIndexName(), query.getAliasName()).execute().actionGet()).isAcknowledged();
    }

    @Override
    public Set<String> queryForAlias(String indexName) {
        ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest().filterRoutingTable(true).filterNodes(true).filteredIndices(new String[]{indexName});
        UnmodifiableIterator iterator = ((ClusterStateResponse)this.client.admin().cluster().state(clusterStateRequest).actionGet()).getState().getMetaData().aliases().keysIt();
        return Sets.newHashSet((Iterator)iterator);
    }

    private ElasticsearchPersistentEntity getPersistentEntityFor(Class clazz) {
        Assert.isTrue((boolean)clazz.isAnnotationPresent(Document.class), (String)("Unable to identify index name. " + clazz.getSimpleName() + " is not a Document. Make sure the document class is annotated with @Document(indexName=\"foo\")"));
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(clazz);
    }

    private String getPersistentEntityId(Object entity) {
        Method getter;
        PersistentProperty idProperty = this.getPersistentEntityFor(entity.getClass()).getIdProperty();
        if (idProperty != null && (getter = idProperty.getGetter()) != null) {
            try {
                Object id = getter.invoke(entity, new Object[0]);
                if (id != null) {
                    return String.valueOf(id);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    private void setPersistentEntityId(Object entity, String id) {
        Method setter;
        PersistentProperty idProperty = this.getPersistentEntityFor(entity.getClass()).getIdProperty();
        if (idProperty != null && idProperty.getType().isAssignableFrom(String.class) && (setter = idProperty.getSetter()) != null) {
            try {
                setter.invoke(entity, id);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private String[] retrieveIndexNameFromPersistentEntity(Class clazz) {
        return new String[]{this.getPersistentEntityFor(clazz).getIndexName()};
    }

    private String[] retrieveTypeFromPersistentEntity(Class clazz) {
        return new String[]{this.getPersistentEntityFor(clazz).getIndexType()};
    }

    private List<String> extractIds(SearchResponse response) {
        ArrayList<String> ids = new ArrayList<String>();
        for (SearchHit hit : response.getHits()) {
            if (hit == null) continue;
            ids.add(hit.getId());
        }
        return ids;
    }

    private static String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }

    protected ResultsMapper getResultsMapper() {
        return this.resultsMapper;
    }
}

