/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.facet.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.FacetBuilders;
import org.elasticsearch.search.facet.range.RangeFacetBuilder;
import org.springframework.data.elasticsearch.core.facet.AbstractFacetRequest;
import org.springframework.util.Assert;

public class RangeFacetRequest
extends AbstractFacetRequest {
    private String field;
    private String keyField;
    private String valueField;
    private List<Double> from = new ArrayList<Double>();
    private List<Double> to = new ArrayList<Double>();

    public RangeFacetRequest(String name) {
        super(name);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFields(String keyField, String valueField) {
        this.keyField = keyField;
        this.valueField = valueField;
    }

    public void range(Double from, Double to) {
        if (from == null) {
            this.from.add(Double.NEGATIVE_INFINITY);
        } else {
            this.from.add(from);
        }
        if (to == null) {
            this.to.add(Double.POSITIVE_INFINITY);
        } else {
            this.to.add(to);
        }
    }

    @Override
    public FacetBuilder getFacet() {
        Assert.notNull((Object)this.getName(), (String)"Facet name can't be a null !!!");
        Assert.isTrue((StringUtils.isNotBlank((String)this.field) || StringUtils.isNotBlank((String)this.keyField) && StringUtils.isNotBlank((String)this.valueField) ? 1 : 0) != 0, (String)"Please select field or key field and value field !!!");
        RangeFacetBuilder builder = FacetBuilders.rangeFacet((String)this.getName());
        if (StringUtils.isNotBlank((String)this.keyField)) {
            builder.keyField(this.keyField).valueField(this.valueField);
        } else {
            builder.field(this.field);
        }
        Assert.notEmpty(this.from, (String)"Please select at last one range");
        Assert.notEmpty(this.to, (String)"Please select at last one range");
        for (int i = 0; i < this.from.size(); ++i) {
            builder.addRange(this.from.get(i).doubleValue(), this.to.get(i).doubleValue());
        }
        return builder;
    }
}

