/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.facet.FacetRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;

public class NativeSearchQueryBuilder {
    private QueryBuilder queryBuilder;
    private FilterBuilder filterBuilder;
    private SortBuilder sortBuilder;
    private List<FacetRequest> facetRequests = new ArrayList<FacetRequest>();
    private HighlightBuilder.Field[] highlightFields;
    private Pageable pageable;
    private String[] indices;
    private String[] types;
    private String[] fields;
    private float minScore;

    public NativeSearchQueryBuilder withQuery(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withFilter(FilterBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withSort(SortBuilder sortBuilder) {
        this.sortBuilder = sortBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withFacet(FacetRequest facetRequest) {
        this.facetRequests.add(facetRequest);
        return this;
    }

    public NativeSearchQueryBuilder withHighlightFields(HighlightBuilder.Field ... highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    public NativeSearchQueryBuilder withPageable(Pageable pageable) {
        this.pageable = pageable;
        return this;
    }

    public NativeSearchQueryBuilder withIndices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public NativeSearchQueryBuilder withTypes(String ... types) {
        this.types = types;
        return this;
    }

    public NativeSearchQueryBuilder withFields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public NativeSearchQueryBuilder withMinScore(float minScore) {
        this.minScore = minScore;
        return this;
    }

    public NativeSearchQuery build() {
        NativeSearchQuery nativeSearchQuery = new NativeSearchQuery(this.queryBuilder, this.filterBuilder, this.sortBuilder, this.highlightFields);
        if (this.pageable != null) {
            nativeSearchQuery.setPageable(this.pageable);
        }
        if (this.indices != null) {
            nativeSearchQuery.addIndices(this.indices);
        }
        if (this.types != null) {
            nativeSearchQuery.addTypes(this.types);
        }
        if (this.fields != null) {
            nativeSearchQuery.addFields(this.fields);
        }
        if (CollectionUtils.isNotEmpty(this.facetRequests)) {
            nativeSearchQuery.setFacets(this.facetRequests);
        }
        if (this.minScore > 0.0f) {
            nativeSearchQuery.setMinScore(this.minScore);
        }
        return nativeSearchQuery;
    }
}

