/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.query.parser.ElasticsearchQueryCreator;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;

public class ElasticsearchPartQuery
extends AbstractElasticsearchRepositoryQuery {
    private final PartTree tree;
    private final MappingContext<?, ElasticsearchPersistentProperty> mappingContext;

    public ElasticsearchPartQuery(ElasticsearchQueryMethod method, ElasticsearchOperations elasticsearchOperations) {
        super(method, elasticsearchOperations);
        this.tree = new PartTree(method.getName(), method.getEntityInformation().getJavaType());
        this.mappingContext = elasticsearchOperations.getElasticsearchConverter().getMappingContext();
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        CriteriaQuery query = this.createQuery(accessor);
        if (this.queryMethod.isPageQuery()) {
            query.setPageable(accessor.getPageable());
            return this.elasticsearchOperations.queryForPage(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (this.queryMethod.isCollectionQuery()) {
            if (accessor.getPageable() != null) {
                query.setPageable(accessor.getPageable());
            }
            return this.elasticsearchOperations.queryForList(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        return this.elasticsearchOperations.queryForObject(query, this.queryMethod.getEntityInformation().getJavaType());
    }

    public CriteriaQuery createQuery(ParametersParameterAccessor accessor) {
        return (CriteriaQuery)new ElasticsearchQueryCreator(this.tree, (ParameterAccessor)accessor, this.mappingContext).createQuery();
    }
}

