/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import org.elasticsearch.index.query.QueryBuilders;
import org.reactivestreams.Publisher;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveElasticsearchOperations {
    public <T> Publisher<T> execute(ClientCallback<Publisher<T>> var1);

    default public <T> Mono<T> save(Mono<? extends T> entityPublisher) {
        Assert.notNull(entityPublisher, (String)"EntityPublisher must not be null!");
        return entityPublisher.flatMap(this::save);
    }

    default public <T> Mono<T> save(T entity) {
        return this.save(entity, null);
    }

    default public <T> Mono<T> save(Mono<? extends T> entityPublisher, String index) {
        Assert.notNull(entityPublisher, (String)"EntityPublisher must not be null!");
        return entityPublisher.flatMap(it -> this.save(it, index));
    }

    default public <T> Mono<T> save(T entity, @Nullable String index) {
        return this.save(entity, index, null);
    }

    default public <T> Mono<T> save(Mono<? extends T> entityPublisher, @Nullable String index, @Nullable String type) {
        Assert.notNull(entityPublisher, (String)"EntityPublisher must not be null!");
        return entityPublisher.flatMap(it -> this.save(it, index, type));
    }

    public <T> Mono<T> save(T var1, @Nullable String var2, @Nullable String var3);

    default public <T> Mono<T> findById(String id, Class<T> entityType) {
        return this.findById(id, entityType, null);
    }

    default public <T> Mono<T> findById(String id, Class<T> entityType, @Nullable String index) {
        return this.findById(id, entityType, index, null);
    }

    public <T> Mono<T> findById(String var1, Class<T> var2, @Nullable String var3, @Nullable String var4);

    default public Mono<Boolean> exists(String id, Class<?> entityType) {
        return this.exists(id, entityType, null);
    }

    default public Mono<Boolean> exists(String id, Class<?> entityType, @Nullable String index) {
        return this.exists(id, entityType, index, null);
    }

    public Mono<Boolean> exists(String var1, Class<?> var2, @Nullable String var3, @Nullable String var4);

    default public <T> Flux<T> find(Query query, Class<T> entityType) {
        return this.find(query, entityType, entityType);
    }

    default public <T> Flux<T> find(Query query, Class<?> entityType, Class<T> returnType) {
        return this.find(query, entityType, null, null, returnType);
    }

    default public <T> Flux<T> find(Query query, Class<T> entityType, @Nullable String index) {
        return this.find(query, entityType, index, null);
    }

    default public <T> Flux<T> find(Query query, Class<T> entityType, @Nullable String index, @Nullable String type) {
        return this.find(query, entityType, index, type, entityType);
    }

    public <T> Flux<T> find(Query var1, Class<?> var2, @Nullable String var3, @Nullable String var4, Class<T> var5);

    default public Mono<Long> count(Class<?> entityType) {
        return this.count(new StringQuery(QueryBuilders.matchAllQuery().toString()), entityType, null);
    }

    default public Mono<Long> count(Query query, Class<?> entityType) {
        return this.count(query, entityType, null);
    }

    default public Mono<Long> count(Query query, Class<?> entityType, @Nullable String index) {
        return this.count(query, entityType, index, null);
    }

    public Mono<Long> count(Query var1, Class<?> var2, @Nullable String var3, @Nullable String var4);

    default public Mono<String> delete(Object entity) {
        return this.delete(entity, null);
    }

    default public Mono<String> delete(Object entity, @Nullable String index) {
        return this.delete(entity, index, null);
    }

    public Mono<String> delete(Object var1, @Nullable String var2, @Nullable String var3);

    default public Mono<String> deleteById(String id, String index, String type) {
        Assert.notNull((Object)index, (String)"Index must not be null!");
        Assert.notNull((Object)type, (String)"Type must not be null!");
        return this.deleteById(id, Object.class, index, type);
    }

    default public Mono<String> deleteById(String id, Class<?> entityType) {
        return this.deleteById(id, entityType, null);
    }

    default public Mono<String> deleteById(String id, Class<?> entityType, @Nullable String index) {
        return this.deleteById(id, entityType, index, null);
    }

    public Mono<String> deleteById(String var1, Class<?> var2, @Nullable String var3, @Nullable String var4);

    default public Mono<Long> deleteBy(Query query, Class<?> entityType) {
        return this.deleteBy(query, entityType, null);
    }

    default public Mono<Long> deleteBy(Query query, Class<?> entityType, @Nullable String index) {
        return this.deleteBy(query, entityType, index, null);
    }

    public Mono<Long> deleteBy(Query var1, Class<?> var2, @Nullable String var3, @Nullable String var4);

    public static interface ClientCallback<T extends Publisher<?>> {
        public T doWithClient(ReactiveElasticsearchClient var1);
    }
}

