/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.net.ConnectException;
import org.elasticsearch.ElasticsearchException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.util.CollectionUtils;

public class ElasticsearchExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        ElasticsearchException elasticsearchException;
        if (ex instanceof ElasticsearchException && !this.indexAvailable(elasticsearchException = (ElasticsearchException)((Object)ex))) {
            return new NoSuchIndexException(elasticsearchException.getMetadata("es.index").toString(), ex);
        }
        if (ex.getCause() instanceof ConnectException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private boolean indexAvailable(ElasticsearchException ex) {
        return !CollectionUtils.contains(ex.getMetadata("es.index_uuid").iterator(), (Object)"_na_");
    }
}

