/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;

public abstract class ClientLogger {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final Logger WIRE_LOGGER = LoggerFactory.getLogger((String)"org.springframework.data.elasticsearch.client.WIRE");

    private ClientLogger() {
    }

    public static boolean isEnabled() {
        return WIRE_LOGGER.isTraceEnabled();
    }

    public static void logRequest(String logId, String method, String endpoint, Object parameters) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace("[{}] Sending request {} {} with parameters: {}", new Object[]{logId, method.toUpperCase(), endpoint, parameters});
        }
    }

    public static void logRequest(String logId, String method, String endpoint, Object parameters, Supplier<Object> body) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace("[{}] Sending request {} {} with parameters: {}{}Request body: {}", new Object[]{logId, method.toUpperCase(), endpoint, parameters, lineSeparator, body.get()});
        }
    }

    public static void logRawResponse(String logId, HttpStatus statusCode) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace("[{}] Received raw response: ", (Object)logId, (Object)statusCode);
        }
    }

    public static void logResponse(String logId, HttpStatus statusCode, String body) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace("[{}] Received response: {}{}Response body: {}", new Object[]{logId, statusCode, lineSeparator, body});
        }
    }

    public static String newLogId() {
        if (!ClientLogger.isEnabled()) {
            return "-";
        }
        return ObjectUtils.getIdentityHexString((Object)new Object());
    }
}

