/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public interface ReactiveElasticsearchQueryExecution {
    public Object execute(Query var1, Class<?> var2, String var3, String var4, @Nullable Class<?> var5);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;
        @NonNull
        private final ReactiveElasticsearchOperations operations;

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            return this.processor.processResult(source, it -> it);
        }

        public ResultProcessingConverter(@NonNull ResultProcessor processor, @NonNull ReactiveElasticsearchOperations operations) {
            if (processor == null) {
                throw new NullPointerException("processor is marked @NonNull but is null");
            }
            if (operations == null) {
                throw new NullPointerException("operations is marked @NonNull but is null");
            }
            this.processor = processor;
            this.operations = operations;
        }
    }

    public static final class ResultProcessingExecution
    implements ReactiveElasticsearchQueryExecution {
        @NonNull
        private final ReactiveElasticsearchQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        public Object execute(Query query, Class<?> type, String indexName, String indexType, @Nullable Class<?> targetType) {
            return this.converter.convert(this.delegate.execute(query, type, indexName, indexType, targetType));
        }

        public ResultProcessingExecution(@NonNull ReactiveElasticsearchQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked @NonNull but is null");
            }
            if (converter == null) {
                throw new NullPointerException("converter is marked @NonNull but is null");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }
}

