/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.CriteriaFilterProcessor;
import org.springframework.data.elasticsearch.core.CriteriaQueryProcessor;
import org.springframework.data.elasticsearch.core.DefaultResultMapper;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.EsClient;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.MappingBuilder;
import org.springframework.data.elasticsearch.core.MultiGetResultMapper;
import org.springframework.data.elasticsearch.core.ResourceUtil;
import org.springframework.data.elasticsearch.core.ResultsExtractor;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.data.elasticsearch.core.ScrolledPage;
import org.springframework.data.elasticsearch.core.SearchResultMapper;
import org.springframework.data.elasticsearch.core.StreamQueries;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.client.support.AliasData;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.facet.FacetRequest;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ElasticsearchRestTemplate
implements ElasticsearchOperations,
EsClient<RestHighLevelClient>,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchRestTemplate.class);
    private RestHighLevelClient client;
    private ElasticsearchConverter elasticsearchConverter;
    private ResultsMapper resultsMapper;
    private String searchTimeout;

    public ElasticsearchRestTemplate(RestHighLevelClient client) {
        this(client, new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()));
    }

    public ElasticsearchRestTemplate(RestHighLevelClient client, EntityMapper entityMapper) {
        this(client, (ElasticsearchConverter)new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()), entityMapper);
    }

    public ElasticsearchRestTemplate(RestHighLevelClient client, ElasticsearchConverter elasticsearchConverter, EntityMapper entityMapper) {
        this(client, elasticsearchConverter, new DefaultResultMapper(elasticsearchConverter.getMappingContext(), entityMapper));
    }

    public ElasticsearchRestTemplate(RestHighLevelClient client, ResultsMapper resultsMapper) {
        this(client, (ElasticsearchConverter)new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()), resultsMapper);
    }

    public ElasticsearchRestTemplate(RestHighLevelClient client, ElasticsearchConverter elasticsearchConverter) {
        this(client, elasticsearchConverter, new DefaultResultMapper(elasticsearchConverter.getMappingContext()));
    }

    public ElasticsearchRestTemplate(RestHighLevelClient client, ElasticsearchConverter elasticsearchConverter, ResultsMapper resultsMapper) {
        Assert.notNull((Object)client, (String)"Client must not be null!");
        Assert.notNull((Object)elasticsearchConverter, (String)"ElasticsearchConverter must not be null!");
        Assert.notNull((Object)resultsMapper, (String)"ResultsMapper must not be null!");
        this.client = client;
        this.elasticsearchConverter = elasticsearchConverter;
        this.resultsMapper = resultsMapper;
    }

    @Override
    public RestHighLevelClient getClient() {
        return this.client;
    }

    public void setSearchTimeout(String searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    @Override
    public boolean addAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().alias(query.getAliasName()).index(query.getIndexName());
        if (query.getFilterBuilder() != null) {
            aliasAction.filter(query.getFilterBuilder());
        } else if (query.getFilter() != null) {
            aliasAction.filter(query.getFilter());
        } else if (StringUtils.hasText((String)query.getRouting())) {
            aliasAction.routing(query.getRouting());
        } else if (StringUtils.hasText((String)query.getSearchRouting())) {
            aliasAction.searchRouting(query.getSearchRouting());
        } else if (StringUtils.hasText((String)query.getIndexRouting())) {
            aliasAction.indexRouting(query.getIndexRouting());
        }
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        request.addAliasAction(aliasAction);
        try {
            return this.client.indices().updateAliases(request, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to update aliases with request: " + request, e);
        }
    }

    @Override
    public boolean removeAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE);
        request.addAliasAction(aliasAction);
        try {
            return this.client.indices().updateAliases(request, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to update aliases with request: " + request, e);
        }
    }

    @Override
    public <T> boolean createIndex(Class<T> clazz) {
        return this.createIndexIfNotCreated(clazz);
    }

    @Override
    public boolean createIndex(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        try {
            return this.client.indices().create(Requests.createIndexRequest((String)indexName), RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to create index " + indexName, e);
        }
    }

    @Override
    public <T> boolean putMapping(Class<T> clazz) {
        if (clazz.isAnnotationPresent(Mapping.class)) {
            String mappingPath = clazz.getAnnotation(Mapping.class).mappingPath();
            if (StringUtils.hasText((String)mappingPath)) {
                String mappings = ResourceUtil.readFileFromClasspath(mappingPath);
                if (StringUtils.hasText((String)mappings)) {
                    return this.putMapping(clazz, mappings);
                }
            } else {
                logger.info("mappingPath in @Mapping has to be defined. Building mappings using @Field");
            }
        }
        try {
            MappingBuilder mappingBuilder = new MappingBuilder(this.elasticsearchConverter);
            return this.putMapping(clazz, mappingBuilder.buildPropertyMapping(clazz));
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), e);
        }
    }

    @Override
    public <T> boolean putMapping(Class<T> clazz, Object mapping) {
        return this.putMapping(this.getPersistentEntityFor(clazz).getIndexName(), this.getPersistentEntityFor(clazz).getIndexType(), mapping);
    }

    @Override
    public boolean putMapping(String indexName, String type, Object mapping) {
        Assert.notNull((Object)indexName, (String)"No index defined for putMapping()");
        Assert.notNull((Object)type, (String)"No type defined for putMapping()");
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).type(type);
        if (mapping instanceof String) {
            request.source(String.valueOf(mapping), XContentType.JSON);
        } else if (mapping instanceof Map) {
            request.source((Map)mapping);
        } else if (mapping instanceof XContentBuilder) {
            request.source((XContentBuilder)mapping);
        }
        try {
            return this.client.indices().putMapping(request, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to put mapping for " + indexName, e);
        }
    }

    @Override
    public Map<String, Object> getMapping(String indexName, String type) {
        Assert.notNull((Object)indexName, (String)"No index defined for getMapping()");
        Assert.notNull((Object)type, (String)"No type defined for getMapping()");
        Map<String, Object> mappings = null;
        RestClient restClient = this.client.getLowLevelClient();
        try {
            Response response = restClient.performRequest("GET", "/" + indexName + "/_mapping/" + type, new Header[0]);
            mappings = this.convertMappingResponse(EntityUtils.toString((HttpEntity)response.getEntity()), type);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Error while getting mapping for indexName : " + indexName + " type : " + type + " ", e);
        }
        return mappings;
    }

    @Override
    public <T> Map<String, Object> getMapping(Class<T> clazz) {
        return this.getMapping(this.getPersistentEntityFor(clazz).getIndexName(), this.getPersistentEntityFor(clazz).getIndexType());
    }

    private Map<String, Object> convertMappingResponse(String mappingResponse, String type) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map result = null;
            JsonNode node = mapper.readTree(mappingResponse);
            node = node.findValue("mappings").findValue(type);
            result = (Map)mapper.readValue(mapper.writeValueAsString((Object)node), HashMap.class);
            return result;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Could not map alias response : " + mappingResponse, e);
        }
    }

    @Override
    public ElasticsearchConverter getElasticsearchConverter() {
        return this.elasticsearchConverter;
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz) {
        return this.queryForObject(query, clazz, this.resultsMapper);
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz, GetResultMapper mapper) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        GetRequest request = new GetRequest(persistentEntity.getIndexName(), persistentEntity.getIndexType(), query.getId());
        try {
            GetResponse response = this.client.get(request, RequestOptions.DEFAULT);
            return mapper.mapResult(response, clazz);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error while getting for request: " + request.toString(), e);
        }
    }

    @Override
    public <T> T queryForObject(CriteriaQuery query, Class<T> clazz) {
        Page<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    @Override
    public <T> T queryForObject(StringQuery query, Class<T> clazz) {
        Page<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    public <T> AggregatedPage<T> queryForPage(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, (Class)clazz, (SearchResultMapper)this.resultsMapper);
    }

    public <T> AggregatedPage<T> queryForPage(SearchQuery query, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.doSearch(this.prepareSearch(query, clazz), query);
        return mapper.mapResults(response, clazz, query.getPageable());
    }

    @Override
    public <T> List<Page<T>> queryForPage(List<SearchQuery> queries, Class<T> clazz) {
        return this.queryForPage(queries, clazz, (SearchResultMapper)this.resultsMapper);
    }

    private <T> List<Page<T>> doMultiSearch(List<SearchQuery> queries, Class<T> clazz, MultiSearchRequest request, SearchResultMapper resultsMapper) {
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList<Page<T>> res = new ArrayList<Page<T>>(queries.size());
        int c = 0;
        for (SearchQuery query : queries) {
            res.add(resultsMapper.mapResults(items[c++].getResponse(), clazz, query.getPageable()));
        }
        return res;
    }

    private List<Page<?>> doMultiSearch(List<SearchQuery> queries, List<Class<?>> classes, MultiSearchRequest request, SearchResultMapper resultsMapper) {
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList res = new ArrayList(queries.size());
        int c = 0;
        Iterator<Class<?>> it = classes.iterator();
        for (SearchQuery query : queries) {
            res.add(resultsMapper.mapResults(items[c++].getResponse(), it.next(), query.getPageable()));
        }
        return res;
    }

    private MultiSearchResponse.Item[] getMultiSearchResult(MultiSearchRequest request) {
        MultiSearchResponse response;
        try {
            response = this.client.multiSearch(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request: " + request.toString(), e);
        }
        MultiSearchResponse.Item[] items = response.getResponses();
        Assert.isTrue((items.length == request.requests().size() ? 1 : 0) != 0, (String)"Response should has same length with queries");
        return items;
    }

    @Override
    public <T> List<Page<T>> queryForPage(List<SearchQuery> queries, Class<T> clazz, SearchResultMapper mapper) {
        MultiSearchRequest request = new MultiSearchRequest();
        for (SearchQuery query : queries) {
            request.add(this.prepareSearch(this.prepareSearch(query, clazz), query));
        }
        return this.doMultiSearch(queries, clazz, request, mapper);
    }

    @Override
    public List<Page<?>> queryForPage(List<SearchQuery> queries, List<Class<?>> classes) {
        return this.queryForPage(queries, classes, (SearchResultMapper)this.resultsMapper);
    }

    @Override
    public List<Page<?>> queryForPage(List<SearchQuery> queries, List<Class<?>> classes, SearchResultMapper mapper) {
        MultiSearchRequest request = new MultiSearchRequest();
        Iterator<Class<?>> it = classes.iterator();
        for (SearchQuery query : queries) {
            request.add(this.prepareSearch(this.prepareSearch(query, it.next()), query));
        }
        return this.doMultiSearch(queries, classes, request, mapper);
    }

    @Override
    public <T> T query(SearchQuery query, ResultsExtractor<T> resultsExtractor) {
        SearchResponse response = this.doSearch(this.prepareSearch(query, Optional.ofNullable(query.getQuery()), null), query);
        return resultsExtractor.extract(response);
    }

    @Override
    public <T> List<T> queryForList(CriteriaQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    @Override
    public <T> List<T> queryForList(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    @Override
    public <T> List<T> queryForList(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, (Class)clazz).getContent();
    }

    @Override
    public <T> List<String> queryForIds(SearchQuery query) {
        SearchResponse response;
        SearchRequest request = this.prepareSearch(query, Optional.ofNullable(query.getQuery()), null);
        request.source().query(query.getQuery());
        if (query.getFilter() != null) {
            request.source().postFilter(query.getFilter());
        }
        try {
            response = this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request: " + request.toString(), e);
        }
        return this.extractIds(response);
    }

    @Override
    public <T> Page<T> queryForPage(CriteriaQuery criteriaQuery, Class<T> clazz) {
        SearchResponse response;
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        SearchRequest request = this.prepareSearch(criteriaQuery, clazz);
        if (elasticsearchQuery != null) {
            request.source().query(elasticsearchQuery);
        } else {
            request.source().query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (criteriaQuery.getMinScore() > 0.0f) {
            request.source().minScore(criteriaQuery.getMinScore());
        }
        if (elasticsearchFilter != null) {
            request.source().postFilter(elasticsearchFilter);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("doSearch query:\n" + request.toString());
        }
        try {
            response = this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request: " + request.toString(), e);
        }
        return this.resultsMapper.mapResults(response, clazz, criteriaQuery.getPageable());
    }

    @Override
    public <T> Page<T> queryForPage(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz, (SearchResultMapper)this.resultsMapper);
    }

    @Override
    public <T> Page<T> queryForPage(StringQuery query, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response;
        SearchRequest request = this.prepareSearch(query, clazz);
        request.source().query((QueryBuilder)QueryBuilders.wrapperQuery((String)query.getSource()));
        try {
            response = this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request: " + request.toString(), e);
        }
        return mapper.mapResults(response, clazz, query.getPageable());
    }

    @Override
    public <T> CloseableIterator<T> stream(CriteriaQuery query, Class<T> clazz) {
        long scrollTimeInMillis = TimeValue.timeValueMinutes((long)1L).millis();
        return this.doStream(scrollTimeInMillis, this.startScroll(scrollTimeInMillis, query, clazz), clazz, this.resultsMapper);
    }

    @Override
    public <T> CloseableIterator<T> stream(SearchQuery query, Class<T> clazz) {
        return this.stream(query, clazz, this.resultsMapper);
    }

    @Override
    public <T> CloseableIterator<T> stream(SearchQuery query, Class<T> clazz, SearchResultMapper mapper) {
        long scrollTimeInMillis = TimeValue.timeValueMinutes((long)1L).millis();
        return this.doStream(scrollTimeInMillis, this.startScroll(scrollTimeInMillis, query, clazz, mapper), clazz, mapper);
    }

    private <T> CloseableIterator<T> doStream(long scrollTimeInMillis, ScrolledPage<T> page, Class<T> clazz, SearchResultMapper mapper) {
        return StreamQueries.streamResults(page, scrollId -> this.continueScroll((String)scrollId, scrollTimeInMillis, clazz, mapper), this::clearScroll);
    }

    @Override
    public <T> long count(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        if (elasticsearchFilter == null) {
            return this.doCount(this.prepareCount(criteriaQuery, clazz), elasticsearchQuery);
        }
        return this.doCount(this.prepareSearch(criteriaQuery, clazz), elasticsearchQuery, elasticsearchFilter);
    }

    @Override
    public <T> long count(SearchQuery searchQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = searchQuery.getQuery();
        QueryBuilder elasticsearchFilter = searchQuery.getFilter();
        if (elasticsearchFilter == null) {
            return this.doCount(this.prepareCount(searchQuery, clazz), elasticsearchQuery);
        }
        return this.doCount(this.prepareSearch(searchQuery, clazz), elasticsearchQuery, elasticsearchFilter);
    }

    @Override
    public <T> long count(CriteriaQuery query) {
        return this.count(query, null);
    }

    @Override
    public <T> long count(SearchQuery query) {
        return this.count(query, null);
    }

    private long doCount(SearchRequest countRequest, QueryBuilder elasticsearchQuery) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        if (elasticsearchQuery != null) {
            sourceBuilder.query(elasticsearchQuery);
        }
        countRequest.source(sourceBuilder);
        try {
            return this.client.search(countRequest, RequestOptions.DEFAULT).getHits().getTotalHits();
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error while searching for request: " + countRequest.toString(), e);
        }
    }

    private long doCount(SearchRequest searchRequest, QueryBuilder elasticsearchQuery, QueryBuilder elasticsearchFilter) {
        SearchResponse response;
        if (elasticsearchQuery != null) {
            searchRequest.source().query(elasticsearchQuery);
        } else {
            searchRequest.source().query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (elasticsearchFilter != null) {
            searchRequest.source().postFilter(elasticsearchFilter);
        }
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request: " + searchRequest.toString(), e);
        }
        return response.getHits().getTotalHits();
    }

    private <T> SearchRequest prepareCount(Query query, Class<T> clazz) {
        String[] indexName = !CollectionUtils.isEmpty(query.getIndices()) ? query.getIndices().toArray(new String[query.getIndices().size()]) : this.retrieveIndexNameFromPersistentEntity(clazz);
        String[] types = !CollectionUtils.isEmpty(query.getTypes()) ? query.getTypes().toArray(new String[query.getTypes().size()]) : this.retrieveTypeFromPersistentEntity(clazz);
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        SearchRequest countRequestBuilder = new SearchRequest(indexName);
        if (types != null) {
            countRequestBuilder.types(types);
        }
        return countRequestBuilder;
    }

    @Override
    public <T> List<T> multiGet(SearchQuery searchQuery, Class<T> clazz) {
        return this.resultsMapper.mapResults(this.getMultiResponse(searchQuery, clazz), clazz);
    }

    private <T> MultiGetResponse getMultiResponse(Query searchQuery, Class<T> clazz) {
        String indexName = !CollectionUtils.isEmpty(searchQuery.getIndices()) ? searchQuery.getIndices().get(0) : this.getPersistentEntityFor(clazz).getIndexName();
        String type = !CollectionUtils.isEmpty(searchQuery.getTypes()) ? searchQuery.getTypes().get(0) : this.getPersistentEntityFor(clazz).getIndexType();
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Assert.notNull((Object)type, (String)"No type define for Query");
        Assert.notEmpty(searchQuery.getIds(), (String)"No Id define for Query");
        MultiGetRequest request = new MultiGetRequest();
        if (searchQuery.getFields() != null && !searchQuery.getFields().isEmpty()) {
            searchQuery.addSourceFilter(new FetchSourceFilter(ElasticsearchRestTemplate.toArray(searchQuery.getFields()), null));
        }
        for (String id : searchQuery.getIds()) {
            MultiGetRequest.Item item = new MultiGetRequest.Item(indexName, type, id);
            if (searchQuery.getRoute() != null) {
                item = item.routing(searchQuery.getRoute());
            }
            request.add(item);
        }
        try {
            return this.client.multiGet(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error while multiget for request: " + request.toString(), e);
        }
    }

    @Override
    public <T> List<T> multiGet(SearchQuery searchQuery, Class<T> clazz, MultiGetResultMapper getResultMapper) {
        return getResultMapper.mapResults(this.getMultiResponse(searchQuery, clazz), clazz);
    }

    @Override
    public String index(IndexQuery query) {
        String documentId;
        IndexRequest request = this.prepareIndex(query);
        try {
            documentId = this.client.index(request, RequestOptions.DEFAULT).getId();
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error while index for request: " + request.toString(), e);
        }
        if (query.getObject() != null) {
            this.setPersistentEntityId(query.getObject(), documentId);
        }
        return documentId;
    }

    @Override
    public UpdateResponse update(UpdateQuery query) {
        UpdateRequest request = this.prepareUpdate(query);
        try {
            return this.client.update(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error while update for request: " + request.toString(), e);
        }
    }

    private UpdateRequest prepareUpdate(UpdateQuery query) {
        String indexName = StringUtils.hasText((String)query.getIndexName()) ? query.getIndexName() : this.getPersistentEntityFor(query.getClazz()).getIndexName();
        String type = StringUtils.hasText((String)query.getType()) ? query.getType() : this.getPersistentEntityFor(query.getClazz()).getIndexType();
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Assert.notNull((Object)type, (String)"No type define for Query");
        Assert.notNull((Object)query.getId(), (String)"No Id define for Query");
        Assert.notNull((Object)query.getUpdateRequest(), (String)"No IndexRequest define for Query");
        UpdateRequest updateRequest = new UpdateRequest(indexName, type, query.getId());
        updateRequest.routing(query.getUpdateRequest().routing());
        if (query.getUpdateRequest().script() == null) {
            if (query.DoUpsert()) {
                updateRequest.docAsUpsert(true).doc(query.getUpdateRequest().doc());
            } else {
                updateRequest.doc(query.getUpdateRequest().doc());
            }
        } else {
            updateRequest.script(query.getUpdateRequest().script());
        }
        return updateRequest;
    }

    @Override
    public void bulkIndex(List<IndexQuery> queries, BulkOptions bulkOptions) {
        Assert.notNull(queries, (String)"List of IndexQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        BulkRequest bulkRequest = new BulkRequest();
        ElasticsearchRestTemplate.setBulkOptions(bulkRequest, bulkOptions);
        for (IndexQuery query : queries) {
            bulkRequest.add(this.prepareIndex(query));
        }
        try {
            this.checkForBulkUpdateFailure(this.client.bulk(bulkRequest, RequestOptions.DEFAULT));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error while bulk for request: " + bulkRequest.toString(), e);
        }
    }

    @Override
    public void bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions) {
        Assert.notNull(queries, (String)"List of UpdateQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        BulkRequest bulkRequest = new BulkRequest();
        ElasticsearchRestTemplate.setBulkOptions(bulkRequest, bulkOptions);
        for (UpdateQuery query : queries) {
            bulkRequest.add(this.prepareUpdate(query));
        }
        try {
            this.checkForBulkUpdateFailure(this.client.bulk(bulkRequest, RequestOptions.DEFAULT));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error while bulk for request: " + bulkRequest.toString(), e);
        }
    }

    private static void setBulkOptions(BulkRequest bulkRequest, BulkOptions bulkOptions) {
        if (bulkOptions.getTimeout() != null) {
            bulkRequest.timeout(bulkOptions.getTimeout());
        }
        if (bulkOptions.getRefreshPolicy() != null) {
            bulkRequest.setRefreshPolicy(bulkOptions.getRefreshPolicy());
        }
        if (bulkOptions.getWaitForActiveShards() != null) {
            bulkRequest.waitForActiveShards(bulkOptions.getWaitForActiveShards());
        }
        if (bulkOptions.getPipeline() != null) {
            bulkRequest.pipeline(bulkOptions.getPipeline());
        }
        if (bulkOptions.getRoutingId() != null) {
            bulkRequest.routing(bulkOptions.getRoutingId());
        }
    }

    private void checkForBulkUpdateFailure(BulkResponse bulkResponse) {
        if (bulkResponse.hasFailures()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), item.getFailureMessage());
            }
            throw new ElasticsearchException("Bulk indexing has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + "]", failedDocuments);
        }
    }

    @Override
    public <T> boolean indexExists(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public boolean indexExists(String indexName) {
        GetIndexRequest request = new GetIndexRequest();
        request.indices(new String[]{indexName});
        try {
            return this.client.indices().exists(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error while for indexExists request: " + request.toString(), e);
        }
    }

    @Override
    public boolean typeExists(String index, String type) {
        RestClient restClient = this.client.getLowLevelClient();
        try {
            Response response = restClient.performRequest("HEAD", index + "/_mapping/" + type, new Header[0]);
            return response.getStatusLine().getStatusCode() == 200;
        }
        catch (Exception e) {
            throw new ElasticsearchException("Error while checking type exists for index: " + index + " type : " + type + " ", e);
        }
    }

    @Override
    public <T> boolean deleteIndex(Class<T> clazz) {
        return this.deleteIndex(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public boolean deleteIndex(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for delete operation");
        if (this.indexExists(indexName)) {
            DeleteIndexRequest request = new DeleteIndexRequest(indexName);
            try {
                return this.client.indices().delete(request, RequestOptions.DEFAULT).isAcknowledged();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Error while deleting index request: " + request.toString(), e);
            }
        }
        return false;
    }

    @Override
    public String delete(String indexName, String type, String id) {
        DeleteRequest request = new DeleteRequest(indexName, type, id);
        try {
            return this.client.delete(request, RequestOptions.DEFAULT).getId();
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error while deleting item request: " + request.toString(), e);
        }
    }

    @Override
    public <T> String delete(Class<T> clazz, String id) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        return this.delete(persistentEntity.getIndexName(), persistentEntity.getIndexType(), id);
    }

    @Override
    public <T> void delete(DeleteQuery deleteQuery, Class<T> clazz) {
        String indexName = StringUtils.hasText((String)deleteQuery.getIndex()) ? deleteQuery.getIndex() : this.getPersistentEntityFor(clazz).getIndexName();
        String typeName = StringUtils.hasText((String)deleteQuery.getType()) ? deleteQuery.getType() : this.getPersistentEntityFor(clazz).getIndexType();
        DeleteByQueryRequest deleteByQueryRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{indexName}).setDocTypes(new String[]{typeName}).setQuery(deleteQuery.getQuery()).setAbortOnVersionConflict(false)).setRefresh(true);
        if (deleteQuery.getPageSize() != null) {
            deleteByQueryRequest.setBatchSize(deleteQuery.getPageSize().intValue());
        }
        if (deleteQuery.getScrollTimeInMillis() != null) {
            deleteByQueryRequest.setScroll(TimeValue.timeValueMillis((long)deleteQuery.getScrollTimeInMillis()));
        }
        try {
            this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for delete request: " + deleteByQueryRequest.toString(), e);
        }
    }

    @Override
    public void delete(DeleteQuery deleteQuery) {
        Assert.notNull((Object)deleteQuery.getIndex(), (String)"No index defined for Query");
        Assert.notNull((Object)deleteQuery.getType(), (String)"No type define for Query");
        this.delete(deleteQuery, null);
    }

    @Override
    public <T> void delete(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        Assert.notNull((Object)elasticsearchQuery, (String)"Query can not be null.");
        DeleteQuery deleteQuery = new DeleteQuery();
        deleteQuery.setQuery(elasticsearchQuery);
        this.delete(deleteQuery, clazz);
    }

    private <T> SearchRequest prepareScroll(Query query, long scrollTimeInMillis, Class<T> clazz) {
        this.setPersistentEntityIndexAndType(query, clazz);
        ElasticsearchPersistentEntity<?> entity = this.getPersistentEntity(clazz);
        return this.prepareScroll(query, scrollTimeInMillis, entity);
    }

    private SearchRequest prepareScroll(Query query, long scrollTimeInMillis, @Nullable ElasticsearchPersistentEntity<?> entity) {
        SearchQuery searchQuery;
        SearchRequest request = new SearchRequest(ElasticsearchRestTemplate.toArray(query.getIndices()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        request.types(ElasticsearchRestTemplate.toArray(query.getTypes()));
        request.scroll(TimeValue.timeValueMillis((long)scrollTimeInMillis));
        if (query.getPageable().isPaged()) {
            searchSourceBuilder.size(query.getPageable().getPageSize());
        }
        if (query.getSourceFilter() != null) {
            SourceFilter sourceFilter = query.getSourceFilter();
            searchSourceBuilder.fetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (!CollectionUtils.isEmpty(query.getFields())) {
            searchSourceBuilder.fetchSource(ElasticsearchRestTemplate.toArray(query.getFields()), null);
        }
        if (query.getSort() != null) {
            this.prepareSort(query, searchSourceBuilder, entity);
        }
        if (query instanceof SearchQuery && ((searchQuery = (SearchQuery)query).getHighlightFields() != null || searchQuery.getHighlightBuilder() != null)) {
            HighlightBuilder highlightBuilder = searchQuery.getHighlightBuilder();
            if (highlightBuilder == null) {
                highlightBuilder = new HighlightBuilder();
            }
            if (searchQuery.getHighlightFields() != null) {
                for (HighlightBuilder.Field highlightField : searchQuery.getHighlightFields()) {
                    highlightBuilder.field(highlightField);
                }
            }
            searchSourceBuilder.highlighter(highlightBuilder);
        }
        request.source(searchSourceBuilder);
        return request;
    }

    private SearchResponse doScroll(SearchRequest request, CriteriaQuery criteriaQuery) {
        Assert.notNull((Object)criteriaQuery.getIndices(), (String)"No index defined for Query");
        Assert.notNull((Object)criteriaQuery.getTypes(), (String)"No type define for Query");
        Assert.notNull((Object)criteriaQuery.getPageable(), (String)"Query.pageable is required for scan & scroll");
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        if (elasticsearchQuery != null) {
            request.source().query(elasticsearchQuery);
        } else {
            request.source().query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (elasticsearchFilter != null) {
            request.source().postFilter(elasticsearchFilter);
        }
        request.source().version(Boolean.valueOf(true));
        try {
            return this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request with scroll: " + request.toString(), e);
        }
    }

    private SearchResponse doScroll(SearchRequest request, SearchQuery searchQuery) {
        Assert.notNull(searchQuery.getIndices(), (String)"No index defined for Query");
        Assert.notNull(searchQuery.getTypes(), (String)"No type define for Query");
        Assert.notNull((Object)searchQuery.getPageable(), (String)"Query.pageable is required for scan & scroll");
        if (searchQuery.getQuery() != null) {
            request.source().query(searchQuery.getQuery());
        } else {
            request.source().query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (searchQuery.getFilter() != null) {
            request.source().postFilter(searchQuery.getFilter());
        }
        request.source().version(Boolean.valueOf(true));
        if (!CollectionUtils.isEmpty(searchQuery.getElasticsearchSorts())) {
            for (SortBuilder sort : searchQuery.getElasticsearchSorts()) {
                request.source().sort(sort);
            }
        }
        try {
            return this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request with scroll: " + request.toString(), e);
        }
    }

    @Override
    public <T> ScrolledPage<T> startScroll(long scrollTimeInMillis, SearchQuery searchQuery, Class<T> clazz) {
        SearchResponse response = this.doScroll(this.prepareScroll((Query)searchQuery, scrollTimeInMillis, clazz), searchQuery);
        return this.resultsMapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> ScrolledPage<T> startScroll(long scrollTimeInMillis, CriteriaQuery criteriaQuery, Class<T> clazz) {
        SearchResponse response = this.doScroll(this.prepareScroll((Query)criteriaQuery, scrollTimeInMillis, clazz), criteriaQuery);
        return this.resultsMapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> ScrolledPage<T> startScroll(long scrollTimeInMillis, SearchQuery searchQuery, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.doScroll(this.prepareScroll((Query)searchQuery, scrollTimeInMillis, clazz), searchQuery);
        return mapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> ScrolledPage<T> startScroll(long scrollTimeInMillis, CriteriaQuery criteriaQuery, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.doScroll(this.prepareScroll((Query)criteriaQuery, scrollTimeInMillis, clazz), criteriaQuery);
        return mapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> ScrolledPage<T> continueScroll(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz) {
        SearchResponse response;
        SearchScrollRequest request = new SearchScrollRequest(scrollId);
        request.scroll(TimeValue.timeValueMillis((long)scrollTimeInMillis));
        try {
            response = this.client.searchScroll(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request with scroll: " + request.toString(), e);
        }
        return this.resultsMapper.mapResults(response, clazz, Pageable.unpaged());
    }

    @Override
    public <T> ScrolledPage<T> continueScroll(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response;
        SearchScrollRequest request = new SearchScrollRequest(scrollId);
        request.scroll(TimeValue.timeValueMillis((long)scrollTimeInMillis));
        try {
            response = this.client.searchScroll(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request with scroll: " + request.toString(), e);
        }
        return mapper.mapResults(response, clazz, Pageable.unpaged());
    }

    @Override
    public void clearScroll(String scrollId) {
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(scrollId);
        try {
            ClearScrollResponse clearScrollResponse = this.client.clearScroll(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request with scroll: " + request.toString(), e);
        }
    }

    @Override
    public <T> Page<T> moreLikeThis(MoreLikeThisQuery query, Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        String indexName = StringUtils.hasText((String)query.getIndexName()) ? query.getIndexName() : persistentEntity.getIndexName();
        String type = StringUtils.hasText((String)query.getType()) ? query.getType() : persistentEntity.getIndexType();
        Assert.notNull((Object)indexName, (String)"No 'indexName' defined for MoreLikeThisQuery");
        Assert.notNull((Object)type, (String)"No 'type' defined for MoreLikeThisQuery");
        Assert.notNull((Object)query.getId(), (String)"No document id defined for MoreLikeThisQuery");
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery((MoreLikeThisQueryBuilder.Item[])ElasticsearchRestTemplate.toArray(new MoreLikeThisQueryBuilder.Item(indexName, type, query.getId())));
        if (query.getMinTermFreq() != null) {
            moreLikeThisQueryBuilder.minTermFreq(query.getMinTermFreq().intValue());
        }
        if (query.getMaxQueryTerms() != null) {
            moreLikeThisQueryBuilder.maxQueryTerms(query.getMaxQueryTerms().intValue());
        }
        if (!CollectionUtils.isEmpty(query.getStopWords())) {
            moreLikeThisQueryBuilder.stopWords(ElasticsearchRestTemplate.toArray(query.getStopWords()));
        }
        if (query.getMinDocFreq() != null) {
            moreLikeThisQueryBuilder.minDocFreq(query.getMinDocFreq().intValue());
        }
        if (query.getMaxDocFreq() != null) {
            moreLikeThisQueryBuilder.maxDocFreq(query.getMaxDocFreq().intValue());
        }
        if (query.getMinWordLen() != null) {
            moreLikeThisQueryBuilder.minWordLength(query.getMinWordLen().intValue());
        }
        if (query.getMaxWordLen() != null) {
            moreLikeThisQueryBuilder.maxWordLength(query.getMaxWordLen().intValue());
        }
        if (query.getBoostTerms() != null) {
            moreLikeThisQueryBuilder.boostTerms(query.getBoostTerms().floatValue());
        }
        return this.queryForPage((SearchQuery)new NativeSearchQueryBuilder().withQuery((QueryBuilder)moreLikeThisQueryBuilder).build(), (Class)clazz);
    }

    private SearchResponse doSearch(SearchRequest searchRequest, SearchQuery searchQuery) {
        this.prepareSearch(searchRequest, searchQuery);
        try {
            return this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for search request with scroll: " + searchRequest.toString(), e);
        }
    }

    private SearchRequest prepareSearch(SearchRequest searchRequest, SearchQuery searchQuery) {
        if (searchQuery.getFilter() != null) {
            searchRequest.source().postFilter(searchQuery.getFilter());
        }
        if (!CollectionUtils.isEmpty(searchQuery.getElasticsearchSorts())) {
            for (SortBuilder sortBuilder : searchQuery.getElasticsearchSorts()) {
                searchRequest.source().sort(sortBuilder);
            }
        }
        if (!searchQuery.getScriptFields().isEmpty()) {
            for (ScriptField scriptField : searchQuery.getScriptFields()) {
                searchRequest.source().scriptField(scriptField.fieldName(), scriptField.script());
            }
        }
        if (searchQuery.getCollapseBuilder() != null) {
            searchRequest.source().collapse(searchQuery.getCollapseBuilder());
        }
        if (searchQuery.getHighlightFields() != null || searchQuery.getHighlightBuilder() != null) {
            HighlightBuilder highlightBuilder = searchQuery.getHighlightBuilder();
            if (highlightBuilder == null) {
                highlightBuilder = new HighlightBuilder();
            }
            if (searchQuery.getHighlightFields() != null) {
                for (HighlightBuilder.Field highlightField : searchQuery.getHighlightFields()) {
                    highlightBuilder.field(highlightField);
                }
            }
            searchRequest.source().highlighter(highlightBuilder);
        }
        if (!CollectionUtils.isEmpty(searchQuery.getIndicesBoost())) {
            for (IndexBoost indexBoost : searchQuery.getIndicesBoost()) {
                searchRequest.source().indexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!CollectionUtils.isEmpty(searchQuery.getAggregations())) {
            for (AbstractAggregationBuilder abstractAggregationBuilder : searchQuery.getAggregations()) {
                searchRequest.source().aggregation((AggregationBuilder)abstractAggregationBuilder);
            }
        }
        if (!CollectionUtils.isEmpty(searchQuery.getFacets())) {
            for (FacetRequest facetRequest : searchQuery.getFacets()) {
                searchRequest.source().aggregation((AggregationBuilder)facetRequest.getFacet());
            }
        }
        return searchRequest;
    }

    private SearchResponse getSearchResponse(ActionFuture<SearchResponse> response) {
        return this.searchTimeout == null ? (SearchResponse)response.actionGet() : (SearchResponse)response.actionGet(this.searchTimeout);
    }

    private <T> boolean createIndexIfNotCreated(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName()) || this.createIndexWithSettings(clazz);
    }

    private <T> boolean createIndexWithSettings(Class<T> clazz) {
        if (clazz.isAnnotationPresent(Setting.class)) {
            String settingPath = clazz.getAnnotation(Setting.class).settingPath();
            if (StringUtils.hasText((String)settingPath)) {
                String settings = ResourceUtil.readFileFromClasspath(settingPath);
                if (StringUtils.hasText((String)settings)) {
                    return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), (Object)settings);
                }
            } else {
                logger.info("settingPath in @Setting has to be defined. Using default instead.");
            }
        }
        return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), (Object)this.getDefaultSettings(this.getPersistentEntityFor(clazz)));
    }

    @Override
    public boolean createIndex(String indexName, Object settings) {
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        if (settings instanceof String) {
            request.settings(String.valueOf(settings), Requests.INDEX_CONTENT_TYPE);
        } else if (settings instanceof Map) {
            request.settings((Map)settings);
        } else if (settings instanceof XContentBuilder) {
            request.settings((XContentBuilder)settings);
        }
        try {
            return this.client.indices().create(request, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error for creating index: " + request.toString(), e);
        }
    }

    @Override
    public <T> boolean createIndex(Class<T> clazz, Object settings) {
        return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), settings);
    }

    private <T> Map getDefaultSettings(ElasticsearchPersistentEntity<T> persistentEntity) {
        if (persistentEntity.isUseServerConfiguration()) {
            return new HashMap();
        }
        return new MapBuilder().put((Object)"index.number_of_shards", (Object)String.valueOf(persistentEntity.getShards())).put((Object)"index.number_of_replicas", (Object)String.valueOf(persistentEntity.getReplicas())).put((Object)"index.refresh_interval", (Object)persistentEntity.getRefreshInterval()).put((Object)"index.store.type", (Object)persistentEntity.getIndexStoreType()).map();
    }

    public <T> Map getSetting(Class<T> clazz) {
        return this.getSetting(this.getPersistentEntityFor(clazz).getIndexName());
    }

    public Map getSetting(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for getSettings");
        ObjectMapper objMapper = new ObjectMapper();
        Map<String, String> settings = null;
        RestClient restClient = this.client.getLowLevelClient();
        try {
            Response response = restClient.performRequest("GET", "/" + indexName + "/_settings", new Header[0]);
            settings = this.convertSettingResponse(EntityUtils.toString((HttpEntity)response.getEntity()), indexName);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Error while getting settings for indexName : " + indexName, e);
        }
        return settings;
    }

    private Map<String, String> convertSettingResponse(String settingResponse, String indexName) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Settings settings = Settings.fromXContent((XContentParser)XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, settingResponse));
            String prefix = indexName + ".settings.";
            HashMap<String, String> result = new HashMap<String, String>();
            Set keySet = settings.keySet();
            for (String key : keySet) {
                result.put(key.substring(prefix.length()), settings.get(key));
            }
            return result;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Could not map alias response : " + settingResponse, e);
        }
    }

    private <T> SearchRequest prepareSearch(Query query, Class<T> clazz) {
        this.setPersistentEntityIndexAndType(query, clazz);
        return this.prepareSearch(query, Optional.empty(), clazz);
    }

    private <T> SearchRequest prepareSearch(SearchQuery query, Class<T> clazz) {
        this.setPersistentEntityIndexAndType(query, clazz);
        return this.prepareSearch(query, Optional.ofNullable(query.getQuery()), clazz);
    }

    private SearchRequest prepareSearch(Query query, Optional<QueryBuilder> builder, @Nullable Class<?> clazz) {
        Assert.notNull(query.getIndices(), (String)"No index defined for Query");
        Assert.notNull(query.getTypes(), (String)"No type defined for Query");
        int startRecord = 0;
        SearchRequest request = new SearchRequest(ElasticsearchRestTemplate.toArray(query.getIndices()));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        request.types(ElasticsearchRestTemplate.toArray(query.getTypes()));
        sourceBuilder.version(Boolean.valueOf(true));
        sourceBuilder.trackScores(query.getTrackScores());
        if (builder.isPresent()) {
            sourceBuilder.query(builder.get());
        }
        if (query.getSourceFilter() != null) {
            SourceFilter sourceFilter = query.getSourceFilter();
            sourceBuilder.fetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (query.getPageable().isPaged()) {
            startRecord = query.getPageable().getPageNumber() * query.getPageable().getPageSize();
            sourceBuilder.size(query.getPageable().getPageSize());
        }
        sourceBuilder.from(startRecord);
        if (!query.getFields().isEmpty()) {
            sourceBuilder.fetchSource(ElasticsearchRestTemplate.toArray(query.getFields()), null);
        }
        if (query.getIndicesOptions() != null) {
            request.indicesOptions(query.getIndicesOptions());
        }
        if (query.getSort() != null) {
            this.prepareSort(query, sourceBuilder, this.getPersistentEntity(clazz));
        }
        if (query.getMinScore() > 0.0f) {
            sourceBuilder.minScore(query.getMinScore());
        }
        if (query.getPreference() != null) {
            request.preference(query.getPreference());
        }
        if (query.getSearchType() != null) {
            request.searchType(query.getSearchType());
        }
        request.source(sourceBuilder);
        return request;
    }

    private void prepareSort(Query query, SearchSourceBuilder sourceBuilder, @Nullable ElasticsearchPersistentEntity<?> entity) {
        for (Sort.Order order : query.getSort()) {
            ElasticsearchPersistentProperty property = entity != null ? (ElasticsearchPersistentProperty)entity.getPersistentProperty(order.getProperty()) : null;
            String fieldName = property != null ? property.getFieldName() : order.getProperty();
            FieldSortBuilder sort = (FieldSortBuilder)SortBuilders.fieldSort((String)fieldName).order(order.getDirection().isDescending() ? SortOrder.DESC : SortOrder.ASC);
            if (order.getNullHandling() == Sort.NullHandling.NULLS_FIRST) {
                sort.missing((Object)"_first");
            } else if (order.getNullHandling() == Sort.NullHandling.NULLS_LAST) {
                sort.missing((Object)"_last");
            }
            sourceBuilder.sort((SortBuilder)sort);
        }
    }

    private IndexRequest prepareIndex(IndexQuery query) {
        try {
            String indexName = StringUtils.isEmpty((Object)query.getIndexName()) ? this.retrieveIndexNameFromPersistentEntity(query.getObject().getClass())[0] : query.getIndexName();
            String type = StringUtils.isEmpty((Object)query.getType()) ? this.retrieveTypeFromPersistentEntity(query.getObject().getClass())[0] : query.getType();
            IndexRequest indexRequest = null;
            if (query.getObject() != null) {
                String id = StringUtils.isEmpty((Object)query.getId()) ? this.getPersistentEntityId(query.getObject()) : query.getId();
                indexRequest = id != null ? new IndexRequest(indexName, type, id) : new IndexRequest(indexName, type);
                indexRequest.source(this.resultsMapper.getEntityMapper().mapToString(query.getObject()), Requests.INDEX_CONTENT_TYPE);
            } else if (query.getSource() != null) {
                indexRequest = new IndexRequest(indexName, type, query.getId()).source(query.getSource(), Requests.INDEX_CONTENT_TYPE);
            } else {
                throw new ElasticsearchException("object or source is null, failed to index the document [id: " + query.getId() + "]");
            }
            if (query.getVersion() != null) {
                indexRequest.version(query.getVersion().longValue());
                VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(query.getObject().getClass());
                indexRequest.versionType(versionType);
            }
            if (query.getParentId() != null) {
                indexRequest.parent(query.getParentId());
            }
            return indexRequest;
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to index the document [id: " + query.getId() + "]", e);
        }
    }

    @Override
    public void refresh(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for refresh()");
        try {
            this.client.indices().refresh(Requests.refreshRequest((String[])new String[]{indexName}), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to refresh index: " + indexName, e);
        }
    }

    @Override
    public <T> void refresh(Class<T> clazz) {
        this.refresh(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public List<AliasMetaData> queryForAlias(String indexName) {
        String aliasResponse;
        Object aliases = null;
        RestClient restClient = this.client.getLowLevelClient();
        try {
            Response response = restClient.performRequest("GET", "/" + indexName + "/_alias/*", new Header[0]);
            aliasResponse = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            throw new ElasticsearchException("Error while getting mapping for indexName : " + indexName, e);
        }
        return this.convertAliasResponse(aliasResponse);
    }

    private List<AliasMetaData> convertAliasResponse(String aliasResponse) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(aliasResponse);
            Iterator names = node.fieldNames();
            String name = (String)names.next();
            node = node.findValue("aliases");
            Map aliasData = (Map)mapper.readValue(mapper.writeValueAsString((Object)node), (TypeReference)new TypeReference<Map<String, AliasData>>(){});
            Set aliasIter = aliasData.entrySet();
            ArrayList<AliasMetaData> aliasMetaDataList = new ArrayList<AliasMetaData>();
            for (Map.Entry entry : aliasIter) {
                AliasData data = (AliasData)entry.getValue();
                aliasMetaDataList.add(AliasMetaData.newAliasMetaDataBuilder((String)((String)entry.getKey())).filter(data.getFilter()).routing(data.getRouting()).searchRouting(data.getSearch_routing()).indexRouting(data.getIndex_routing()).build());
            }
            return aliasMetaDataList;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Could not map alias response : " + aliasResponse, e);
        }
    }

    @Nullable
    private ElasticsearchPersistentEntity<?> getPersistentEntity(@Nullable Class<?> clazz) {
        return clazz != null ? (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(clazz) : null;
    }

    @Override
    public ElasticsearchPersistentEntity getPersistentEntityFor(Class clazz) {
        Assert.isTrue((boolean)clazz.isAnnotationPresent(Document.class), (String)("Unable to identify index name. " + clazz.getSimpleName() + " is not a Document. Make sure the document class is annotated with @Document(indexName=\"foo\")"));
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    private String getPersistentEntityId(Object entity) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(entity.getClass());
        Object identifier = persistentEntity.getIdentifierAccessor(entity).getIdentifier();
        if (identifier != null) {
            return identifier.toString();
        }
        return null;
    }

    private void setPersistentEntityId(Object entity, String id) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(entity.getClass());
        ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
            persistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)idProperty, (Object)id);
        }
    }

    private void setPersistentEntityIndexAndType(Query query, Class clazz) {
        if (query.getIndices().isEmpty()) {
            query.addIndices(this.retrieveIndexNameFromPersistentEntity(clazz));
        }
        if (query.getTypes().isEmpty()) {
            query.addTypes(this.retrieveTypeFromPersistentEntity(clazz));
        }
    }

    private String[] retrieveIndexNameFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return new String[]{this.getPersistentEntityFor(clazz).getIndexName()};
        }
        return null;
    }

    private String[] retrieveTypeFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return new String[]{this.getPersistentEntityFor(clazz).getIndexType()};
        }
        return null;
    }

    private VersionType retrieveVersionTypeFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return this.getPersistentEntityFor(clazz).getVersionType();
        }
        return VersionType.EXTERNAL;
    }

    private List<String> extractIds(SearchResponse response) {
        ArrayList<String> ids = new ArrayList<String>();
        for (SearchHit hit : response.getHits()) {
            if (hit == null) continue;
            ids.add(hit.getId());
        }
        return ids;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (this.elasticsearchConverter instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.elasticsearchConverter).setApplicationContext(context);
        }
    }

    private static String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }

    private static MoreLikeThisQueryBuilder.Item[] toArray(MoreLikeThisQueryBuilder.Item ... values) {
        return values;
    }

    protected ResultsMapper getResultsMapper() {
        return this.resultsMapper;
    }

    @Deprecated
    public static String readFileFromClasspath(String url) {
        return ResourceUtil.readFileFromClasspath(url);
    }

    public SearchResponse suggest(SuggestBuilder suggestion, String ... indices) {
        SearchRequest searchRequest = new SearchRequest(indices);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.suggest(suggestion);
        searchRequest.source(sourceBuilder);
        try {
            return this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Could not execute search request : " + searchRequest.toString(), e);
        }
    }

    public SearchResponse suggest(SuggestBuilder suggestion, Class clazz) {
        return this.suggest(suggestion, this.retrieveIndexNameFromPersistentEntity(clazz));
    }
}

