/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.datasource.ConfigProperty;
import com.gemstone.gemfire.internal.jndi.JNDIInvoker;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.gemfire.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireSystemException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class CacheFactoryBean
implements BeanNameAware,
BeanFactoryAware,
BeanClassLoaderAware,
DisposableBean,
InitializingBean,
FactoryBean<GemFireCache>,
PersistenceExceptionTranslator {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected GemFireCache cache;
    protected Resource cacheXml;
    protected Properties properties;
    protected ClassLoader beanClassLoader;
    protected GemfireBeanFactoryLocator factoryLocator;
    protected BeanFactory beanFactory;
    protected String beanName;
    protected boolean useBeanFactoryLocator = true;
    protected Object pdxSerializer;
    protected Boolean pdxPersistent;
    protected Boolean pdxReadSerialized;
    protected Boolean pdxIgnoreUnreadFields;
    protected String pdxDiskStoreName;
    protected Boolean copyOnRead;
    protected Integer lockTimeout;
    protected Integer lockLease;
    protected Integer messageSyncInterval;
    protected Integer searchTimeout;
    protected List<TransactionListener> transactionListeners;
    protected TransactionWriter transactionWriter;
    protected Float evictionHeapPercentage;
    protected Float criticalHeapPercentage;
    protected DynamicRegionSupport dynamicRegionSupport;
    protected List<JndiDataSource> jndiDataSources;
    protected Object gatewayConflictResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.useBeanFactoryLocator) {
            this.factoryLocator = new GemfireBeanFactoryLocator();
            this.factoryLocator.setBeanFactory(this.beanFactory);
            this.factoryLocator.setBeanName(this.beanName);
            this.factoryLocator.afterPropertiesSet();
        }
        Properties cfgProps = this.mergeProperties();
        Thread th = Thread.currentThread();
        ClassLoader oldTCCL = th.getContextClassLoader();
        try {
            th.setContextClassLoader(this.beanClassLoader);
            String msg = null;
            try {
                this.cache = this.fetchCache();
                msg = "Retrieved existing";
            }
            catch (CacheClosedException ex) {
                this.initializeDynamicRegionFactory();
                Object factory = this.createFactory(cfgProps);
                if (this.pdxSerializer != null || this.pdxPersistent != null || this.pdxReadSerialized != null || this.pdxIgnoreUnreadFields != null || this.pdxDiskStoreName != null) {
                    Assert.isTrue((boolean)ClassUtils.isPresent((String)"com.gemstone.gemfire.pdx.PdxSerializer", (ClassLoader)this.beanClassLoader), (String)"Cannot set PDX options since GemFire 6.6 not detected");
                    this.applyPdxOptions(factory);
                }
                this.cache = this.createCache(factory);
                msg = "Created";
            }
            if (this.copyOnRead != null) {
                this.cache.setCopyOnRead(this.copyOnRead.booleanValue());
            }
            this.applyInternalCacheOptions();
            DistributedSystem system = this.cache.getDistributedSystem();
            DistributedMember member = system.getDistributedMember();
            this.log.info((Object)("Connected to Distributed System [" + system.getName() + "=" + member.getId() + "@" + member.getHost() + "]"));
            this.log.info((Object)(msg + " GemFire v." + CacheFactory.getVersion() + " Cache [" + this.cache.getName() + "]"));
            if (this.cacheXml != null) {
                this.cache.loadCacheXml(this.cacheXml.getInputStream());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Initialized cache from " + this.cacheXml));
                }
            }
            this.setHeapPercentages();
            this.registerTransactionListeners();
            this.registerTransactionWriter();
            this.registerJndiDataSources();
        }
        finally {
            th.setContextClassLoader(oldTCCL);
        }
    }

    private void registerJndiDataSources() {
        if (this.jndiDataSources != null) {
            for (JndiDataSource jndiDataSource : this.jndiDataSources) {
                JNDIInvoker.mapDatasource(jndiDataSource.getAttributes(), jndiDataSource.getProps());
            }
        }
    }

    private void initializeDynamicRegionFactory() {
        if (this.dynamicRegionSupport != null) {
            this.dynamicRegionSupport.initializeDynamicRegionFactory();
        }
    }

    private void setHeapPercentages() {
        if (this.criticalHeapPercentage != null) {
            Assert.isTrue(((double)this.criticalHeapPercentage.floatValue() > 0.0 && (double)this.criticalHeapPercentage.floatValue() <= 100.0 ? 1 : 0) != 0, (String)("invalid value specified for criticalHeapPercentage :" + this.criticalHeapPercentage + ". Must be > 0.0 and <= 100.0"));
            this.cache.getResourceManager().setCriticalHeapPercentage(this.criticalHeapPercentage.floatValue());
        }
        if (this.evictionHeapPercentage != null) {
            Assert.isTrue(((double)this.evictionHeapPercentage.floatValue() > 0.0 && (double)this.evictionHeapPercentage.floatValue() <= 100.0 ? 1 : 0) != 0, (String)("invalid value specified for evictionHeapPercentage :" + this.evictionHeapPercentage + ". Must be > 0.0 and <= 100.0"));
            this.cache.getResourceManager().setEvictionHeapPercentage(this.evictionHeapPercentage.floatValue());
        }
    }

    protected void registerTransactionWriter() {
        if (this.transactionWriter != null) {
            this.cache.getCacheTransactionManager().setWriter(this.transactionWriter);
        }
    }

    protected void registerTransactionListeners() {
        if (!CollectionUtils.isEmpty(this.transactionListeners)) {
            CacheTransactionManager txManager = this.cache.getCacheTransactionManager();
            for (TransactionListener transactionListener : this.transactionListeners) {
                txManager.addListener(transactionListener);
            }
        }
    }

    protected void applyPdxOptions(Object factory) {
        if (factory instanceof CacheFactory) {
            new PdxOptions((CacheFactory)factory).run();
        }
    }

    protected void applyInternalCacheOptions() {
        new InternalCacheOptions(this.cache).run();
    }

    protected Object createFactory(Properties props) {
        return new CacheFactory(props);
    }

    protected GemFireCache fetchCache() {
        return CacheFactory.getAnyInstance();
    }

    protected GemFireCache createCache(Object factory) {
        return ((CacheFactory)factory).create();
    }

    protected Properties mergeProperties() {
        Properties cfgProps = this.properties != null ? (Properties)this.properties.clone() : new Properties();
        return cfgProps;
    }

    public void destroy() throws Exception {
        if (this.cache != null && !this.cache.isClosed()) {
            this.cache.close();
        }
        this.cache = null;
        if (this.factoryLocator != null) {
            this.factoryLocator.destroy();
            this.factoryLocator = null;
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        DataAccessException wrapped;
        if (ex instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)ex);
        }
        if (ex instanceof IllegalArgumentException && !((wrapped = GemfireCacheUtils.convertQueryExceptions(ex)) instanceof GemfireSystemException)) {
            return wrapped;
        }
        if (ex.getCause() instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)ex.getCause());
        }
        if (ex.getCause() instanceof GemFireCheckedException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireCheckedException)ex.getCause());
        }
        return null;
    }

    public GemFireCache getObject() throws Exception {
        return this.cache;
    }

    public Class<? extends GemFireCache> getObjectType() {
        return this.cache != null ? this.cache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setCacheXml(Resource cacheXml) {
        this.cacheXml = cacheXml;
    }

    public void setUseBeanFactoryLocator(boolean usage) {
        this.useBeanFactoryLocator = usage;
    }

    public void setPdxSerializer(Object serializer) {
        this.pdxSerializer = serializer;
    }

    public void setPdxPersistent(Boolean pdxPersistent) {
        this.pdxPersistent = pdxPersistent;
    }

    public void setPdxReadSerialized(Boolean pdxReadSerialized) {
        this.pdxReadSerialized = pdxReadSerialized;
    }

    public void setPdxIgnoreUnreadFields(Boolean pdxIgnoreUnreadFields) {
        this.pdxIgnoreUnreadFields = pdxIgnoreUnreadFields;
    }

    public void setPdxDiskStoreName(String pdxDiskStoreName) {
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public void setLockLease(int lockLease) {
        this.lockLease = lockLease;
    }

    public void setMessageSyncInterval(int messageSyncInterval) {
        this.messageSyncInterval = messageSyncInterval;
    }

    public void setSearchTimeout(int searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    public void setEvictionHeapPercentage(Float evictionHeapPercentage) {
        this.evictionHeapPercentage = evictionHeapPercentage;
    }

    public void setCriticalHeapPercentage(Float criticalHeapPercentage) {
        this.criticalHeapPercentage = criticalHeapPercentage;
    }

    public void setTransactionListeners(List<TransactionListener> transactionListeners) {
        this.transactionListeners = transactionListeners;
    }

    public void setTransactionWriter(TransactionWriter transactionWriter) {
        this.transactionWriter = transactionWriter;
    }

    public void setGatewayConflictResolver(Object gatewayConflictResolver) {
        this.gatewayConflictResolver = gatewayConflictResolver;
    }

    public void setDynamicRegionSupport(DynamicRegionSupport dynamicRegionSupport) {
        this.dynamicRegionSupport = dynamicRegionSupport;
    }

    public void setJndiDataSources(List<JndiDataSource> jndiDataSources) {
        this.jndiDataSources = jndiDataSources;
    }

    public static class JndiDataSource {
        private Map<String, String> attributes;
        private List<ConfigProperty> props;

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public List<ConfigProperty> getProps() {
            return this.props;
        }

        public void setProps(List<ConfigProperty> props) {
            this.props = props;
        }
    }

    public static class DynamicRegionSupport {
        private String diskDir;
        private String poolName;
        private Boolean persistent = Boolean.TRUE;
        private Boolean registerInterest = Boolean.TRUE;

        public String getDiskDir() {
            return this.diskDir;
        }

        public void setDiskDir(String diskDir) {
            this.diskDir = diskDir;
        }

        public Boolean getPersistent() {
            return this.persistent;
        }

        public void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public Boolean getRegisterInterest() {
            return this.registerInterest;
        }

        public void setRegisterInterest(Boolean registerInterest) {
            this.registerInterest = registerInterest;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public void initializeDynamicRegionFactory() {
            DynamicRegionFactory.Config config = null;
            config = this.diskDir == null ? new DynamicRegionFactory.Config(null, this.poolName, this.persistent.booleanValue(), this.registerInterest.booleanValue()) : new DynamicRegionFactory.Config(new File(this.diskDir), this.poolName, this.persistent.booleanValue(), this.registerInterest.booleanValue());
            DynamicRegionFactory.get().open(config);
        }
    }

    private class InternalCacheOptions
    implements Runnable {
        private final GemFireCacheImpl cacheImpl;

        InternalCacheOptions(GemFireCache cache) {
            this.cacheImpl = (GemFireCacheImpl)cache;
        }

        @Override
        public void run() {
            if (CacheFactoryBean.this.lockLease != null) {
                this.cacheImpl.setLockLease(CacheFactoryBean.this.lockLease.intValue());
            }
            if (CacheFactoryBean.this.lockTimeout != null) {
                this.cacheImpl.setLockTimeout(CacheFactoryBean.this.lockTimeout.intValue());
            }
            if (CacheFactoryBean.this.searchTimeout != null) {
                this.cacheImpl.setSearchTimeout(CacheFactoryBean.this.searchTimeout.intValue());
            }
            if (CacheFactoryBean.this.messageSyncInterval != null) {
                this.cacheImpl.setMessageSyncInterval(CacheFactoryBean.this.messageSyncInterval.intValue());
            }
            if (CacheFactoryBean.this.gatewayConflictResolver != null) {
                this.cacheImpl.setGatewayConflictResolver((GatewayConflictResolver)CacheFactoryBean.this.gatewayConflictResolver);
            }
        }
    }

    private class PdxOptions
    implements Runnable {
        private final CacheFactory factory;

        PdxOptions(CacheFactory factory) {
            this.factory = factory;
        }

        @Override
        public void run() {
            if (CacheFactoryBean.this.pdxSerializer != null) {
                Assert.isAssignable(PdxSerializer.class, CacheFactoryBean.this.pdxSerializer.getClass(), (String)"Invalid pdx serializer used");
                this.factory.setPdxSerializer((PdxSerializer)CacheFactoryBean.this.pdxSerializer);
            }
            if (CacheFactoryBean.this.pdxDiskStoreName != null) {
                this.factory.setPdxDiskStore(CacheFactoryBean.this.pdxDiskStoreName);
            }
            if (CacheFactoryBean.this.pdxIgnoreUnreadFields != null) {
                this.factory.setPdxIgnoreUnreadFields(CacheFactoryBean.this.pdxIgnoreUnreadFields.booleanValue());
            }
            if (CacheFactoryBean.this.pdxPersistent != null) {
                this.factory.setPdxPersistent(CacheFactoryBean.this.pdxPersistent.booleanValue());
            }
            if (CacheFactoryBean.this.pdxReadSerialized != null) {
                this.factory.setPdxReadSerialized(CacheFactoryBean.this.pdxReadSerialized.booleanValue());
            }
        }
    }
}

