/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.DataPolicy;
import org.springframework.core.convert.converter.Converter;

public class DataPolicyConverter
implements Converter<String, DataPolicy> {
    public DataPolicy convert(String source) {
        if (source == null) {
            return null;
        }
        return Policy.getValue(source = source.toUpperCase()) == null ? null : Policy.getValue(source).toDataPolicy();
    }

    private static enum Policy {
        EMPTY,
        DEFAULT,
        NORMAL,
        PERSISTENT_PARTITION,
        PERSISTENT_REPLICATE,
        PRELOADED,
        REPLICATE;


        public DataPolicy toDataPolicy() {
            DataPolicy dataPolicy = null;
            switch (this) {
                case EMPTY: {
                    dataPolicy = DataPolicy.EMPTY;
                    break;
                }
                case DEFAULT: {
                    dataPolicy = DataPolicy.DEFAULT;
                    break;
                }
                case NORMAL: {
                    dataPolicy = DataPolicy.NORMAL;
                    break;
                }
                case PERSISTENT_PARTITION: {
                    dataPolicy = DataPolicy.PERSISTENT_PARTITION;
                    break;
                }
                case PERSISTENT_REPLICATE: {
                    dataPolicy = DataPolicy.PERSISTENT_REPLICATE;
                    break;
                }
                case PRELOADED: {
                    dataPolicy = DataPolicy.PRELOADED;
                    break;
                }
                case REPLICATE: {
                    dataPolicy = DataPolicy.REPLICATE;
                }
            }
            return dataPolicy;
        }

        public static Policy getValue(String value) {
            Policy policy = null;
            try {
                policy = Policy.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return policy;
        }
    }
}

