/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.wan.GatewayHubFactoryBean;
import org.springframework.data.gemfire.wan.GatewayProxy;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class GatewayHubParser
extends AbstractSimpleBeanDefinitionParser {
    GatewayHubParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return GatewayHubFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setLazyInit(false);
        String cacheRef = element.getAttribute("cache-ref");
        builder.addConstructorArgReference(StringUtils.hasText((String)cacheRef) ? cacheRef : "gemfireCache");
        ParsingUtils.setPropertyValue(element, builder, "bind-address");
        ParsingUtils.setPropertyValue(element, builder, "manual-start");
        ParsingUtils.setPropertyValue(element, builder, "socket-buffer-size");
        ParsingUtils.setPropertyValue(element, builder, "startup-policy");
        ParsingUtils.setPropertyValue(element, builder, "port");
        List gatewayElements = DomUtils.getChildElementsByTagName((Element)element, (String)"gateway");
        if (!CollectionUtils.isEmpty((Collection)gatewayElements)) {
            ManagedList gateways = new ManagedList();
            for (Element gatewayElement : gatewayElements) {
                Element gatewayQueueElement;
                Element gatewayListenerElement;
                BeanDefinitionBuilder gatewayBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewayProxy.class);
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "gateway-id", "id");
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "concurrency-level");
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "socket-read-timeout");
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "socket-buffer-size");
                ParsingUtils.setPropertyValue(gatewayElement, gatewayBuilder, "order-policy");
                List endpointElements = DomUtils.getChildElementsByTagName((Element)gatewayElement, (String)"gateway-endpoint");
                if (!CollectionUtils.isEmpty((Collection)endpointElements)) {
                    ManagedList endpoints = new ManagedList();
                    for (Element endpointElement : endpointElements) {
                        BeanDefinitionBuilder endpointBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewayProxy.GatewayEndpoint.class);
                        ParsingUtils.setPropertyValue(endpointElement, endpointBuilder, "host");
                        ParsingUtils.setPropertyValue(endpointElement, endpointBuilder, "port");
                        ParsingUtils.setPropertyValue(endpointElement, endpointBuilder, "endpoint-id", "id");
                        endpoints.add((Object)endpointBuilder.getBeanDefinition());
                    }
                    gatewayBuilder.addPropertyValue("endpoints", (Object)endpoints);
                }
                if ((gatewayListenerElement = DomUtils.getChildElementByTagName((Element)gatewayElement, (String)"gateway-listener")) != null) {
                    Object obj = ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, gatewayListenerElement, gatewayBuilder);
                    gatewayBuilder.addPropertyValue("listeners", obj);
                }
                if ((gatewayQueueElement = DomUtils.getChildElementByTagName((Element)gatewayElement, (String)"gateway-queue")) != null) {
                    BeanDefinitionBuilder queueBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewayProxy.GatewayQueue.class);
                    ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "alert-threshold");
                    ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "batch-size");
                    ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "batch-time-interval");
                    ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "maximum-queue-memory");
                    ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "persistent");
                    ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "disk-store-ref");
                    if (gatewayQueueElement.hasAttribute("disk-store-ref")) {
                        gatewayBuilder.getBeanDefinition().setDependsOn(new String[]{gatewayQueueElement.getAttribute("disk-store-ref")});
                    }
                    ParsingUtils.setPropertyValue(gatewayQueueElement, queueBuilder, "enable-batch-conflation");
                    gatewayBuilder.addPropertyValue("queue", (Object)queueBuilder.getBeanDefinition());
                }
                gateways.add((Object)gatewayBuilder.getBeanDefinition());
            }
            builder.addPropertyValue("gateways", (Object)gateways);
        }
    }
}

