/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.config.AbstractRegionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class LookupRegionParser
extends AbstractRegionParser {
    LookupRegionParser() {
    }

    @Override
    protected void doParseRegion(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, boolean subRegion) {
        super.doParse(element, builder);
        ParsingUtils.setPropertyValue(element, builder, "name", "name");
        if (!subRegion) {
            String attr = element.getAttribute("cache-ref");
            builder.addPropertyReference("cache", StringUtils.hasText((String)attr) ? attr : "gemfireCache");
        } else {
            builder.addPropertyValue("lookupOnly", (Object)true);
        }
        List subElements = DomUtils.getChildElements((Element)element);
        for (Element subElement : subElements) {
            String name = subElement.getLocalName();
            if (!name.endsWith("region")) continue;
            this.doParseSubRegion(element, subElement, parserContext, builder, subRegion);
        }
    }

    @Override
    protected Class<?> getRegionFactoryClass() {
        return RegionLookupFactoryBean.class;
    }
}

