/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.FixedPartitionAttributesFactoryBean;
import org.springframework.data.gemfire.PartitionAttributesFactoryBean;
import org.springframework.data.gemfire.PartitionedRegionFactoryBean;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.config.AbstractRegionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class PartitionedRegionParser
extends AbstractRegionParser {
    PartitionedRegionParser() {
    }

    @Override
    protected Class<?> getRegionFactoryClass() {
        return PartitionedRegionFactoryBean.class;
    }

    @Override
    protected void doParseRegion(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, boolean subRegion) {
        List fixedPartitions;
        Element subElement;
        super.doParse(element, builder);
        BeanDefinitionBuilder attrBuilder = subRegion ? builder : BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
        super.doParseCommonRegionConfiguration(element, parserContext, builder, attrBuilder, subRegion);
        BeanDefinitionBuilder parAttrBuilder = BeanDefinitionBuilder.genericBeanDefinition(PartitionAttributesFactoryBean.class);
        String attr = element.getAttribute("colocated-with");
        if (StringUtils.hasText((String)attr)) {
            parAttrBuilder.addPropertyValue("colocatedWith", (Object)attr);
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("local-max-memory")))) {
            parAttrBuilder.addPropertyValue("localMaxMemory", (Object)Integer.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("copies")))) {
            parAttrBuilder.addPropertyValue("redundantCopies", (Object)Integer.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("recovery-delay")))) {
            parAttrBuilder.addPropertyValue("recoveryDelay", (Object)Long.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("startup-recovery-delay")))) {
            parAttrBuilder.addPropertyValue("startupRecoveryDelay", (Object)Long.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("total-max-memory")))) {
            parAttrBuilder.addPropertyValue("totalMaxMemory", (Object)Long.valueOf(attr));
        }
        if (StringUtils.hasText((String)(attr = element.getAttribute("total-buckets")))) {
            parAttrBuilder.addPropertyValue("totalNumBuckets", (Object)Integer.valueOf(attr));
        }
        if ((subElement = DomUtils.getChildElementByTagName((Element)element, (String)"partition-resolver")) != null) {
            parAttrBuilder.addPropertyValue("partitionResolver", this.parsePartitionResolver(parserContext, subElement, builder));
        }
        if ((subElement = DomUtils.getChildElementByTagName((Element)element, (String)"partition-listener")) != null) {
            parAttrBuilder.addPropertyValue("partitionListeners", this.parsePartitionListeners(parserContext, subElement, builder));
        }
        if (!CollectionUtils.isEmpty((Collection)(fixedPartitions = DomUtils.getChildElementsByTagName((Element)element, (String)"fixed-partition")))) {
            ManagedList fixedPartitionAttributes = new ManagedList();
            for (Element fp : fixedPartitions) {
                BeanDefinitionBuilder fpaBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixedPartitionAttributesFactoryBean.class);
                ParsingUtils.setPropertyValue(fp, fpaBuilder, "partition-name");
                ParsingUtils.setPropertyValue(fp, fpaBuilder, "num-buckets");
                ParsingUtils.setPropertyValue(fp, fpaBuilder, "primary");
                fixedPartitionAttributes.add((Object)fpaBuilder.getBeanDefinition());
            }
            parAttrBuilder.addPropertyValue("fixedPartitionAttributes", (Object)fixedPartitionAttributes);
        }
        attrBuilder.addPropertyValue("partitionAttributes", (Object)parAttrBuilder.getBeanDefinition());
        if (!subRegion) {
            builder.addPropertyValue("attributes", (Object)attrBuilder.getBeanDefinition());
        }
    }

    private Object parsePartitionResolver(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, subElement, builder);
    }

    private Object parsePartitionListeners(ParserContext parserContext, Element subElement, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }
}

