/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import com.gemstone.gemfire.cache.Region;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.repository.support.GemfireRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class GemfireRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> context;
    private Iterable<Region<?, ?>> regions;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection regions = applicationContext.getBeansOfType(Region.class).values();
        this.regions = Collections.unmodifiableCollection(regions);
    }

    public void setMappingContext(MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> context) {
        this.context = context;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return new GemfireRepositoryFactory(this.regions, this.context);
    }
}

