/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.client.RegexInterest;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ClientRegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements BeanFactoryAware,
DisposableBean {
    private static final Log log = LogFactory.getLog(ClientRegionFactoryBean.class);
    private boolean close = false;
    private boolean destroy = false;
    private BeanFactory beanFactory;
    private Boolean persistent;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private ClientRegionShortcut shortcut = null;
    private DataPolicy dataPolicy;
    private Interest<K>[] interests;
    private RegionAttributes<K, V> attributes;
    private Resource snapshot;
    private String diskStoreName;
    private String poolName;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.postProcess(this.getRegion());
    }

    @Override
    protected Region<K, V> lookupFallback(GemFireCache cache, String regionName) throws Exception {
        Region clientRegion;
        Assert.isTrue((boolean)(cache instanceof ClientCache), (String)String.format("Unable to create regions from %1$s", cache));
        if (cache instanceof GemFireCacheImpl) {
            Assert.isTrue((boolean)((GemFireCacheImpl)cache).isClient(), (String)"A client-cache instance is required.");
        }
        ClientCache clientCache = (ClientCache)cache;
        ClientRegionFactory factory = clientCache.createClientRegionFactory(this.resolveClientRegionShortcut());
        if (this.attributes != null) {
            factory.setCloningEnabled(this.attributes.getCloningEnabled());
            factory.setConcurrencyLevel(this.attributes.getConcurrencyLevel());
            factory.setCustomEntryIdleTimeout(this.attributes.getCustomEntryIdleTimeout());
            factory.setCustomEntryTimeToLive(this.attributes.getCustomEntryTimeToLive());
            factory.setDiskStoreName(this.attributes.getDiskStoreName());
            factory.setDiskSynchronous(this.attributes.isDiskSynchronous());
            factory.setEntryIdleTimeout(this.attributes.getEntryIdleTimeout());
            factory.setEntryTimeToLive(this.attributes.getEntryTimeToLive());
            factory.setEvictionAttributes(this.attributes.getEvictionAttributes());
            factory.setInitialCapacity(this.attributes.getInitialCapacity());
            factory.setKeyConstraint(this.attributes.getKeyConstraint());
            factory.setLoadFactor(this.attributes.getLoadFactor());
            factory.setPoolName(this.attributes.getPoolName());
            factory.setRegionIdleTimeout(this.attributes.getRegionIdleTimeout());
            factory.setRegionTimeToLive(this.attributes.getRegionTimeToLive());
            factory.setStatisticsEnabled(this.attributes.getStatisticsEnabled());
            factory.setValueConstraint(this.attributes.getValueConstraint());
        }
        this.addCacheListeners(factory);
        if (StringUtils.hasText((String)this.poolName)) {
            if (this.beanFactory.isTypeMatch(this.poolName, Pool.class)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found bean definition for pool '%1$s'. Eagerly initializing...", this.poolName));
                }
                this.beanFactory.getBean(this.poolName, Pool.class);
            }
            factory.setPoolName(this.poolName);
        } else {
            Pool pool = (Pool)this.beanFactory.getBean(Pool.class);
            factory.setPoolName(pool.getName());
        }
        if (this.diskStoreName != null) {
            factory.setDiskStoreName(this.diskStoreName);
        }
        Region region = clientRegion = this.getParent() != null ? factory.createSubregion(this.getParent(), regionName) : factory.create(regionName);
        if (log.isInfoEnabled()) {
            if (this.getParent() != null) {
                log.info((Object)String.format("Created new Client Cache sub-Region [%1$s] under parent Region [%2$s].", regionName, this.getParent().getName()));
            } else {
                log.info((Object)String.format("Created new Client Cache Region [%1$s].", regionName));
            }
        }
        if (this.snapshot != null) {
            clientRegion.loadSnapshot(this.snapshot.getInputStream());
        }
        return clientRegion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ClientRegionShortcut resolveClientRegionShortcut() {
        ClientRegionShortcut resolvedShortcut = this.shortcut;
        if (resolvedShortcut == null) {
            if (this.dataPolicy != null) {
                this.assertDataPolicyAndPersistentAttributeAreCompatible(this.dataPolicy);
                if (DataPolicy.EMPTY.equals(this.dataPolicy)) {
                    resolvedShortcut = ClientRegionShortcut.PROXY;
                } else if (DataPolicy.NORMAL.equals(this.dataPolicy)) {
                    resolvedShortcut = ClientRegionShortcut.CACHING_PROXY;
                } else {
                    if (!DataPolicy.PERSISTENT_REPLICATE.equals(this.dataPolicy)) throw new IllegalArgumentException(String.format("Data Policy '%1$s' is invalid for Client Regions.", this.dataPolicy));
                    resolvedShortcut = ClientRegionShortcut.LOCAL_PERSISTENT;
                }
            } else {
                resolvedShortcut = this.isPersistent() ? ClientRegionShortcut.LOCAL_PERSISTENT : ClientRegionShortcut.LOCAL;
            }
        }
        this.assertClientRegionShortcutAndPersistentAttributeAreCompatible(resolvedShortcut);
        return resolvedShortcut;
    }

    protected void assertClientRegionShortcutAndPersistentAttributeAreCompatible(ClientRegionShortcut resolvedShortcut) {
        boolean persistentNotSpecified;
        boolean bl = persistentNotSpecified = this.persistent == null;
        if (ClientRegionShortcut.LOCAL_PERSISTENT.equals((Object)resolvedShortcut) || ClientRegionShortcut.LOCAL_PERSISTENT_OVERFLOW.equals((Object)resolvedShortcut)) {
            Assert.isTrue((persistentNotSpecified || this.isPersistent() ? 1 : 0) != 0, (String)String.format("Client Region Shortcut '%1$s' is invalid when persistent is false.", resolvedShortcut));
        } else {
            Assert.isTrue((persistentNotSpecified || this.isNotPersistent() ? 1 : 0) != 0, (String)String.format("Client Region Shortcut '%1$s' is invalid when persistent is true.", resolvedShortcut));
        }
    }

    protected void assertDataPolicyAndPersistentAttributeAreCompatible(DataPolicy resolvedDataPolicy) {
        if (resolvedDataPolicy.withPersistence()) {
            Assert.isTrue((this.isPersistentUnspecified() || this.isPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy '%1$s' is invalid when persistent is false.", resolvedDataPolicy));
        } else {
            Assert.isTrue((this.isPersistentUnspecified() || this.isNotPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy '%1$s' is invalid when persistent is true.", resolvedDataPolicy));
        }
    }

    private void addCacheListeners(ClientRegionFactory<K, V> factory) {
        Object[] cacheListeners;
        if (this.attributes != null && !ObjectUtils.isEmpty((Object[])(cacheListeners = this.attributes.getCacheListeners()))) {
            for (Object cacheListener : cacheListeners) {
                factory.addCacheListener((CacheListener)cacheListener);
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.cacheListeners)) {
            for (CacheListener<K, V> cacheListener : this.cacheListeners) {
                factory.addCacheListener(cacheListener);
            }
        }
    }

    protected void postProcess(Region<K, V> region) {
        this.registerInterests(region);
        this.setCacheLoader(region);
        this.setCacheWriter(region);
    }

    private void registerInterests(Region<K, V> region) {
        if (!ObjectUtils.isEmpty((Object[])this.interests)) {
            for (Interest<K> interest : this.interests) {
                if (interest instanceof RegexInterest) {
                    region.registerInterestRegex((String)interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
                    continue;
                }
                region.registerInterest(interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
            }
        }
    }

    private void setCacheLoader(Region<K, V> region) {
        if (this.cacheLoader != null) {
            region.getAttributesMutator().setCacheLoader(this.cacheLoader);
        }
    }

    private void setCacheWriter(Region<K, V> region) {
        if (this.cacheWriter != null) {
            region.getAttributesMutator().setCacheWriter(this.cacheWriter);
        }
    }

    public void destroy() throws Exception {
        Region region = this.getObject();
        try {
            if (region != null && !ObjectUtils.isEmpty((Object[])this.interests)) {
                for (Interest<K> interest : this.interests) {
                    if (interest instanceof RegexInterest) {
                        region.unregisterInterestRegex((String)interest.getKey());
                        continue;
                    }
                    region.unregisterInterest(interest.getKey());
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            log.warn((Object)"Cannot unregister cache interests", (Throwable)ex);
        }
        if (region != null) {
            if (this.close) {
                if (!region.getRegionService().isClosed()) {
                    try {
                        region.close();
                    }
                    catch (CacheClosedException cacheClosedException) {}
                }
            } else if (this.destroy) {
                region.destroyRegion();
            }
        }
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setInterests(Interest<K>[] interests) {
        this.interests = interests;
    }

    Interest<K>[] getInterests() {
        return this.interests;
    }

    public void setPool(Pool pool) {
        Assert.notNull((Object)pool, (String)"pool cannot be null");
        this.setPoolName(pool.getName());
    }

    public void setPoolName(String poolName) {
        Assert.hasText((String)poolName, (String)"pool name is required");
        this.poolName = poolName;
    }

    final boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
        this.destroy = this.destroy && !close;
    }

    final boolean isDestroy() {
        return this.destroy;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
        this.close = this.close && !destroy;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    public void setDataPolicyName(String dataPolicyName) {
        DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicyName);
        Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicyName));
        this.setDataPolicy(resolvedDataPolicy);
    }

    protected boolean isPersistentUnspecified() {
        return this.persistent == null;
    }

    protected boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    protected boolean isNotPersistent() {
        return Boolean.FALSE.equals(this.persistent);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setShortcut(ClientRegionShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public void setSnapshot(Resource snapshot) {
        this.snapshot = snapshot;
    }
}

