/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.repository.Query;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GemfireQueryMethod
extends QueryMethod {
    private final Method method;
    private final GemfirePersistentEntity<?> entity;

    public GemfireQueryMethod(Method method, RepositoryMetadata metadata, MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> context) {
        super(method, metadata);
        Assert.notNull(context);
        for (Class<?> type : method.getParameterTypes()) {
            if (!Pageable.class.isAssignableFrom(type)) continue;
            throw new IllegalStateException("Pagination is not supported by Gemfire repositories! Offending method: " + method.toString());
        }
        this.method = method;
        this.entity = (GemfirePersistentEntity)context.getPersistentEntity(this.getDomainClass());
    }

    public boolean hasAnnotatedQuery() {
        return StringUtils.hasText((String)this.getAnnotatedQuery());
    }

    public GemfirePersistentEntity<?> getPersistentEntity() {
        return this.entity;
    }

    String getAnnotatedQuery() {
        Query query = this.method.getAnnotation(Query.class);
        String queryString = query == null ? null : (String)AnnotationUtils.getValue((Annotation)query);
        return StringUtils.hasText((String)queryString) ? queryString : null;
    }
}

