/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.pdx.JSONFormatter;
import com.gemstone.gemfire.pdx.PdxInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.util.CollectionUtils;

@Aspect
public class JSONRegionAdvice {
    private static Log log = LogFactory.getLog(JSONRegionAdvice.class);
    private List<String> includedRegions;
    private boolean convertReturnedCollections = true;
    private boolean prettyPrint = false;

    public void setIncludedRegionNames(List<String> regionNames) {
        this.includedRegions = regionNames;
    }

    public void setIncludedRegions(List<Region<?, ?>> regions) {
        this.includedRegions = new ArrayList<String>();
        for (Region<?, ?> region : regions) {
            this.includedRegions.add(region.getName());
        }
    }

    public void setConvertReturnedCollections(boolean convertReturnedCollections) {
        this.convertReturnedCollections = convertReturnedCollections;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Around(value="execution(* com.gemstone.gemfire.cache.Region.put(..)) || execution(* com.gemstone.gemfire.cache.Region.create(..)) ||execution(* com.gemstone.gemfire.cache.Region.putIfAbsent(..)) ||execution(* com.gemstone.gemfire.cache.Region.replace(..))")
    public Object put(ProceedingJoinPoint pjp) {
        boolean JSONRegion = this.isIncludedSONRegion(pjp.getTarget());
        Object retVal = null;
        try {
            if (JSONRegion) {
                Object[] newArgs = Arrays.copyOf(pjp.getArgs(), pjp.getArgs().length);
                Object val = newArgs[1];
                newArgs[1] = this.convertArgumentToPdxInstance(val);
                retVal = pjp.proceed(newArgs);
                log.debug((Object)("converting " + retVal + " to JSON string"));
                retVal = this.convertPdxInstanceToJSONString(retVal);
            } else {
                retVal = pjp.proceed();
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return retVal;
    }

    @Around(value="execution(* com.gemstone.gemfire.cache.Region.putAll(..))")
    public Object putAll(ProceedingJoinPoint pjp) {
        boolean JSONRegion = this.isIncludedSONRegion(pjp.getTarget());
        Object retVal = null;
        try {
            if (JSONRegion) {
                Object[] newArgs = Arrays.copyOf(pjp.getArgs(), pjp.getArgs().length);
                Map val = (Map)newArgs[0];
                HashMap newArg = new HashMap();
                for (Map.Entry entry : val.entrySet()) {
                    newArg.put(entry.getKey(), this.convertArgumentToPdxInstance(entry.getValue()));
                }
                newArgs[0] = newArg;
                retVal = pjp.proceed(newArgs);
            } else {
                retVal = pjp.proceed();
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return retVal;
    }

    @Around(value="execution(* com.gemstone.gemfire.cache.Region.get(..)) || execution(* com.gemstone.gemfire.cache.Region.selectValue(..))|| execution(* com.gemstone.gemfire.cache.Region.remove(..))")
    public Object get(ProceedingJoinPoint pjp) {
        Object retVal = null;
        try {
            if (this.isIncludedSONRegion(pjp.getTarget())) {
                retVal = pjp.proceed();
                log.debug((Object)("converting " + retVal + " to JSON string"));
                retVal = this.convertPdxInstanceToJSONString(retVal);
            } else {
                retVal = pjp.proceed();
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return retVal;
    }

    @Around(value="execution(* com.gemstone.gemfire.cache.Region.getAll(..))")
    public Map<Object, Object> getAll(ProceedingJoinPoint pjp) {
        HashMap result = null;
        try {
            HashMap retVal = (HashMap)pjp.proceed();
            if (!this.convertReturnedCollections || CollectionUtils.isEmpty((Map)retVal) || !this.isIncludedSONRegion(pjp.getTarget())) {
                result = retVal;
            } else {
                result = new HashMap();
                for (Map.Entry entry : retVal.entrySet()) {
                    result.put(entry.getKey(), this.convertPdxInstanceToJSONString(entry.getValue()));
                }
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return result;
    }

    @Around(value="execution(* com.gemstone.gemfire.cache.Region.values(..))")
    public Collection<Object> values(ProceedingJoinPoint pjp) {
        ArrayList<PdxInstance> result = null;
        try {
            ArrayList<PdxInstance> retVal = (ArrayList<PdxInstance>)pjp.proceed();
            if (!this.convertReturnedCollections || CollectionUtils.isEmpty((Collection)retVal) || !this.isIncludedSONRegion(pjp.getTarget())) {
                result = retVal;
            } else {
                result = new ArrayList<PdxInstance>();
                for (Object e : retVal) {
                    result.add(this.convertArgumentToPdxInstance(e));
                }
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return result;
    }

    @Around(value="execution(* org.springframework.data.gemfire.GemfireOperations.find(..)) || execution(* org.springframework.data.gemfire.GemfireOperations.findUnique(..)) || execution(* org.springframework.data.gemfire.GemfireOperations.query(..))")
    public Object templateQuery(ProceedingJoinPoint pjp) {
        GemfireTemplate template = (GemfireTemplate)pjp.getTarget();
        boolean jsonRegion = this.isIncludedSONRegion(template.getRegion());
        Object retVal = null;
        try {
            if (jsonRegion) {
                retVal = pjp.proceed();
                if (retVal instanceof SelectResults && this.convertReturnedCollections) {
                    ResultsBag resultsBag = new ResultsBag();
                    for (Object obj : (SelectResults)retVal) {
                        resultsBag.add(this.convertPdxInstanceToJSONString(obj));
                    }
                    retVal = resultsBag;
                } else {
                    retVal = this.convertPdxInstanceToJSONString(retVal);
                }
            } else {
                retVal = pjp.proceed();
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return retVal;
    }

    private PdxInstance convertArgumentToPdxInstance(Object value) {
        PdxInstance val = null;
        if (value instanceof PdxInstance) {
            val = (PdxInstance)value;
        } else if (value instanceof String) {
            val = JSONFormatter.fromJSON((String)((String)value));
        } else {
            ObjectMapper mapper = new ObjectMapper();
            try {
                String json = mapper.writeValueAsString(value);
                val = JSONFormatter.fromJSON((String)json);
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
        }
        return val;
    }

    private boolean isIncludedSONRegion(Object target) {
        Region region = (Region)target;
        boolean result = false;
        if (this.includedRegions == null || this.includedRegions.contains(region.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(region.getName() + " is included for JSON conversion"));
            }
            result = true;
        }
        return result;
    }

    private Object convertPdxInstanceToJSONString(Object retVal) {
        Object result = retVal;
        if (retVal != null && retVal instanceof PdxInstance) {
            result = JSONFormatter.toJSON((PdxInstance)((PdxInstance)retVal));
            if (!this.prettyPrint) {
                result = this.flattenString(result);
            }
        }
        return result;
    }

    private Object flattenString(Object result) {
        if (result instanceof String) {
            String json = (String)result;
            return json.replaceAll("\\s*", "");
        }
        return result;
    }

    private void handleThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }
}

